/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.conversion;

import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.MonetaryOperator;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.CurrencyConversionException;
import javax.money.convert.ExchangeRate;
import javax.money.convert.MonetaryConversions;
import org.javamoney.tck.tests.internal.TestCurrencyUnit;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.1.0")
public class ConvertingAmountsTest {
    @Test(description="4.3.2 Test successful conversion for CHF -> FOO, using TestRateProvider.")
    @SpecAssertion(id="432-A1", section="4.3.2")
    public void testConversion() {
        TestCurrencyUnit cu = new TestCurrencyUnit("FOO");
        CurrencyConversion conv = MonetaryConversions.getConversion((CurrencyUnit)cu, (String[])new String[]{"TestRateProvider"});
        MonetaryAmount m = Monetary.getDefaultAmountFactory().setNumber(10L).setCurrency("CHF").create();
        MonetaryAmount m2 = m.with((MonetaryOperator)conv);
        AssertJUnit.assertEquals((String)m2.getCurrency().getCurrencyCode(), (String)"FOO");
        AssertJUnit.assertEquals((long)20L, (long)m2.getNumber().longValueExact());
        m2 = m.with((MonetaryOperator)conv);
        AssertJUnit.assertEquals((String)m2.getCurrency().getCurrencyCode(), (String)"FOO");
        AssertJUnit.assertEquals((long)20L, (long)m2.getNumber().longValueExact());
    }

    @Test(description="4.3.2 Test correct ExchangeRate is returned for CHF -> FOO, using TestRateProvider.")
    @SpecAssertion(id="432-A2", section="4.3.2")
    public void testConversionComparedWithRate() {
        TestCurrencyUnit FOO = new TestCurrencyUnit("FOO");
        ExchangeRate rate = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider"}).getExchangeRate(Monetary.getCurrency((String)"CHF", (String[])new String[0]), (CurrencyUnit)FOO);
        AssertJUnit.assertEquals((Object)rate.getBaseCurrency(), (Object)Monetary.getCurrency((String)"CHF", (String[])new String[0]));
        AssertJUnit.assertEquals((String)rate.getCurrency().getCurrencyCode(), (String)FOO.getCurrencyCode());
        AssertJUnit.assertEquals((int)rate.getFactor().intValueExact(), (int)2);
        AssertJUnit.assertEquals((String)"TestRateProvider", (String)rate.getContext().getProviderName());
    }

    @Test(description="4.3.2 Bad case: Try CurrencyConversion to an inconvertible (custom) currency (FOOANY), ensure CurrencyConversionException is thrown.")
    @SpecAssertion(id="432-A3", section="4.3.2")
    public void testUnsupportedConversion() {
        MonetaryAmount m = Monetary.getDefaultAmountFactory().setNumber(10L).setCurrency("CHF").create();
        TestCurrencyUnit cu = new TestCurrencyUnit("FOOANY");
        try {
            CurrencyConversion conv = MonetaryConversions.getConversion((CurrencyUnit)cu, (String[])new String[0]);
            m.with((MonetaryOperator)conv);
        }
        catch (CurrencyConversionException currencyConversionException) {
            // empty catch block
        }
    }

    @Test(expectedExceptions={NullPointerException.class}, description="4.3.2 Bad case: Access CurrencyConversion with a CurrencyUnit==null, ensure NullPointerException is thrown.")
    @SpecAssertion(id="432-A4", section="4.3.2")
    public void testNullConversion1() {
        MonetaryConversions.getConversion((CurrencyUnit)null, (String[])new String[0]);
    }

    @Test(expectedExceptions={NullPointerException.class}, description="4.3.2 Bad case: Access CurrencyConversion with a currency code==null, ensure NullPointerException is thrown.")
    @SpecAssertion(id="432-A4", section="4.3.2")
    public void testNullConversion2() {
        MonetaryConversions.getConversion((String)null, (String[])new String[0]);
    }
}

