/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.conversion;

import java.util.Locale;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.UnknownCurrencyException;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.MonetaryConversions;
import org.javamoney.tck.tests.internal.TestCurrencyUnit;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.1.0")
public class ExchangeRatesAndRateProvidersTest {
    private static final CurrencyUnit FOO_UNIT = new TestCurrencyUnit("FOO");

    @Test(description="4.3.3 Test access of Conversion Rates, using TCK provided rate provider.")
    @SpecAssertion(id="433-A1", section="4.3.3")
    public void testAccessKnownRates() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider"});
        for (CurrencyUnit base : Monetary.getCurrencies((String[])new String[0])) {
            if (base.equals(FOO_UNIT)) continue;
            ExchangeRate rate = prov.getExchangeRate(base, FOO_UNIT);
            AssertJUnit.assertNotNull((Object)("Identity rate, accessed by getExchangeRate(CurrencyUnit, CurrencyUnit), is not defined for " + base.getCurrencyCode() + " -> " + FOO_UNIT.getCurrencyCode()));
            AssertJUnit.assertEquals((String)rate.getBaseCurrency().getCurrencyCode(), (String)base.getCurrencyCode());
            AssertJUnit.assertEquals((String)rate.getCurrency().getCurrencyCode(), (String)FOO_UNIT.getCurrencyCode());
            AssertJUnit.assertEquals((int)rate.getFactor().intValueExact(), (int)2);
        }
    }

    @Test(description="4.3.3 Test access to exchange rates from TestRateProvider, using target currency code.")
    @SpecAssertion(id="433-A1", section="4.3.3")
    public void testAccessKnownRatesWithCodes() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider"});
        for (CurrencyUnit base : Monetary.getCurrencies((String[])new String[0])) {
            if (base.equals(FOO_UNIT)) continue;
            ExchangeRate rate = prov.getExchangeRate(base.getCurrencyCode(), "XXX");
            AssertJUnit.assertNotNull((String)("Identity rate, accessed by getExchangeRate(String, String), is not defined for " + base.getCurrencyCode() + " -> " + FOO_UNIT.getCurrencyCode()), (Object)rate);
            AssertJUnit.assertEquals((String)rate.getBaseCurrency().getCurrencyCode(), (String)base.getCurrencyCode());
            AssertJUnit.assertEquals((String)rate.getCurrency().getCurrencyCode(), (String)"FOO");
            AssertJUnit.assertEquals((int)rate.getFactor().intValueExact(), (int)2);
        }
    }

    @Test(description="4.3.3 Test access to exchange rates from TestRateProvider, using target CUrrencyUnit.")
    @SpecAssertion(id="433-A1", section="4.3.3")
    public void testAccessKnownRatesAndContext() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider"});
        for (CurrencyUnit base : Monetary.getCurrencies((String[])new String[0])) {
            if (base.equals(FOO_UNIT)) continue;
            ExchangeRate rate = prov.getExchangeRate(base, FOO_UNIT);
            AssertJUnit.assertNotNull((Object)("Identity rate, accessed by getExchangeRate(CurrencyUnit, CurrencyUnit, ConversionContext), is not defined for " + base.getCurrencyCode() + " -> " + FOO_UNIT.getCurrencyCode()));
            AssertJUnit.assertEquals((String)rate.getBaseCurrency().getCurrencyCode(), (String)base.getCurrencyCode());
            AssertJUnit.assertEquals((String)rate.getCurrency().getCurrencyCode(), (String)FOO_UNIT.getCurrencyCode());
            AssertJUnit.assertEquals((int)rate.getFactor().intValueExact(), (int)2);
        }
    }

    @Test(description="4.3.3  Test access to conversion rates, including known factor, using TestRateProvider.")
    @SpecAssertion(id="433-A1", section="4.3.3")
    public void testAccessKnownRatesWithCodesAndContext() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider"});
        for (CurrencyUnit base : Monetary.getCurrencies((String[])new String[0])) {
            ExchangeRate rate = prov.getExchangeRate(base, FOO_UNIT);
            AssertJUnit.assertNotNull((String)("Identity rate, accessed by getExchangeRate(String, String, ConversionContext), is not defined for " + base.getCurrencyCode() + " -> " + FOO_UNIT.getCurrencyCode()), (Object)rate);
            AssertJUnit.assertEquals((String)rate.getBaseCurrency().getCurrencyCode(), (String)base.getCurrencyCode());
            AssertJUnit.assertEquals((String)rate.getCurrency().getCurrencyCode(), (String)FOO_UNIT.getCurrencyCode());
            AssertJUnit.assertEquals((int)rate.getFactor().intValueExact(), (int)2);
        }
    }

    @Test(description="4.3.3 Test access to identity conversion rate for CurrencyUnits, using default provider")
    @SpecAssertion(id="433-A1", section="4.3.3")
    public void testAccessRates_IdentityRatesWithUnits() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[0]);
        for (CurrencyUnit unit : Monetary.getCurrencies((String[])new String[0])) {
            ExchangeRate rate = prov.getExchangeRate(unit, unit);
            AssertJUnit.assertNotNull((String)("Identity rate, accessed by getExchangeRate(CurrencyUnit, CurrencyUnit), is not defined for " + unit.getCurrencyCode()), (Object)rate);
        }
    }

    @Test(description="4.3.3 Test access to conversion rate for currency codes, using default provider.")
    @SpecAssertion(id="433-A1", section="4.3.3")
    public void testAccessRates_IdentityRatesWithCodes() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[0]);
        for (CurrencyUnit unit : Monetary.getCurrencies((String[])new String[0])) {
            ExchangeRate rate = prov.getExchangeRate(unit.getCurrencyCode(), unit.getCurrencyCode());
            AssertJUnit.assertNotNull((String)("Identity rate, accessed by getExchangeRate(String, String), is not defined for " + unit.getCurrencyCode()), (Object)rate);
        }
    }

    @Test(description="4.3.3 Test access to conversion rate for CurrencyQuery, using default provider.")
    @SpecAssertion(id="433-A1", section="4.3.3")
    public void testAccessRates_IdentityRatesWithUnitsAndContext() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[0]);
        for (CurrencyUnit unit : Monetary.getCurrencies((String[])new String[0])) {
            ExchangeRate rate = prov.getExchangeRate(ConversionQueryBuilder.of().setBaseCurrency(unit).setTermCurrency(unit).build());
            AssertJUnit.assertNotNull((String)("Identity rate, accessed by getExchangeRate(ConversionQuery), is not defined for " + unit.getCurrencyCode()), (Object)rate);
        }
    }

    @Test(description="4.3.3 Ensure additional ConversionQuery data is passed correctly to SPIs.")
    @SpecAssertion(id="433-A2", section="4.3.3")
    public void testPassingOverConversionContextToSPIs() {
        ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider"});
        ConversionQuery ctx = ((ConversionQueryBuilder)((ConversionQueryBuilder)ConversionQueryBuilder.of().set((Object)Locale.CANADA)).set("Foo", (Object)"bar")).setBaseCurrency(FOO_UNIT).setTermCurrency(Monetary.getCurrency((String)"XXX", (String[])new String[0])).build();
        ExchangeRate rate = prov.getExchangeRate(ctx);
        AssertJUnit.assertNotNull((Object)"No test rate returned by getExchangeRate(ConversionQuery), probably TestProvider is not correct registered.");
        AssertJUnit.assertEquals((String)"Text parameter Locale.class was not correctly passed to ExchangeRateProvider implementation.", (String)"bar", (String)rate.getContext().getText("Foo"));
        AssertJUnit.assertEquals((String)"Object parameter Locale.class was not correctly passed to ExchangeRateProvider implementation.", (Object)Locale.CANADA, (Object)rate.getContext().get(Locale.class));
    }

    @Test(description="4.3.3 Bad case: try accessing exchange rates with invalid base currency code.")
    @SpecAssertion(id="433-A3", section="4.3.3")
    public void testInvalidUsage_InvalidSourceCurrency() {
        for (String providerID : MonetaryConversions.getConversionProviderNames()) {
            if ("TestRateProvider".equals(providerID)) continue;
            ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{providerID});
            try {
                prov.getExchangeRate("dhdjbdjd", "CHF");
                Assert.fail((String)("ExchangeRateProvider should throw UnknownCurrencyException when an invalid source currency is passed to getExchangeRate(String,String), provider: " + providerID));
            }
            catch (UnknownCurrencyException unknownCurrencyException) {}
        }
    }

    @Test(description="4.3.3 Bad case: try accessing exchange rates with null base currency code.")
    @SpecAssertion(id="433-A3", section="4.3.3")
    public void testInvalidUsage_NullSourceCurrency() {
        for (String providerID : MonetaryConversions.getConversionProviderNames()) {
            if ("TestRateProvider".equals(providerID)) continue;
            ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{providerID});
            try {
                prov.getExchangeRate(null, "CHF");
                Assert.fail((String)("ExchangeRateProvider should throw NullPointerException when an null source currency is passed to getExchangeRate(String,String), provider: " + providerID));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.3.3 Bad case: try accessing exchange rates with invalid term currency code.")
    @SpecAssertion(id="433-A3", section="4.3.3")
    public void testInvalidUsage_InvalidTargetCurrency() {
        for (String providerID : MonetaryConversions.getConversionProviderNames()) {
            if ("TestRateProvider".equals(providerID)) continue;
            ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{providerID});
            try {
                prov.getExchangeRate("CHF", "dhdjbdjd");
                Assert.fail((String)("ExchangeRateProvider should throw UnknownCurrencyException when an invalid target currency is passed to getExchangeRate(String,String), provider: " + providerID));
            }
            catch (UnknownCurrencyException unknownCurrencyException) {}
        }
    }

    @Test(description="4.3.3 Bad case: try accessing exchange rates with null term currency code.")
    @SpecAssertion(id="433-A3", section="4.3.3")
    public void testInvalidUsage_NullTargetCurrency() {
        for (String providerID : MonetaryConversions.getConversionProviderNames()) {
            if ("TestRateProvider".equals(providerID)) continue;
            ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{providerID});
            try {
                prov.getExchangeRate("CHF", null);
                Assert.fail((String)("ExchangeRateProvider should throw NullPointerException when an null target currency is passed to getExchangeRate(String,String), provider: " + providerID));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.3.3 Bad case: try accessing exchange rates with null ConversionQuery.")
    @SpecAssertion(id="433-A3", section="4.3.3")
    public void testInvalidUsage_InvalidSourceCurrencyAndContext() {
        for (String providerID : MonetaryConversions.getConversionProviderNames()) {
            if ("TestRateProvider".equals(providerID)) continue;
            ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{providerID});
            try {
                prov.getExchangeRate(null);
                Assert.fail((String)("ExchangeRateProvider should throw NPE when an null ConversionQuery is passed to getExchangeRate(ConversionQuery), provider: " + providerID));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.3.3 Bad case: try accessing exchange rates with null base CurrencyUnit.")
    @SpecAssertion(id="433-A3", section="4.3.3")
    public void testInvalidUsage_NullSourceCurrencyUnit() {
        for (String providerID : MonetaryConversions.getConversionProviderNames()) {
            ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{providerID});
            try {
                prov.getExchangeRate(null, Monetary.getCurrency((String)"CHF", (String[])new String[0]));
                Assert.fail((String)("ExchangeRateProvider should throw NullPointerException when an null source currency is passed to getExchangeRate(CurrencyUnit,CurrencyUnit), provider: " + providerID));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }

    @Test(description="4.3.3 Bad case: try accessing exchange rates with null term CurrencyUnit.")
    @SpecAssertion(id="433-A3", section="4.3.3")
    public void testInvalidUsage_NullTargetCurrencyUnit() {
        for (String providerID : MonetaryConversions.getConversionProviderNames()) {
            ExchangeRateProvider prov = MonetaryConversions.getExchangeRateProvider((String[])new String[]{providerID});
            try {
                prov.getExchangeRate(Monetary.getCurrency((String)"CHF", (String[])new String[0]), null);
                Assert.fail((String)("ExchangeRateProvider should throw NullPointerException when an invalid target currency is passed to getExchangeRate(CurrencyUnit,CurrencyUnit), provider: " + providerID));
            }
            catch (NullPointerException nullPointerException) {}
        }
    }
}

