/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.conversion;

import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.MonetaryConversions;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.1.0")
public class ProviderChainsTest {
    @Test(description="4.3.4 Test correct rate evaluation for different conversion provider chains.")
    @SpecAssertion(id="434-A1", section="4.3.4")
    public void testCorrectRateEvaluationInChain_diffProviders() {
        ExchangeRateProvider prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider1", "TestRateProvider2", "TestRateProvider3"});
        ExchangeRate rate = prov1.getExchangeRate("CHF", "EUR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)1);
        prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider1", "TestRateProvider2"});
        rate = prov1.getExchangeRate("EUR", "USD");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)2);
        prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider3"});
        rate = prov1.getExchangeRate("USD", "INR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)3);
        prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider1", "TestRateProvider3", "TestRateProvider2"});
        rate = prov1.getExchangeRate("CHF", "EUR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)1);
        rate = prov1.getExchangeRate("EUR", "USD");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)2);
        rate = prov1.getExchangeRate("USD", "INR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)3);
        prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider3", "TestRateProvider2", "TestRateProvider1"});
        rate = prov1.getExchangeRate("CHF", "EUR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)1);
        prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider2", "TestRateProvider1", "TestRateProvider3"});
        rate = prov1.getExchangeRate("EUR", "USD");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)2);
        rate = prov1.getExchangeRate("USD", "INR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)3);
        prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider3", "TestRateProvider2", "TestRateProvider1", "TestRateProvider02"});
        rate = prov1.getExchangeRate("CHF", "EUR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)1);
        rate = prov1.getExchangeRate("EUR", "USD");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)2);
        rate = prov1.getExchangeRate("USD", "INR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)3);
        rate = prov1.getExchangeRate("INR", "GBP");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (Object)rate.getFactor().doubleValue(), (Object)0.2);
    }

    @Test(description="4.3.4 Test correct rate evaluation for different conversion provider chains, with duplicate provider entries.")
    @SpecAssertion(id="434-A1", section="4.3.4")
    public void testCorrectRateEvaluationInChain_sameProviders() {
        ExchangeRateProvider prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider1", "TestRateProvider1", "TestRateProvider1"});
        ExchangeRate rate = prov1.getExchangeRate("CHF", "EUR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)1);
        prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider1", "TestRateProvider1"});
        rate = prov1.getExchangeRate("CHF", "EUR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)1);
        prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider1"});
        rate = prov1.getExchangeRate("CHF", "EUR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)1);
    }

    @Test(description="4.3.4 Test correct rate evaluation for different conversion provider chains, with historic rates.")
    @SpecAssertion(id="434-A2", section="4.3.4")
    public void testCorrectRateEvaluationInChainHistoric() {
        ExchangeRateProvider prov1 = MonetaryConversions.getExchangeRateProvider((String[])new String[]{"TestRateProvider1", "TestRateProvider2", "TestRateProvider3"});
        ExchangeRate rate = prov1.getExchangeRate("CHF", "EUR");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)1);
        rate = prov1.getExchangeRate("EUR", "USD");
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)rate.getFactor().intValueExact(), (int)2);
        Calendar cal = GregorianCalendar.getInstance();
        cal.setTimeInMillis(0L);
        rate = prov1.getExchangeRate(((ConversionQueryBuilder)ConversionQueryBuilder.of().set((Object)cal)).setBaseCurrency("EUR").setTermCurrency("USD").build());
        AssertJUnit.assertEquals((String)"Invalid ExchangeRateProvider selected.", (int)2, (int)rate.getFactor().intValueExact());
    }

    @Test(description="4.3.4 Test availability of TCK provided providers.")
    @SpecAssertion(id="434-A3", section="4.3.4")
    public void testTCKRateChainAvailability() {
        Collection provNames = MonetaryConversions.getConversionProviderNames();
        AssertJUnit.assertTrue((String)"TCK ExchangeRateProvider is not registered: TestRateProvider", (boolean)provNames.contains("TestRateProvider"));
        AssertJUnit.assertTrue((String)"TCK ExchangeRateProvider is not registered:TestRateProvider1", (boolean)provNames.contains("TestRateProvider1"));
        AssertJUnit.assertTrue((String)"TCK ExchangeRateProvider is not registered: TestRateProvider2", (boolean)provNames.contains("TestRateProvider2"));
        AssertJUnit.assertTrue((String)"TCK ExchangeRateProvider is not registered: TestRateProvider3", (boolean)provNames.contains("TestRateProvider3"));
        AssertJUnit.assertTrue((String)"TCK ExchangeRateProvider is not registered: TestRateProvider02", (boolean)provNames.contains("TestRateProvider02"));
    }
}

