/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.util.Objects;
import javax.money.NumberValue;

public final class TestNumberValue
extends NumberValue {
    private static final long serialVersionUID = 1L;
    private BigDecimal value;

    public TestNumberValue(Number value) {
        Objects.requireNonNull(value);
        this.value = new BigDecimal(String.valueOf(value));
    }

    public long longValue() {
        return this.value.longValue();
    }

    public int intValue() {
        return this.value.intValue();
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public <T extends Number> T numberValueExact(Class<T> numberType) {
        return null;
    }

    public long getAmountFractionNumerator() {
        return 0L;
    }

    public long getAmountFractionDenominator() {
        return 0L;
    }

    public <T extends Number> T numberValue(Class<T> numberType) {
        if (numberType.equals(Integer.class)) {
            return (T)Integer.valueOf(this.value.intValue());
        }
        if (numberType.equals(BigInteger.class)) {
            return (T)BigInteger.valueOf(this.value.intValue());
        }
        if (numberType.equals(BigDecimal.class)) {
            return (T)BigDecimal.valueOf(this.value.doubleValue());
        }
        throw new UnsupportedOperationException(numberType.getCanonicalName());
    }

    public NumberValue round(MathContext mathContext) {
        return new TestNumberValue(this.value.round(mathContext));
    }

    public long longValueExact() {
        return this.value.longValue();
    }

    public int intValueExact() {
        return this.value.intValue();
    }

    public int getScale() {
        return this.value.scale();
    }

    public int getPrecision() {
        return this.value.precision();
    }

    public Class<?> getNumberType() {
        return BigDecimal.class;
    }

    public double doubleValueExact() {
        return this.value.doubleValue();
    }

    public String toString() {
        return this.value.toString();
    }
}

