/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.internal;

import java.util.Objects;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import javax.money.MonetaryAmount;
import javax.money.convert.ConversionContext;
import javax.money.convert.ConversionContextBuilder;
import javax.money.convert.ConversionQuery;
import javax.money.convert.ConversionQueryBuilder;
import javax.money.convert.CurrencyConversion;
import javax.money.convert.ExchangeRate;
import javax.money.convert.ExchangeRateProvider;
import javax.money.convert.ProviderContext;
import javax.money.convert.ProviderContextBuilder;
import javax.money.convert.RateType;
import org.javamoney.tck.tests.conversion.TestExchangeRate;
import org.javamoney.tck.tests.internal.TestNumberValue;

public class TestRateProvider3
implements ExchangeRateProvider {
    public static final int FACTOR = 3;
    private static final ProviderContext PC = ProviderContextBuilder.of((String)"TestRateProvider3", (RateType)RateType.OTHER, (RateType[])new RateType[0]).build();
    private static final ConversionContext CC = ConversionContextBuilder.create((ProviderContext)PC, (RateType)RateType.OTHER).build();

    public ProviderContext getContext() {
        return PC;
    }

    public boolean isAvailable(ConversionQuery query) {
        Objects.requireNonNull(query);
        Objects.requireNonNull(query.getBaseCurrency());
        Objects.requireNonNull(query.getCurrency());
        return "USD".equals(query.getBaseCurrency().getCurrencyCode());
    }

    public ExchangeRate getExchangeRate(CurrencyUnit base, CurrencyUnit term) {
        return this.getExchangeRate(ConversionQueryBuilder.of().setBaseCurrency(base).setTermCurrency(term).build());
    }

    public CurrencyConversion getCurrencyConversion(CurrencyUnit term) {
        return new Conversion(term);
    }

    public boolean isAvailable(CurrencyUnit base, CurrencyUnit term) {
        return this.isAvailable(ConversionQueryBuilder.of().setBaseCurrency(base).setTermCurrency(term).build());
    }

    public boolean isAvailable(String baseCode, String termCode) {
        return this.isAvailable(ConversionQueryBuilder.of().setBaseCurrency(Monetary.getCurrency((String)baseCode, (String[])new String[0])).setTermCurrency(Monetary.getCurrency((String)termCode, (String[])new String[0])).build());
    }

    public ExchangeRate getExchangeRate(String baseCode, String termCode) {
        return this.getExchangeRate(ConversionQueryBuilder.of().setBaseCurrency(Monetary.getCurrency((String)baseCode, (String[])new String[0])).setTermCurrency(Monetary.getCurrency((String)termCode, (String[])new String[0])).build());
    }

    public ExchangeRate getReversed(ExchangeRate rate) {
        ConversionQuery reverseQuery = rate.getContext().toQueryBuilder().setBaseCurrency(rate.getCurrency()).setTermCurrency(rate.getBaseCurrency()).build();
        if (this.isAvailable(reverseQuery)) {
            return this.getExchangeRate(reverseQuery);
        }
        return null;
    }

    public CurrencyConversion getCurrencyConversion(String termCode) {
        return new Conversion(Monetary.getCurrency((String)termCode, (String[])new String[0]));
    }

    public ExchangeRate getExchangeRate(ConversionQuery query) {
        if (this.isAvailable(query)) {
            return new TestExchangeRate.Builder(PC.getProviderName(), RateType.OTHER).setFactor(new TestNumberValue(3)).setBase(query.getBaseCurrency()).setTerm(query.getCurrency()).build();
        }
        return null;
    }

    public CurrencyConversion getCurrencyConversion(ConversionQuery conversionQuery) {
        Objects.requireNonNull(conversionQuery);
        Objects.requireNonNull(conversionQuery.getCurrency());
        return new Conversion(conversionQuery.getCurrency());
    }

    private static final class Conversion
    implements CurrencyConversion {
        private CurrencyUnit term;

        private Conversion(CurrencyUnit term) {
            Objects.requireNonNull(term);
            this.term = term;
        }

        public CurrencyUnit getCurrency() {
            return this.term;
        }

        public ConversionContext getContext() {
            return CC;
        }

        public ExchangeRate getExchangeRate(MonetaryAmount sourceAmount) {
            return new TestExchangeRate.Builder(CC).setFactor(new TestNumberValue(3)).setBase(sourceAmount.getCurrency()).setTerm(this.term).build();
        }

        public MonetaryAmount apply(MonetaryAmount value) {
            return value.multiply(3L).getFactory().setCurrency(this.term).create();
        }

        public ExchangeRateProvider getExchangeRateProvider() {
            return null;
        }
    }
}

