/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.internal;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.money.CurrencyUnit;
import javax.money.MonetaryAmount;
import javax.money.MonetaryRounding;
import javax.money.RoundingContext;
import javax.money.RoundingContextBuilder;
import javax.money.RoundingQuery;
import javax.money.spi.RoundingProviderSpi;

public class TestRoundingProvider
implements RoundingProviderSpi {
    private static final RoundingContext CONTEXT = RoundingContextBuilder.of((String)TestRoundingProvider.class.getSimpleName(), (String)"NOSCALE").build();
    private static final RoundingContext CONTEXT_CASH = RoundingContextBuilder.of((String)TestRoundingProvider.class.getSimpleName(), (String)"cashRounding").build();
    private Map<String, MonetaryRounding> customRoundings = new HashMap<String, MonetaryRounding>();

    public TestRoundingProvider() {
        this.customRoundings.put("NOSCALE", new MonetaryRounding(){

            public RoundingContext getRoundingContext() {
                return CONTEXT;
            }

            public MonetaryAmount apply(MonetaryAmount value) {
                return value.getFactory().setNumber((Number)((BigDecimal)value.getNumber().numberValue(BigDecimal.class)).setScale(0, RoundingMode.HALF_EVEN)).create();
            }
        });
    }

    public MonetaryRounding getRounding(RoundingQuery context) {
        MonetaryRounding customRounding = this.customRoundings.get(context.getRoundingName());
        if (customRounding != null) {
            return customRounding;
        }
        if (context.getCurrency() == null) {
            return null;
        }
        Boolean cashRounding = context.getBoolean("cashRounding");
        if (cashRounding == null) {
            cashRounding = Boolean.FALSE;
        }
        Calendar timestamp = (Calendar)context.get(Calendar.class);
        if (cashRounding.booleanValue()) {
            if (timestamp != null) {
                return this.getCashRounding(context.getCurrency(), timestamp);
            }
            return this.getCashRounding(context.getCurrency());
        }
        if ("XAU".equals(context.getCurrency().getCurrencyCode())) {
            if (timestamp != null) {
                return new MonetaryRounding(){

                    public RoundingContext getRoundingContext() {
                        return CONTEXT;
                    }

                    public MonetaryAmount apply(MonetaryAmount value) {
                        return value.getFactory().setNumber((Number)((BigDecimal)value.getNumber().numberValue(BigDecimal.class)).setScale(2, RoundingMode.UP)).create();
                    }
                };
            }
            return new MonetaryRounding(){

                public RoundingContext getRoundingContext() {
                    return CONTEXT;
                }

                public MonetaryAmount apply(MonetaryAmount value) {
                    return value.getFactory().setNumber((Number)((BigDecimal)value.getNumber().numberValue(BigDecimal.class)).setScale(4, RoundingMode.UP)).create();
                }
            };
        }
        return null;
    }

    private MonetaryRounding getCashRounding(CurrencyUnit currency) {
        if ("XAU".equals(currency.getCurrencyCode())) {
            return new MonetaryRounding(){

                public RoundingContext getRoundingContext() {
                    return CONTEXT_CASH;
                }

                public MonetaryAmount apply(MonetaryAmount value) {
                    return value.getFactory().setNumber((Number)((BigDecimal)value.getNumber().numberValue(BigDecimal.class)).setScale(1, RoundingMode.DOWN)).create();
                }
            };
        }
        return null;
    }

    private MonetaryRounding getCashRounding(CurrencyUnit currency, Calendar timestamp) {
        if ("XAU".equals(currency.getCurrencyCode()) && timestamp.get(1) < 1972) {
            return new MonetaryRounding(){

                public RoundingContext getRoundingContext() {
                    return CONTEXT_CASH;
                }

                public MonetaryAmount apply(MonetaryAmount value) {
                    return value.getFactory().setNumber((Number)((BigDecimal)value.getNumber().numberValue(BigDecimal.class)).setScale(2, RoundingMode.DOWN)).create();
                }
            };
        }
        return null;
    }

    public Set<String> getRoundingNames() {
        return this.customRoundings.keySet();
    }

    public String getProviderName() {
        return this.getClass().getSimpleName();
    }
}

