/*
 * Decompiled with CFR 0.152.
 */
package org.javamoney.tck.tests.spi;

import java.util.Collection;
import java.util.HashSet;
import java.util.regex.Pattern;
import javax.money.CurrencyQuery;
import javax.money.CurrencyQueryBuilder;
import javax.money.CurrencyUnit;
import javax.money.Monetary;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="JSR 354", version="1.1.0")
public class CurrencyProviderSPITest {
    @Test(description="4.5.1 Test if a currency code regex is supported.")
    @SpecAssertion(id="451-A1", section="4.5.1")
    public void testSeachByRegex() {
        String dollarRegex = "\\p{Upper}{2}D";
        Pattern dollarPattern = Pattern.compile(dollarRegex);
        Collection allCurrencies = Monetary.getCurrencies((CurrencyQuery)CurrencyQueryBuilder.of().build());
        HashSet<String> availableDollarCodes = new HashSet<String>();
        for (CurrencyUnit currencyUnit : allCurrencies) {
            String currencyCode = currencyUnit.getCurrencyCode();
            if (!dollarPattern.matcher(currencyCode).matches()) continue;
            availableDollarCodes.add(currencyCode);
        }
        if (availableDollarCodes.isEmpty()) {
            return;
        }
        CurrencyQuery dollarQuery = CurrencyQueryBuilder.of().setCurrencyCodes(new String[]{dollarRegex}).build();
        Collection dollarCurrencies = Monetary.getCurrencies((CurrencyQuery)dollarQuery);
        for (CurrencyUnit dollarCurrency : dollarCurrencies) {
            availableDollarCodes.remove(dollarCurrency.getCurrencyCode());
        }
        Assert.assertTrue((boolean)availableDollarCodes.isEmpty(), (String)String.format("Available Dollar codes are not empty but %s.", availableDollarCodes.size()));
    }
}

