/*
 * Decompiled with CFR 0.152.
 */
package org.nd4j.linalg.cpu.nativecpu.workspace;

import java.util.List;
import java.util.Queue;
import lombok.NonNull;
import org.bytedeco.javacpp.LongPointer;
import org.bytedeco.javacpp.Pointer;
import org.nd4j.linalg.api.memory.AllocationsTracker;
import org.nd4j.linalg.api.memory.Deallocatable;
import org.nd4j.linalg.api.memory.Deallocator;
import org.nd4j.linalg.api.memory.abstracts.Nd4jWorkspace;
import org.nd4j.linalg.api.memory.conf.WorkspaceConfiguration;
import org.nd4j.linalg.api.memory.enums.AllocationKind;
import org.nd4j.linalg.api.memory.enums.LocationPolicy;
import org.nd4j.linalg.api.memory.enums.MemoryKind;
import org.nd4j.linalg.api.memory.pointers.PagedPointer;
import org.nd4j.linalg.api.memory.pointers.PointersPair;
import org.nd4j.linalg.cpu.nativecpu.workspace.CpuWorkspaceDeallocator;
import org.nd4j.linalg.factory.Nd4j;
import org.nd4j.nativeblas.NativeOps;
import org.nd4j.nativeblas.NativeOpsHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CpuWorkspace
extends Nd4jWorkspace
implements Deallocatable {
    private static final Logger log = LoggerFactory.getLogger(CpuWorkspace.class);
    protected LongPointer mmap;

    public CpuWorkspace(@NonNull WorkspaceConfiguration configuration) {
        super(configuration);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
    }

    public CpuWorkspace(@NonNull WorkspaceConfiguration configuration, @NonNull String workspaceId) {
        super(configuration, workspaceId);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (workspaceId == null) {
            throw new NullPointerException("workspaceId is marked non-null but is null");
        }
    }

    public CpuWorkspace(@NonNull WorkspaceConfiguration configuration, @NonNull String workspaceId, Integer deviceId) {
        super(configuration, workspaceId);
        if (configuration == null) {
            throw new NullPointerException("configuration is marked non-null but is null");
        }
        if (workspaceId == null) {
            throw new NullPointerException("workspaceId is marked non-null but is null");
        }
        this.deviceId = deviceId;
    }

    public String getUniqueId() {
        return "Workspace_" + this.getId() + "_" + Nd4j.getDeallocatorService().nextValue();
    }

    public Deallocator deallocator() {
        return new CpuWorkspaceDeallocator(this);
    }

    public int targetDevice() {
        return 0;
    }

    protected void init() {
        super.init();
        if (this.workspaceConfiguration.getPolicyLocation() == LocationPolicy.RAM) {
            if (this.currentSize.get() > 0L) {
                this.isInit.set(true);
                if (this.isDebug.get()) {
                    log.info("Allocating [{}] workspace of {} bytes...", (Object)this.id, (Object)this.currentSize.get());
                }
                this.workspace.setHostPointer(new PagedPointer(this.memoryManager.allocate(this.currentSize.get() + 1024L, MemoryKind.HOST, true)));
                AllocationsTracker.getInstance().markAllocated(AllocationKind.WORKSPACE, Integer.valueOf(0), this.currentSize.get() + 1024L);
            }
        } else if (this.workspaceConfiguration.getPolicyLocation() == LocationPolicy.MMAP) {
            long flen = this.tempFile.length();
            this.mmap = NativeOpsHolder.getInstance().getDeviceNativeOps().mmapFile(null, this.tempFile.getAbsolutePath(), flen);
            if (this.mmap == null) {
                throw new RuntimeException("MMAP failed");
            }
            this.workspace.setHostPointer(new PagedPointer(this.mmap.get(0L)));
        }
    }

    protected void clearPinnedAllocations(boolean extended) {
        if (this.isDebug.get()) {
            log.info("Workspace [{}] device_{} threadId {} cycle {}: clearing pinned allocations...", new Object[]{this.id, Nd4j.getAffinityManager().getDeviceForCurrentThread(), Thread.currentThread().getId(), this.cyclesCount.get()});
        }
        while (!this.pinnedAllocations.isEmpty()) {
            PointersPair pair = (PointersPair)this.pinnedAllocations.peek();
            if (pair == null) {
                throw new RuntimeException();
            }
            long stepNumber = pair.getAllocationCycle();
            long stepCurrent = this.stepsCount.get();
            if (this.isDebug.get()) {
                log.info("Allocation step: {}; Current step: {}", (Object)stepNumber, (Object)stepCurrent);
            }
            if (stepNumber + 2L >= stepCurrent && !extended) break;
            this.pinnedAllocations.remove();
            NativeOpsHolder.getInstance().getDeviceNativeOps().freeHost((Pointer)pair.getHostPointer());
            this.pinnedCount.decrementAndGet();
            this.pinnedAllocationsSize.addAndGet(pair.getRequiredMemory() * -1L);
        }
    }

    protected long mappedFileSize() {
        if (this.workspaceConfiguration.getPolicyLocation() != LocationPolicy.MMAP) {
            return 0L;
        }
        return this.tempFile.length();
    }

    protected void clearExternalAllocations() {
        if (this.isDebug.get()) {
            log.info("Workspace [{}] device_{} threadId {} guid [{}]: clearing external allocations...", new Object[]{this.id, Nd4j.getAffinityManager().getDeviceForCurrentThread(), Thread.currentThread().getId(), this.guid});
        }
        NativeOps nativeOps = NativeOpsHolder.getInstance().getDeviceNativeOps();
        for (PointersPair pair : this.externalAllocations) {
            if (pair.getHostPointer() == null) continue;
            nativeOps.freeHost((Pointer)pair.getHostPointer());
        }
        this.externalAllocations.clear();
        this.externalCount.set(0);
        this.spilledAllocationsSize.set(0L);
    }

    public synchronized void destroyWorkspace(boolean extended) {
        if (this.isDebug.get()) {
            log.info("Destroying workspace...");
        }
        long sizez = this.currentSize.getAndSet(0L);
        this.hostOffset.set(0L);
        this.deviceOffset.set(0L);
        if (extended) {
            this.clearExternalAllocations();
        }
        this.clearPinnedAllocations(extended);
        if (this.workspaceConfiguration.getPolicyLocation() == LocationPolicy.RAM) {
            if (this.workspace.getHostPointer() != null) {
                NativeOpsHolder.getInstance().getDeviceNativeOps().freeHost((Pointer)this.workspace.getHostPointer());
                AllocationsTracker.getInstance().markReleased(AllocationKind.WORKSPACE, Integer.valueOf(0), sizez);
            }
        } else if (this.workspaceConfiguration.getPolicyLocation() == LocationPolicy.MMAP && this.workspace.getHostPointer() != null) {
            NativeOpsHolder.getInstance().getDeviceNativeOps().munmapFile(null, this.mmap, this.tempFile.length());
        }
        this.workspace.setDevicePointer(null);
        this.workspace.setHostPointer(null);
    }

    protected void resetWorkspace() {
    }

    protected PointersPair workspace() {
        return this.workspace;
    }

    protected Queue<PointersPair> pinnedPointers() {
        return this.pinnedAllocations;
    }

    protected List<PointersPair> externalPointers() {
        return this.externalAllocations;
    }

    public long getPrimaryOffset() {
        return this.getHostOffset();
    }
}

