/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async.pool;

import org.neo4j.driver.internal.async.ChannelAttributes;
import org.neo4j.driver.internal.async.pool.PoolSettings;
import org.neo4j.driver.internal.handlers.PingResponseHandler;
import org.neo4j.driver.internal.messaging.ResetMessage;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.pool.ChannelHealthChecker;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Future;
import org.neo4j.driver.internal.shaded.io.netty.util.concurrent.Promise;
import org.neo4j.driver.internal.util.Clock;
import org.neo4j.driver.v1.Logger;
import org.neo4j.driver.v1.Logging;

public class NettyChannelHealthChecker
implements ChannelHealthChecker {
    private final PoolSettings poolSettings;
    private final Clock clock;
    private final Logger log;

    public NettyChannelHealthChecker(PoolSettings poolSettings, Clock clock, Logging logging) {
        this.poolSettings = poolSettings;
        this.clock = clock;
        this.log = logging.getLog(this.getClass().getSimpleName());
    }

    @Override
    public Future<Boolean> isHealthy(Channel channel) {
        if (this.isTooOld(channel)) {
            return channel.eventLoop().newSucceededFuture(Boolean.FALSE);
        }
        if (this.hasBeenIdleForTooLong(channel)) {
            return this.ping(channel);
        }
        return ACTIVE.isHealthy(channel);
    }

    private boolean isTooOld(Channel channel) {
        if (this.poolSettings.maxConnectionLifetimeEnabled()) {
            long maxAgeMillis;
            boolean tooOld;
            long creationTimestampMillis = ChannelAttributes.creationTimestamp(channel);
            long currentTimestampMillis = this.clock.millis();
            long ageMillis = currentTimestampMillis - creationTimestampMillis;
            boolean bl = tooOld = ageMillis > (maxAgeMillis = this.poolSettings.maxConnectionLifetime());
            if (tooOld) {
                this.log.trace("Failed acquire channel %s from the pool because it is too old: %s > %s", channel, ageMillis, maxAgeMillis);
            }
            return tooOld;
        }
        return false;
    }

    private boolean hasBeenIdleForTooLong(Channel channel) {
        Long lastUsedTimestamp;
        if (this.poolSettings.idleTimeBeforeConnectionTestEnabled() && (lastUsedTimestamp = ChannelAttributes.lastUsedTimestamp(channel)) != null) {
            long idleTime = this.clock.millis() - lastUsedTimestamp;
            boolean idleTooLong = idleTime > this.poolSettings.idleTimeBeforeConnectionTest();
            this.log.trace("Channel %s has been idle for %s and needs a ping", channel, idleTime);
            return idleTooLong;
        }
        return false;
    }

    private Future<Boolean> ping(Channel channel) {
        Promise<Boolean> result = channel.eventLoop().newPromise();
        ChannelAttributes.messageDispatcher(channel).enqueue(new PingResponseHandler(result, channel, this.log));
        channel.writeAndFlush(ResetMessage.RESET, channel.voidPromise());
        return result;
    }
}

