/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.amqp.rabbit.listener;

import org.apache.commons.logging.Log;
import org.springframework.amqp.AmqpRejectAndDontRequeueException;
import org.springframework.amqp.ImmediateRequeueAmqpException;
import org.springframework.amqp.rabbit.listener.MessageRejectedWhileStoppingException;

public final class ContainerUtils {
    private ContainerUtils() {
    }

    public static boolean shouldRequeue(boolean defaultRequeueRejected, Throwable throwable, Log logger) {
        boolean shouldRequeue = defaultRequeueRejected || throwable instanceof MessageRejectedWhileStoppingException;
        for (Throwable t = throwable; t != null; t = t.getCause()) {
            if (t instanceof AmqpRejectAndDontRequeueException) {
                shouldRequeue = false;
                break;
            }
            if (!(t instanceof ImmediateRequeueAmqpException)) continue;
            shouldRequeue = true;
            break;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Rejecting messages (requeue=" + shouldRequeue + ")"));
        }
        return shouldRequeue;
    }

    public static boolean isRejectManual(Throwable ex) {
        return ex instanceof AmqpRejectAndDontRequeueException && ((AmqpRejectAndDontRequeueException)ex).isRejectManual();
    }
}

