/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.configurationmetadata;

import java.util.ArrayList;
import java.util.List;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataHint;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataItem;
import org.springframework.boot.configurationmetadata.ConfigurationMetadataSource;

class RawConfigurationMetadata {
    private final List<ConfigurationMetadataSource> sources;
    private final List<ConfigurationMetadataItem> items;
    private final List<ConfigurationMetadataHint> hints;

    RawConfigurationMetadata(List<ConfigurationMetadataSource> sources, List<ConfigurationMetadataItem> items, List<ConfigurationMetadataHint> hints) {
        this.sources = new ArrayList<ConfigurationMetadataSource>(sources);
        this.items = new ArrayList<ConfigurationMetadataItem>(items);
        this.hints = new ArrayList<ConfigurationMetadataHint>(hints);
        for (ConfigurationMetadataItem item : this.items) {
            this.resolveName(item);
        }
    }

    public List<ConfigurationMetadataSource> getSources() {
        return this.sources;
    }

    public ConfigurationMetadataSource getSource(String type) {
        for (ConfigurationMetadataSource source : this.sources) {
            if (!type.equals(source.getType())) continue;
            return source;
        }
        return null;
    }

    public List<ConfigurationMetadataItem> getItems() {
        return this.items;
    }

    public List<ConfigurationMetadataHint> getHints() {
        return this.hints;
    }

    private void resolveName(ConfigurationMetadataItem item) {
        item.setName(item.getId());
        if (item.getSourceType() == null) {
            return;
        }
        ConfigurationMetadataSource source = this.getSource(item.getSourceType());
        if (source != null) {
            String groupId = source.getGroupId();
            String dottedPrefix = groupId + ".";
            String id = item.getId();
            if (RawConfigurationMetadata.hasLength(groupId) && id.startsWith(dottedPrefix)) {
                String name = id.substring(dottedPrefix.length(), id.length());
                item.setName(name);
            }
        }
    }

    private static boolean hasLength(String string) {
        return string != null && string.length() > 0;
    }
}

