/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context;

import java.util.function.Supplier;
import javax.servlet.ServletContext;
import org.springframework.boot.test.context.AbstractApplicationContextTester;
import org.springframework.boot.test.context.AssertableWebApplicationContext;
import org.springframework.mock.web.MockServletContext;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.context.support.AnnotationConfigWebApplicationContext;

public final class WebApplicationContextTester
extends AbstractApplicationContextTester<WebApplicationContextTester, ConfigurableWebApplicationContext, AssertableWebApplicationContext> {
    public WebApplicationContextTester() {
        this(WebApplicationContextTester.withMockServletContext(AnnotationConfigWebApplicationContext::new));
    }

    public WebApplicationContextTester(Supplier<ConfigurableWebApplicationContext> contextFactory) {
        super(contextFactory);
    }

    public static Supplier<ConfigurableWebApplicationContext> withMockServletContext(Supplier<ConfigurableWebApplicationContext> contextFactory) {
        return contextFactory == null ? null : () -> {
            ConfigurableWebApplicationContext context = (ConfigurableWebApplicationContext)contextFactory.get();
            context.setServletContext((ServletContext)new MockServletContext());
            return context;
        };
    }
}

