/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.util;

import com.google.common.collect.Streams;
import java.io.Closeable;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import org.springframework.boot.context.properties.source.ConfigurationPropertySources;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertySource;
import org.springframework.core.env.SystemEnvironmentPropertySource;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class TestPropertyValues {
    private final Map<String, Object> properties = new LinkedHashMap<String, Object>();

    private TestPropertyValues(String[] pairs) {
        this.addProperties(pairs);
    }

    private void addProperties(String[] pairs) {
        for (String pair : pairs) {
            this.and(pair);
        }
    }

    public TestPropertyValues and(String pair) {
        int index = this.getSeparatorIndex(pair);
        String key = pair.substring(0, index > 0 ? index : pair.length());
        String value = index > 0 ? pair.substring(index + 1) : "";
        this.and(key.trim(), value.trim());
        return this;
    }

    private int getSeparatorIndex(String pair) {
        int colonIndex = pair.indexOf(":");
        int equalIndex = pair.indexOf("=");
        if (colonIndex == -1) {
            return equalIndex;
        }
        if (equalIndex == -1) {
            return colonIndex;
        }
        return Math.min(colonIndex, equalIndex);
    }

    public TestPropertyValues and(String name, String value) {
        if (StringUtils.isEmpty((Object)name) && StringUtils.isEmpty((Object)value)) {
            return this;
        }
        Assert.hasLength((String)name, (String)"Name must not be empty");
        this.properties.put(name, value);
        return this;
    }

    public void applyTo(ConfigurableApplicationContext context) {
        this.applyTo(context.getEnvironment());
    }

    public void applyTo(ConfigurableEnvironment environment) {
        this.applyTo(environment, Type.MAP);
    }

    public void applyTo(ConfigurableEnvironment environment, Type type) {
        this.applyTo(environment, type, "test");
    }

    public void applyTo(ConfigurableEnvironment environment, Type type, String name) {
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        Assert.notNull((Object)((Object)type), (String)"Property source type must not be null");
        Assert.notNull((Object)name, (String)"Property source name must not be null");
        MutablePropertySources sources = environment.getPropertySources();
        this.addToSources(sources, type, name);
        ConfigurationPropertySources.attach((Environment)environment);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T applyToSystemProperties(Callable<T> call) {
        try (SystemPropertiesHandler handler = new SystemPropertiesHandler();){
            T t = call.call();
            return t;
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new IllegalStateException(ex);
        }
    }

    private void addToSources(MutablePropertySources sources, Type type, String name) {
        PropertySource propertySource;
        if (sources.contains(name) && (propertySource = sources.get(name)).getClass().equals(type.getSourceClass())) {
            ((Map)propertySource.getSource()).putAll(this.properties);
            return;
        }
        MapPropertySource source = type.equals((Object)Type.MAP) ? new MapPropertySource(name, this.properties) : new SystemEnvironmentPropertySource(name, this.properties);
        sources.addFirst((PropertySource)source);
    }

    public static TestPropertyValues empty() {
        return TestPropertyValues.of(new String[0]);
    }

    public static TestPropertyValues ofPair(String name, String value) {
        return TestPropertyValues.of(new String[0]).and(name, value);
    }

    public static TestPropertyValues of(Iterable<String> pairs) {
        if (pairs == null) {
            return TestPropertyValues.of(new String[0]);
        }
        return TestPropertyValues.of((String[])Streams.stream(pairs).toArray(String[]::new));
    }

    public static TestPropertyValues of(String ... pairs) {
        return new TestPropertyValues(pairs);
    }

    private class SystemPropertiesHandler
    implements Closeable {
        private final Map<String, Object> properties;
        private final Map<String, String> previous;

        SystemPropertiesHandler() {
            this.properties = new LinkedHashMap<String, Object>(TestPropertyValues.this.properties);
            this.previous = this.apply(this.properties);
        }

        private Map<String, String> apply(Map<String, ?> properties) {
            LinkedHashMap<String, String> previous = new LinkedHashMap<String, String>();
            properties.forEach((name, value) -> previous.put((String)name, this.setOrClear((String)name, (String)value)));
            return previous;
        }

        @Override
        public void close() {
            this.previous.forEach(this::setOrClear);
        }

        private String setOrClear(String name, String value) {
            Assert.notNull((Object)name, (String)"Name must not be null");
            if (value == null) {
                return (String)System.getProperties().remove(name);
            }
            return (String)System.getProperties().setProperty(name, value);
        }
    }

    public static enum Type {
        SYSTEM(SystemEnvironmentPropertySource.class),
        MAP(MapPropertySource.class);

        private Class<? extends MapPropertySource> sourceClass;

        private Type(Class<? extends MapPropertySource> sourceClass) {
            this.sourceClass = sourceClass;
        }

        public Class<? extends MapPropertySource> getSourceClass() {
            return this.sourceClass;
        }
    }
}

