/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner;

import java.io.File;
import java.net.URI;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.Proxy;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;
import org.eclipse.aether.util.repository.AuthenticationBuilder;
import org.springframework.cloud.contract.stubrunner.AetherFactories;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubDownloader;
import org.springframework.cloud.contract.stubrunner.StubRunnerOptions;
import org.springframework.cloud.contract.stubrunner.TemporaryFileStorage;
import org.springframework.cloud.contract.stubrunner.spring.StubRunnerProperties;
import org.springframework.cloud.contract.stubrunner.util.ZipCategory;
import org.springframework.util.StringUtils;

public class AetherStubDownloader
implements StubDownloader {
    private static final Log log = LogFactory.getLog(AetherStubDownloader.class);
    private static final String TEMP_DIR_PREFIX = "contracts";
    private static final String ARTIFACT_EXTENSION = "jar";
    private static final String LATEST_ARTIFACT_VERSION = "(,]";
    private static final String LATEST_VERSION_IN_IVY = "+";
    private static final Class CLAZZ = TemporaryFileStorage.class;
    private final List<RemoteRepository> remoteRepos;
    private final RepositorySystem repositorySystem;
    private final RepositorySystemSession session;
    private final boolean workOffline;
    private final boolean deleteStubsAfterTest;

    public AetherStubDownloader(StubRunnerOptions stubRunnerOptions) {
        this.deleteStubsAfterTest = stubRunnerOptions.isDeleteStubsAfterTest();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will be resolving versions for the following options: [" + stubRunnerOptions + "]"));
        }
        this.remoteRepos = this.remoteRepositories(stubRunnerOptions);
        boolean remoteReposMissing = this.remoteReposMissing();
        switch (stubRunnerOptions.stubsMode) {
            case LOCAL: {
                log.info((Object)"Remote repos not passed but the switch to work offline was set. Stubs will be used from your local Maven repository.");
                break;
            }
            case REMOTE: {
                if (!remoteReposMissing) break;
                throw new IllegalStateException("Remote repositories for stubs are not specified and work offline flag wasn't passed");
            }
            case CLASSPATH: {
                throw new UnsupportedOperationException("You can't use Aether downloader when you use classpath to find stubs");
            }
        }
        this.repositorySystem = AetherFactories.newRepositorySystem();
        this.workOffline = stubRunnerOptions.stubsMode == StubRunnerProperties.StubsMode.LOCAL;
        this.session = AetherFactories.newSession(this.repositorySystem, this.workOffline);
        this.registerShutdownHook();
    }

    private boolean remoteReposMissing() {
        return this.remoteRepos == null || this.remoteRepos.isEmpty();
    }

    public AetherStubDownloader(RepositorySystem repositorySystem, List<RemoteRepository> remoteRepositories, RepositorySystemSession session) {
        this.deleteStubsAfterTest = true;
        this.remoteRepos = remoteRepositories;
        this.repositorySystem = repositorySystem;
        this.session = session;
        if (this.remoteReposMissing()) {
            log.error((Object)"Remote repositories for stubs are not specified and work offline flag wasn't passed");
        }
        this.workOffline = false;
        this.registerShutdownHook();
    }

    private List<RemoteRepository> remoteRepositories(StubRunnerOptions stubRunnerOptions) {
        if (stubRunnerOptions.stubRepositoryRoot == null) {
            return new ArrayList<RemoteRepository>();
        }
        String[] repos = stubRunnerOptions.getStubRepositoryRootAsString().split(",");
        ArrayList<RemoteRepository> remoteRepos = new ArrayList<RemoteRepository>();
        for (int i = 0; i < repos.length; ++i) {
            if (!StringUtils.hasText((String)repos[i])) continue;
            RemoteRepository.Builder builder = new RemoteRepository.Builder("remote" + i, "default", repos[i]).setAuthentication(new AuthenticationBuilder().addUsername(stubRunnerOptions.username).addPassword(stubRunnerOptions.password).build());
            if (stubRunnerOptions.getProxyOptions() != null) {
                StubRunnerOptions.StubRunnerProxyOptions p = stubRunnerOptions.getProxyOptions();
                builder.setProxy(new Proxy(null, p.getProxyHost(), p.getProxyPort()));
            }
            remoteRepos.add(builder.build());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using the following remote repos " + remoteRepos));
        }
        return remoteRepos;
    }

    private File unpackedJar(String resolvedVersion, String stubsGroup, String stubsModule, String classifier) {
        try {
            log.info((Object)("Resolved version is [" + resolvedVersion + "]"));
            if (StringUtils.isEmpty((Object)resolvedVersion)) {
                log.warn((Object)("Stub for group [" + stubsGroup + "] module [" + stubsModule + "] and classifier [" + classifier + "] not found in " + this.remoteRepos));
                return null;
            }
            DefaultArtifact artifact = new DefaultArtifact(stubsGroup, stubsModule, classifier, ARTIFACT_EXTENSION, resolvedVersion);
            ArtifactRequest request = new ArtifactRequest((Artifact)artifact, this.remoteRepos, null);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolving artifact [" + artifact + "] using remote repositories " + this.remoteRepos));
            }
            ArtifactResult result = this.repositorySystem.resolveArtifact(this.session, request);
            log.info((Object)("Resolved artifact [" + artifact + "] to " + result.getArtifact().getFile()));
            File temporaryFile = AetherStubDownloader.unpackStubJarToATemporaryFolder(result.getArtifact().getFile().toURI());
            log.info((Object)("Unpacked file to [" + temporaryFile + "]"));
            return temporaryFile;
        }
        catch (IllegalStateException ise) {
            throw ise;
        }
        catch (Exception e) {
            throw new IllegalStateException("Exception occurred while trying to download a stub for group [" + stubsGroup + "] module [" + stubsModule + "] and classifier [" + classifier + "] in " + this.remoteRepos, e);
        }
    }

    private boolean resolvedFromLocalRepo(ArtifactResult result) {
        return result.getRepository() instanceof LocalRepository;
    }

    private boolean shouldDownloadFromRemote() {
        return !this.remoteReposMissing() && !this.workOffline;
    }

    private String getVersion(String stubsGroup, String stubsModule, String version, String classifier) {
        if (StringUtils.isEmpty((Object)version) || LATEST_VERSION_IN_IVY.equals(version)) {
            log.info((Object)("Desired version is [" + version + "] - will try to resolve the latest version"));
            return this.resolveHighestArtifactVersion(stubsGroup, stubsModule, classifier, LATEST_ARTIFACT_VERSION);
        }
        return this.resolveHighestArtifactVersion(stubsGroup, stubsModule, classifier, version);
    }

    @Override
    public Map.Entry<StubConfiguration, File> downloadAndUnpackStubJar(StubConfiguration stubConfiguration) {
        File unpackedJar;
        String version = this.getVersion(stubConfiguration.groupId, stubConfiguration.artifactId, stubConfiguration.version, stubConfiguration.classifier);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Will download the stub for version [" + version + "]"));
        }
        if ((unpackedJar = this.unpackedJar(version, stubConfiguration.groupId, stubConfiguration.artifactId, stubConfiguration.classifier)) == null) {
            return null;
        }
        return new AbstractMap.SimpleEntry<StubConfiguration, File>(new StubConfiguration(stubConfiguration.groupId, stubConfiguration.artifactId, version, stubConfiguration.classifier), unpackedJar);
    }

    private String resolveHighestArtifactVersion(String stubsGroup, String stubsModule, String classifier, String version) {
        VersionRangeResult rangeResult;
        DefaultArtifact artifact = new DefaultArtifact(stubsGroup, stubsModule, classifier, ARTIFACT_EXTENSION, version);
        VersionRangeRequest versionRangeRequest = new VersionRangeRequest((Artifact)artifact, this.remoteRepos, null);
        try {
            rangeResult = this.repositorySystem.resolveVersionRange(this.session, versionRangeRequest);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Resolved version range is [" + rangeResult + "]"));
            }
        }
        catch (VersionRangeResolutionException e) {
            throw new IllegalStateException("Cannot resolve version range", e);
        }
        if (rangeResult.getHighestVersion() == null) {
            throw new IllegalArgumentException("For groupId [" + stubsGroup + "] artifactId [" + stubsModule + "] and classifier [" + classifier + "] the version was not resolved! The following exceptions took place " + rangeResult.getExceptions());
        }
        return rangeResult.getHighestVersion() == null ? null : rangeResult.getHighestVersion().toString();
    }

    private static File unpackStubJarToATemporaryFolder(URI stubJarUri) {
        File tmpDirWhereStubsWillBeUnzipped = TemporaryFileStorage.createTempDir(TEMP_DIR_PREFIX);
        log.info((Object)("Unpacking stub from JAR [URI: " + stubJarUri + "]"));
        ZipCategory.unzipTo(new File(stubJarUri), tmpDirWhereStubsWillBeUnzipped);
        TemporaryFileStorage.add(tmpDirWhereStubsWillBeUnzipped);
        return tmpDirWhereStubsWillBeUnzipped;
    }

    private void registerShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> TemporaryFileStorage.cleanup(this.deleteStubsAfterTest)));
    }
}

