/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.circuitbreaker;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.instrument.circuitbreaker.SleuthCircuitBreakerSpan;

class TraceFunction<T>
implements Function<Throwable, T> {
    private final Tracer tracer;
    private final Function<Throwable, T> delegate;
    private final AtomicReference<AssertingSpan> span;

    TraceFunction(Tracer tracer, Function<Throwable, T> delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.span = new AtomicReference<AssertingSpan>(SleuthCircuitBreakerSpan.CIRCUIT_BREAKER_FUNCTION_SPAN.wrap(this.tracer.nextSpan()));
    }

    @Override
    public T apply(Throwable throwable) {
        String name = this.delegate.getClass().getSimpleName();
        AssertingSpan span = this.span.get().name(name);
        Throwable tr = null;
        try {
            T t;
            block12: {
                Tracer.SpanInScope ws = this.tracer.withSpan((Span)span.start());
                try {
                    t = this.delegate.apply(throwable);
                    if (ws == null) break block12;
                }
                catch (Throwable throwable2) {
                    try {
                        if (ws != null) {
                            try {
                                ws.close();
                            }
                            catch (Throwable throwable3) {
                                throwable2.addSuppressed(throwable3);
                            }
                        }
                        throw throwable2;
                    }
                    catch (Throwable t2) {
                        tr = t2;
                        throw t2;
                    }
                }
                ws.close();
            }
            return t;
        }
        finally {
            if (tr != null) {
                span.error(tr);
            }
            span.end();
            this.span.set(null);
        }
    }
}

