/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.core.facet.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.range.RangeBuilder;
import org.springframework.data.elasticsearch.core.facet.AbstractFacetRequest;
import org.springframework.util.Assert;

@Deprecated
public class RangeFacetRequest
extends AbstractFacetRequest {
    public static final String RANGE_INTERNAL_SUM = "range-internal-sum";
    private String field;
    private String keyField;
    private String valueField;
    private List<Entry> entries = new ArrayList<Entry>();

    public RangeFacetRequest(String name) {
        super(name);
    }

    public void setField(String field) {
        this.field = field;
    }

    public void setFields(String keyField, String valueField) {
        this.keyField = keyField;
        this.valueField = valueField;
    }

    public void range(Double from, Double to) {
        this.entries.add(new DoubleEntry(from, to));
    }

    public void range(String from, String to) {
        throw new UnsupportedOperationException("Native Facet are not supported in Elasticsearch 2.x - use Aggregation");
    }

    public void addRange(Double from, Double to) {
        this.entries.add(new DoubleEntry(from, to));
    }

    public void addRange(String from, String to) {
        throw new UnsupportedOperationException("Native Facet are not supported in Elasticsearch 2.x - use Aggregation");
    }

    @Override
    public AbstractAggregationBuilder getFacet() {
        Assert.notNull((Object)this.getName(), (String)"Facet name can't be a null !!!");
        RangeBuilder rangeBuilder = AggregationBuilders.range((String)this.getName());
        rangeBuilder.field(StringUtils.isNotBlank((String)this.keyField) ? this.keyField : this.field);
        for (Entry entry : this.entries) {
            DoubleEntry doubleEntry = (DoubleEntry)entry;
            rangeBuilder.addRange(this.validateValue((Double)doubleEntry.getFrom(), Double.NEGATIVE_INFINITY), this.validateValue((Double)doubleEntry.getTo(), Double.POSITIVE_INFINITY));
        }
        rangeBuilder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.extendedStats((String)"internal-stats"));
        if (StringUtils.isNotBlank((String)this.valueField)) {
            rangeBuilder.subAggregation((AbstractAggregationBuilder)AggregationBuilders.sum((String)RANGE_INTERNAL_SUM).field(this.valueField));
        }
        return rangeBuilder;
    }

    private double validateValue(Double value, double defaultValue) {
        return value == null ? defaultValue : value;
    }

    static class Entry<T> {
        T from;
        T to;

        Entry(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public T getFrom() {
            return this.from;
        }

        public T getTo() {
            return this.to;
        }
    }

    static class StringEntry
    extends Entry<String> {
        StringEntry(String from, String to) {
            super(from, to);
        }
    }

    static class DoubleEntry
    extends Entry<Double> {
        DoubleEntry(Double from, Double to) {
            super(from, to);
        }
    }
}

