/*
 * Copyright 2021-2022 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.springframework.data.elasticsearch.client.erhlc;

import reactor.core.publisher.Mono;

import org.springframework.data.elasticsearch.core.cluster.ClusterHealth;

/**
 * Reactive Elasticsearch operations on cluster level.
 *
 * @author Peter-Josef Meisch
 * @since 4.2
 * @deprecated since 5.0
 */
@Deprecated
public interface ReactiveClusterOperations {

	/**
	 * get the cluster's health status.
	 *
	 * @return a Mono emitting the health information for the cluster.
	 */
	Mono<ClusterHealth> health();
}
