/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.mongodb.core.convert;

import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Consumer;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.core.convert.converter.ConverterFactory;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.JodaTimeConverters;
import org.springframework.data.convert.PropertyValueConversions;
import org.springframework.data.convert.PropertyValueConverterFactory;
import org.springframework.data.convert.PropertyValueConverterRegistrar;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.SimplePropertyValueConversions;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.mongodb.core.convert.GeoConverters;
import org.springframework.data.mongodb.core.convert.MongoConverters;
import org.springframework.data.mongodb.core.mapping.MongoPersistentProperty;
import org.springframework.data.mongodb.core.mapping.MongoSimpleTypes;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class MongoCustomConversions
extends CustomConversions {
    private static final CustomConversions.StoreConversions STORE_CONVERSIONS;
    private static final List<Object> STORE_CONVERTERS;

    MongoCustomConversions() {
        this(Collections.emptyList());
    }

    public MongoCustomConversions(List<?> converters) {
        this(MongoConverterConfigurationAdapter.from(converters));
    }

    protected MongoCustomConversions(MongoConverterConfigurationAdapter conversionConfiguration) {
        super(conversionConfiguration.createConverterConfiguration());
    }

    public static MongoCustomConversions create(Consumer<MongoConverterConfigurationAdapter> configurer) {
        MongoConverterConfigurationAdapter adapter = new MongoConverterConfigurationAdapter();
        configurer.accept(adapter);
        return new MongoCustomConversions(adapter);
    }

    static {
        ArrayList<? extends Object> converters = new ArrayList<Object>();
        converters.add((Object)CustomToStringConverter.INSTANCE);
        converters.addAll(MongoConverters.getConvertersToRegister());
        converters.addAll(JodaTimeConverters.getConvertersToRegister());
        converters.addAll(GeoConverters.getConvertersToRegister());
        STORE_CONVERTERS = Collections.unmodifiableList(converters);
        STORE_CONVERSIONS = CustomConversions.StoreConversions.of((SimpleTypeHolder)MongoSimpleTypes.HOLDER, STORE_CONVERTERS);
    }

    public static class MongoConverterConfigurationAdapter {
        private static final Set<Class<?>> JAVA_DRIVER_TIME_SIMPLE_TYPES = new HashSet<Class>(Arrays.asList(LocalDate.class, LocalTime.class, LocalDateTime.class));
        private boolean useNativeDriverJavaTimeCodecs = false;
        private final List<Object> customConverters = new ArrayList<Object>();
        private final PropertyValueConversions internalValueConversion;
        private PropertyValueConversions propertyValueConversions = this.internalValueConversion = PropertyValueConversions.simple(it -> {});

        public static MongoConverterConfigurationAdapter from(List<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            MongoConverterConfigurationAdapter converterConfigurationAdapter = new MongoConverterConfigurationAdapter();
            converterConfigurationAdapter.useSpringDataJavaTimeCodecs();
            converterConfigurationAdapter.registerConverters(converters);
            return converterConfigurationAdapter;
        }

        public MongoConverterConfigurationAdapter useNativeDriverJavaTimeCodecs(boolean useNativeDriverJavaTimeCodecs) {
            this.useNativeDriverJavaTimeCodecs = useNativeDriverJavaTimeCodecs;
            return this;
        }

        public MongoConverterConfigurationAdapter useNativeDriverJavaTimeCodecs() {
            return this.useNativeDriverJavaTimeCodecs(true);
        }

        public MongoConverterConfigurationAdapter useSpringDataJavaTimeCodecs() {
            return this.useNativeDriverJavaTimeCodecs(false);
        }

        public MongoConverterConfigurationAdapter registerConverter(Converter<?, ?> converter) {
            Assert.notNull(converter, (String)"Converter must not be null!");
            this.customConverters.add(converter);
            return this;
        }

        public MongoConverterConfigurationAdapter configurePropertyConversions(Consumer<PropertyValueConverterRegistrar<MongoPersistentProperty>> configurationAdapter) {
            Assert.state((boolean)(this.valueConversions() instanceof SimplePropertyValueConversions), (String)"Configured PropertyValueConversions does not allow setting custom ConverterRegistry.");
            PropertyValueConverterRegistrar propertyValueConverterRegistrar = new PropertyValueConverterRegistrar();
            configurationAdapter.accept((PropertyValueConverterRegistrar<MongoPersistentProperty>)propertyValueConverterRegistrar);
            ((SimplePropertyValueConversions)this.valueConversions()).setValueConverterRegistry(propertyValueConverterRegistrar.buildRegistry());
            return this;
        }

        public MongoConverterConfigurationAdapter registerConverterFactory(ConverterFactory<?, ?> converterFactory) {
            Assert.notNull(converterFactory, (String)"ConverterFactory must not be null!");
            this.customConverters.add(converterFactory);
            return this;
        }

        public MongoConverterConfigurationAdapter registerConverters(Collection<?> converters) {
            Assert.notNull(converters, (String)"Converters must not be null");
            Assert.noNullElements(converters, (String)"Converters must not be null nor contain null values!");
            this.customConverters.addAll(converters);
            return this;
        }

        public MongoConverterConfigurationAdapter registerPropertyValueConverterFactory(PropertyValueConverterFactory converterFactory) {
            Assert.state((boolean)(this.valueConversions() instanceof SimplePropertyValueConversions), (String)"Configured PropertyValueConversions does not allow setting custom ConverterRegistry.");
            ((SimplePropertyValueConversions)this.valueConversions()).setConverterFactory(converterFactory);
            return this;
        }

        public MongoConverterConfigurationAdapter setPropertyValueConversions(PropertyValueConversions valueConversions) {
            Assert.notNull((Object)valueConversions, (String)"PropertyValueConversions must not be null");
            this.propertyValueConversions = valueConversions;
            return this;
        }

        PropertyValueConversions valueConversions() {
            if (this.propertyValueConversions == null) {
                this.propertyValueConversions = this.internalValueConversion;
            }
            return this.propertyValueConversions;
        }

        CustomConversions.ConverterConfiguration createConverterConfiguration() {
            if (this.hasDefaultPropertyValueConversions() && this.propertyValueConversions instanceof SimplePropertyValueConversions) {
                ((SimplePropertyValueConversions)this.propertyValueConversions).init();
            }
            if (!this.useNativeDriverJavaTimeCodecs) {
                return new CustomConversions.ConverterConfiguration(STORE_CONVERSIONS, this.customConverters, convertiblePair -> true, this.propertyValueConversions);
            }
            ArrayList<Enum> converters = new ArrayList<Enum>(STORE_CONVERTERS.size() + 3);
            converters.add(DateToUtcLocalDateConverter.INSTANCE);
            converters.add(DateToUtcLocalTimeConverter.INSTANCE);
            converters.add(DateToUtcLocalDateTimeConverter.INSTANCE);
            converters.addAll(STORE_CONVERTERS);
            CustomConversions.StoreConversions storeConversions = CustomConversions.StoreConversions.of((SimpleTypeHolder)new SimpleTypeHolder(JAVA_DRIVER_TIME_SIMPLE_TYPES, MongoSimpleTypes.HOLDER), converters);
            return new CustomConversions.ConverterConfiguration(storeConversions, this.customConverters, convertiblePair -> !JAVA_DRIVER_TIME_SIMPLE_TYPES.contains(convertiblePair.getSourceType()) || !Date.class.isAssignableFrom(convertiblePair.getTargetType()), this.propertyValueConversions);
        }

        private boolean hasDefaultPropertyValueConversions() {
            return this.propertyValueConversions == this.internalValueConversion;
        }

        @ReadingConverter
        private static enum DateToUtcLocalDateConverter implements Converter<Date, LocalDate>
        {
            INSTANCE;


            public LocalDate convert(Date source) {
                return DateToUtcLocalDateTimeConverter.INSTANCE.convert(source).toLocalDate();
            }
        }

        @ReadingConverter
        private static enum DateToUtcLocalTimeConverter implements Converter<Date, LocalTime>
        {
            INSTANCE;


            public LocalTime convert(Date source) {
                return DateToUtcLocalDateTimeConverter.INSTANCE.convert(source).toLocalTime();
            }
        }

        @ReadingConverter
        private static enum DateToUtcLocalDateTimeConverter implements Converter<Date, LocalDateTime>
        {
            INSTANCE;


            public LocalDateTime convert(Date source) {
                return LocalDateTime.ofInstant(Instant.ofEpochMilli(source.getTime()), ZoneId.of("UTC"));
            }
        }
    }

    @WritingConverter
    private static enum CustomToStringConverter implements GenericConverter
    {
        INSTANCE;


        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            GenericConverter.ConvertiblePair localeToString = new GenericConverter.ConvertiblePair(Locale.class, String.class);
            GenericConverter.ConvertiblePair booleanToString = new GenericConverter.ConvertiblePair(Character.class, String.class);
            return new HashSet<GenericConverter.ConvertiblePair>(Arrays.asList(localeToString, booleanToString));
        }

        public Object convert(@Nullable Object source, TypeDescriptor sourceType, TypeDescriptor targetType) {
            return source != null ? source.toString() : null;
        }
    }
}

