/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.oauth2.provider;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.BaseRequest;
import org.springframework.security.oauth2.provider.TokenRequest;

@Deprecated
public class OAuth2Request
extends BaseRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Set<String> resourceIds = new HashSet<String>();
    private Collection<? extends GrantedAuthority> authorities = new HashSet<GrantedAuthority>();
    private boolean approved = false;
    private TokenRequest refresh = null;
    private String redirectUri;
    private Set<String> responseTypes = new HashSet<String>();
    private Map<String, Serializable> extensions = new HashMap<String, Serializable>();

    public OAuth2Request(Map<String, String> requestParameters, String clientId, Collection<? extends GrantedAuthority> authorities, boolean approved, Set<String> scope, Set<String> resourceIds, String redirectUri, Set<String> responseTypes, Map<String, Serializable> extensionProperties) {
        this.setClientId(clientId);
        this.setRequestParameters(requestParameters);
        this.setScope(scope);
        if (resourceIds != null) {
            this.resourceIds = new HashSet<String>(resourceIds);
        }
        if (authorities != null) {
            this.authorities = new HashSet<GrantedAuthority>(authorities);
        }
        this.approved = approved;
        if (responseTypes != null) {
            this.responseTypes = new HashSet<String>(responseTypes);
        }
        this.redirectUri = redirectUri;
        if (extensionProperties != null) {
            this.extensions = extensionProperties;
        }
    }

    protected OAuth2Request(OAuth2Request other) {
        this(other.getRequestParameters(), other.getClientId(), other.getAuthorities(), other.isApproved(), other.getScope(), other.getResourceIds(), other.getRedirectUri(), other.getResponseTypes(), other.getExtensions());
    }

    protected OAuth2Request(String clientId) {
        this.setClientId(clientId);
    }

    protected OAuth2Request() {
    }

    public String getRedirectUri() {
        return this.redirectUri;
    }

    public Set<String> getResponseTypes() {
        return this.responseTypes;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.authorities;
    }

    public boolean isApproved() {
        return this.approved;
    }

    public Set<String> getResourceIds() {
        return this.resourceIds;
    }

    public Map<String, Serializable> getExtensions() {
        return this.extensions;
    }

    public OAuth2Request createOAuth2Request(Map<String, String> parameters) {
        return new OAuth2Request(parameters, this.getClientId(), this.authorities, this.approved, this.getScope(), this.resourceIds, this.redirectUri, this.responseTypes, this.extensions);
    }

    public OAuth2Request narrowScope(Set<String> scope) {
        OAuth2Request request = new OAuth2Request(this.getRequestParameters(), this.getClientId(), this.authorities, this.approved, scope, this.resourceIds, this.redirectUri, this.responseTypes, this.extensions);
        request.refresh = this.refresh;
        return request;
    }

    public OAuth2Request refresh(TokenRequest tokenRequest) {
        OAuth2Request request = new OAuth2Request(this.getRequestParameters(), this.getClientId(), this.authorities, this.approved, this.getScope(), this.resourceIds, this.redirectUri, this.responseTypes, this.extensions);
        request.refresh = tokenRequest;
        return request;
    }

    public boolean isRefresh() {
        return this.refresh != null;
    }

    public TokenRequest getRefreshTokenRequest() {
        return this.refresh;
    }

    public String getGrantType() {
        String response;
        if (this.getRequestParameters().containsKey("grant_type")) {
            return (String)this.getRequestParameters().get("grant_type");
        }
        if (this.getRequestParameters().containsKey("response_type") && (response = (String)this.getRequestParameters().get("response_type")).contains("token")) {
            return "implicit";
        }
        return null;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.approved ? 1231 : 1237);
        result = 31 * result + (this.authorities == null ? 0 : this.authorities.hashCode());
        result = 31 * result + (this.extensions == null ? 0 : this.extensions.hashCode());
        result = 31 * result + (this.redirectUri == null ? 0 : this.redirectUri.hashCode());
        result = 31 * result + (this.resourceIds == null ? 0 : this.resourceIds.hashCode());
        result = 31 * result + (this.responseTypes == null ? 0 : this.responseTypes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OAuth2Request other = (OAuth2Request)obj;
        if (this.approved != other.approved) {
            return false;
        }
        if (this.authorities == null ? other.authorities != null : !this.authorities.equals(other.authorities)) {
            return false;
        }
        if (this.extensions == null ? other.extensions != null : !this.extensions.equals(other.extensions)) {
            return false;
        }
        if (this.redirectUri == null ? other.redirectUri != null : !this.redirectUri.equals(other.redirectUri)) {
            return false;
        }
        if (this.resourceIds == null ? other.resourceIds != null : !this.resourceIds.equals(other.resourceIds)) {
            return false;
        }
        return !(this.responseTypes == null ? other.responseTypes != null : !this.responseTypes.equals(other.responseTypes));
    }
}

