/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.session.data.mongo.config.annotation.web.http;

import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.mongodb.core.MongoOperations;
import org.springframework.session.config.annotation.web.http.SpringHttpSessionConfiguration;
import org.springframework.session.data.mongo.AbstractMongoSessionConverter;
import org.springframework.session.data.mongo.MongoOperationsSessionRepository;
import org.springframework.session.data.mongo.config.annotation.web.http.EnableMongoHttpSession;

@Configuration
class MongoHttpSessionConfiguration
extends SpringHttpSessionConfiguration
implements ImportAware {
    private AbstractMongoSessionConverter mongoSessionConverter;
    private Integer maxInactiveIntervalInSeconds;
    private String collectionName;

    MongoHttpSessionConfiguration() {
    }

    @Bean
    MongoOperationsSessionRepository mongoSessionRepository(MongoOperations mongoOperations) {
        MongoOperationsSessionRepository repository = new MongoOperationsSessionRepository(mongoOperations);
        repository.setCollectionName(this.collectionName);
        repository.setMaxInactiveIntervalInSeconds(this.maxInactiveIntervalInSeconds);
        if (this.mongoSessionConverter != null) {
            repository.setMongoSessionConverter(this.mongoSessionConverter);
        }
        return repository;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        AnnotationAttributes attributes = AnnotationAttributes.fromMap((Map)importMetadata.getAnnotationAttributes(EnableMongoHttpSession.class.getName()));
        this.maxInactiveIntervalInSeconds = (Integer)attributes.getNumber("maxInactiveIntervalInSeconds");
        this.collectionName = attributes.getString("collectionName");
    }

    @Autowired(required=false)
    public void setMongoSessionConverter(AbstractMongoSessionConverter mongoSessionConverter) {
        this.mongoSessionConverter = mongoSessionConverter;
    }
}

