/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.jdbc.tracing;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapInjectAdapter;
import io.opentracing.util.GlobalTracer;
import java.util.HashMap;
import java.util.Map;
import org.teiid.jdbc.tracing.TracingHelper;

public class GlobalTracerInjector
implements TracingHelper.Injector {
    private static Tracer TRACER = GlobalTracer.get();

    @Override
    public String getSpanContext() {
        return GlobalTracerInjector.getSpanContext(TRACER);
    }

    protected static String getSpanContext(Tracer tracer) {
        Span span = tracer.activeSpan();
        if (span == null) {
            return null;
        }
        HashMap spanMap = new HashMap();
        tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)new TextMapInjectAdapter(spanMap));
        StringBuilder json = new StringBuilder();
        json.append('{');
        boolean first = true;
        for (Map.Entry entry : spanMap.entrySet()) {
            if (!first) {
                json.append(',');
            } else {
                first = false;
            }
            json.append('\"').append(((String)entry.getKey()).replace("\"", "\\\"")).append("\":\"").append(((String)entry.getValue()).replace("\"", "\\\"")).append('\"');
        }
        json.append('}');
        return json.toString();
    }

    public static Tracer getTracer() {
        return TRACER;
    }

    public static void setTracer(Tracer tracer) {
        TRACER = tracer;
    }
}

