/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.spring.common;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.teiid.spring.common.ExternalSource;
import org.teiid.spring.common.PropertyDefinition;
import org.teiid.spring.common.ReflectionUtil;
import org.teiid.spring.data.ConfigurationProperty;
import org.teiid.spring.data.ConnectionFactoryConfiguration;

public class ExternalSources
implements Serializable {
    private static final long serialVersionUID = 4872582926073134433L;
    private Map<String, ExternalSource> items = Collections.synchronizedMap(new TreeMap());

    public ExternalSources() {
        this.loadConnctionFactories(this.getClass().getClassLoader(), "org.teiid.spring.data");
    }

    public void loadConnctionFactories(final ClassLoader classloader, String packageName) {
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.setResourceLoader(new ResourceLoader(){

            public Resource getResource(String location) {
                return null;
            }

            public ClassLoader getClassLoader() {
                return classloader;
            }
        });
        provider.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(ConnectionFactoryConfiguration.class));
        Set components = provider.findCandidateComponents(packageName);
        for (BeanDefinition c : components) {
            try {
                Class<?> clazz = Class.forName(c.getBeanClassName(), false, classloader);
                ConnectionFactoryConfiguration cfc = clazz.getAnnotation(ConnectionFactoryConfiguration.class);
                if (cfc == null) continue;
                ExternalSource source = ExternalSources.build(cfc, clazz);
                for (String name : cfc.otherAliases()) {
                    this.items.put(name, source);
                }
                this.items.put(source.getName(), source);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException("failed to load " + c.getBeanClassName());
            }
        }
    }

    private static ExternalSource build(ConnectionFactoryConfiguration annotation, Class<?> clazz) {
        String[] stringArray;
        String dialect = annotation.dialect();
        boolean jdbc = annotation.jdbc();
        String prefix = "spring.teiid.data." + annotation.alias();
        if (annotation.driverNames().length == 0) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = clazz.getName();
        } else {
            stringArray = annotation.driverNames();
        }
        String[] drivers = stringArray;
        String[] dataSources = annotation.datasourceNames().length == 0 ? new String[]{} : annotation.datasourceNames();
        String url = annotation.url().isEmpty() ? null : annotation.url();
        ArrayList<PropertyDefinition> props = new ArrayList<PropertyDefinition>();
        for (Method m : annotation.configuration().getMethods()) {
            String name;
            if (!ReflectionUtil.isGetter(m) || !ReflectionUtil.hasSetter(name = ReflectionUtil.getterName(m), annotation.configuration())) continue;
            Class<Object> classType = ReflectionUtil.getterType(m);
            String type = "string";
            if (classType.isAssignableFrom(Boolean.TYPE) || classType.isAssignableFrom(Boolean.class)) {
                type = "boolean";
            } else if (classType.isAssignableFrom(Integer.TYPE) || classType.isAssignableFrom(Short.TYPE) || classType.isAssignableFrom(Double.TYPE) || classType.isAssignableFrom(Long.TYPE) || classType.isAssignableFrom(Number.class)) {
                type = "number";
            }
            String defaultValue = null;
            String description = null;
            String displayName = null;
            Boolean advanced = null;
            Boolean masked = null;
            Boolean required = null;
            String[] allowedValues = null;
            try {
                Field f = annotation.configuration().getDeclaredField(name);
                ConfigurationProperty pd = f.getAnnotation(ConfigurationProperty.class);
                if (pd != null) {
                    displayName = pd.displayName().isEmpty() ? null : pd.displayName();
                    description = pd.description().isEmpty() ? null : pd.description();
                    defaultValue = pd.defaultValue().isEmpty() ? null : pd.defaultValue();
                    advanced = pd.advanced() ? Boolean.valueOf(true) : null;
                    required = pd.required() ? Boolean.valueOf(true) : null;
                    masked = pd.masked() ? Boolean.valueOf(true) : null;
                    allowedValues = pd.allowedValues().length == 0 ? null : pd.allowedValues();
                }
            }
            catch (NoSuchFieldException | SecurityException exception) {
                // empty catch block
            }
            props.add(new PropertyDefinition(name, displayName, description, type, required, masked, advanced, defaultValue, allowedValues));
        }
        if (jdbc) {
            props.add(new PropertyDefinition("driverClassName", null, null, "string", false, null, null, annotation.driverNames()[0], annotation.driverNames()));
        }
        Collections.sort(props);
        ExternalSource source = new ExternalSource(annotation.alias(), drivers, dataSources, annotation.translatorName(), dialect.isEmpty() ? null : dialect, prefix, jdbc, url, props);
        return source;
    }

    public ExternalSource findByDriverName(String driverName) {
        for (ExternalSource source : this.items.values()) {
            for (String driver : source.getDriverNames()) {
                if (!driver.equals(driverName)) continue;
                return source;
            }
            for (String driver : source.getDatasourceNames()) {
                if (!driver.equals(driverName)) continue;
                return source;
            }
        }
        return null;
    }

    public ExternalSource find(String sourceName) {
        return this.items.get(sourceName);
    }

    public void addSource(ExternalSource source) {
        if (this.find(source.getName()) == null) {
            this.items.put(source.getName(), source);
        }
    }

    public void addSource(ConnectionFactoryConfiguration annotation, Class<?> clazz) {
        ExternalSource source = ExternalSources.build(annotation, clazz);
        if (this.find(source.getName()) == null) {
            this.items.put(source.getName(), source);
        }
    }

    public Map<String, ExternalSource> getItems() {
        return this.items;
    }
}

