/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joinery.DataFrame;
import joinery.impl.Views;

public class Index {
    private final Map<Object, Integer> index;

    public Index() {
        this(Collections.emptyList());
    }

    public Index(Collection<?> names) {
        this(names, names.size());
    }

    public Index(Collection<?> names, int size) {
        this.index = new LinkedHashMap<Object, Integer>(names.size());
        Iterator<?> it = names.iterator();
        for (int i = 0; i < size; ++i) {
            Object name = it.hasNext() ? it.next() : Integer.valueOf(i);
            this.add(name, i);
        }
    }

    public void add(Object name, Integer value) {
        if (this.index.put(name, value) != null) {
            throw new IllegalArgumentException("duplicate name '" + name + "' in index");
        }
    }

    public void extend(Integer size) {
        for (int i = this.index.size(); i < size; ++i) {
            this.add(i, i);
        }
    }

    public void set(Object name, Integer value) {
        this.index.put(name, value);
    }

    public Integer get(Object name) {
        Integer i = this.index.get(name);
        if (i == null) {
            throw new IllegalArgumentException("name '" + name + "' not in index");
        }
        return i;
    }

    public void rename(Map<Object, Object> names) {
        LinkedHashMap<Object, Integer> idx = new LinkedHashMap<Object, Integer>();
        for (Map.Entry<Object, Integer> entry : this.index.entrySet()) {
            Object col = entry.getKey();
            if (names.keySet().contains(col)) {
                idx.put(names.get(col), entry.getValue());
                continue;
            }
            idx.put(col, entry.getValue());
        }
        this.index.clear();
        this.index.putAll(idx);
    }

    public Set<Object> names() {
        return this.index.keySet();
    }

    public Integer[] indices(Object[] names) {
        return this.indices(Arrays.asList(names));
    }

    public Integer[] indices(List<Object> names) {
        int size = names.size();
        Integer[] indices = new Integer[size];
        for (int i = 0; i < size; ++i) {
            indices[i] = this.get(names.get(i));
        }
        return indices;
    }

    public static <V> DataFrame<V> reindex(DataFrame<V> df, final Integer ... cols) {
        return new DataFrame(df.transform(cols.length == 1 ? new DataFrame.RowFunction<V, Object>(){

            @Override
            public List<List<Object>> apply(List<V> values) {
                return Collections.singletonList(Collections.singletonList(values.get(cols[0])));
            }
        } : new DataFrame.RowFunction<V, Object>(){

            @Override
            public List<List<Object>> apply(List<V> values) {
                ArrayList key = new ArrayList(cols.length);
                Integer[] integerArray = cols;
                int n = integerArray.length;
                for (int i = 0; i < n; ++i) {
                    int c = integerArray[i];
                    key.add(values.get(c));
                }
                return Collections.singletonList(Collections.singletonList(Collections.unmodifiableList(key)));
            }
        }).col(0), df.columns(), new Views.ListView<V>(df, false));
    }

    public static <V> DataFrame<V> reset(DataFrame<V> df) {
        ArrayList<Integer> index = new ArrayList<Integer>(df.length());
        for (int i = 0; i < df.length(); ++i) {
            index.add(i);
        }
        return new DataFrame(index, df.columns(), new Views.ListView<V>(df, false));
    }
}

