/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joinery.DataFrame;
import joinery.impl.Aggregation;

public class Pivoting {
    public static <V> DataFrame<V> pivot(DataFrame<V> df, Integer[] rows, Integer[] cols, Integer[] values) {
        DataFrame<V> grouped = df.groupBy(rows);
        Map exploded = grouped.explode();
        LinkedHashMap aggregates = new LinkedHashMap();
        for (Map.Entry<Object, DataFrame<V>> entry : exploded.entrySet()) {
            exploded.put(entry.getKey(), entry.getValue().groupBy(cols));
        }
        Integer[] integerArray = values;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int v = integerArray[i];
            aggregates.put(v, new Aggregation.Unique());
        }
        return Pivoting.pivot(exploded, aggregates, grouped.groups().columns());
    }

    public static <I, O> DataFrame<O> pivot(DataFrame<I> df, DataFrame.KeyFunction<I> rows, DataFrame.KeyFunction<I> cols, Map<Integer, ? extends DataFrame.Aggregate<I, O>> values) {
        DataFrame<I> grouped = df.groupBy(rows);
        Map<Object, DataFrame<I>> exploded = grouped.explode();
        for (Map.Entry<Object, DataFrame<I>> entry : exploded.entrySet()) {
            exploded.put(entry.getKey(), entry.getValue().groupBy(cols));
        }
        return Pivoting.pivot(exploded, values, grouped.groups().columns());
    }

    private static <I, O> DataFrame<O> pivot(Map<Object, DataFrame<I>> grouped, Map<Integer, ? extends DataFrame.Aggregate<I, O>> values, Set<Integer> columns) {
        LinkedHashSet<Object> pivotCols = new LinkedHashSet<Object>();
        LinkedHashMap pivotData = new LinkedHashMap();
        LinkedHashMap<Object, DataFrame.Aggregate<I, O>> pivotFunctions = new LinkedHashMap<Object, DataFrame.Aggregate<I, O>>();
        ArrayList<Object> colNames = new ArrayList<Object>(grouped.values().iterator().next().columns());
        for (Map.Entry<Object, DataFrame<I>> rowEntry : grouped.entrySet()) {
            Object colName;
            LinkedHashMap rowData = new LinkedHashMap();
            Iterator<Object> iterator = columns.iterator();
            while (iterator.hasNext()) {
                int c = iterator.next();
                colName = colNames.get(c);
                rowData.put(colName, new ArrayList());
                pivotCols.add(colName);
            }
            for (Object colKey : rowEntry.getValue().groups().keys()) {
                colName = values.keySet().iterator();
                while (colName.hasNext()) {
                    int n = (Integer)colName.next();
                    Object colName2 = Pivoting.name(colKey, colNames.get(n), values);
                    rowData.put(colName2, new ArrayList());
                    pivotCols.add(colName2);
                    pivotFunctions.put(colName2, values.get(n));
                }
            }
            pivotData.put(rowEntry.getKey(), rowData);
        }
        for (Map.Entry<Object, DataFrame<I>> rowEntry : grouped.entrySet()) {
            Object rowName = rowEntry.getKey();
            Map rowData = (Map)pivotData.get(rowName);
            Map<Object, DataFrame<I>> byCol = rowEntry.getValue().explode();
            for (Map.Entry entry : byCol.entrySet()) {
                List colData;
                Object colName;
                for (int c : columns) {
                    colName = colNames.get(c);
                    colData = (List)rowData.get(colName);
                    colData.add(((DataFrame)entry.getValue()).get(0, c));
                }
                for (int c : values.keySet()) {
                    colName = Pivoting.name(entry.getKey(), colNames.get(c), values);
                    colData = (List)rowData.get(colName);
                    colData.addAll(((DataFrame)entry.getValue()).col(c));
                }
            }
        }
        DataFrame<Object> pivot = new DataFrame<Object>(pivotData.keySet(), pivotCols);
        for (Object col : pivot.columns()) {
            for (Object row : pivot.index()) {
                List data = (List)((Map)pivotData.get(row)).get(col);
                if (data == null) continue;
                DataFrame.Aggregate aggregate = (DataFrame.Aggregate)pivotFunctions.get(col);
                if (aggregate != null) {
                    pivot.set(row, col, aggregate.apply(data));
                    continue;
                }
                pivot.set(row, col, data.get(0));
            }
        }
        return pivot;
    }

    private static Object name(Object key, Object name, Map<?, ?> values) {
        ArrayList<Object> colName = key;
        if (values.size() > 1) {
            ArrayList<Object> tmp = new ArrayList<Object>();
            tmp.add(name);
            if (key instanceof List) {
                for (Object col : (List)List.class.cast(key)) {
                    tmp.add(col);
                }
            } else {
                tmp.add(key);
            }
            colName = tmp;
        }
        return colName;
    }
}

