/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl;

import java.util.Arrays;

public class SparseBitSet {
    private static final int INDEX_FACTOR = 4;
    private static final int INDEX_GROWTH = 1;
    private static final int L3_SHIFT = 63 - Long.numberOfLeadingZeros(64L);
    private static final int L3_BITS = (32 - L3_SHIFT) / 4;
    private static final int L3_SIZE = 1 << L3_BITS;
    private static final int L3_MASK = L3_SIZE - 1;
    private static final int L2_SHIFT = L3_SHIFT + L3_BITS;
    private static final int L2_BITS = L3_BITS + 1;
    private static final int L2_SIZE = 1 << L2_BITS;
    private static final int L2_MASK = L2_SIZE - 1;
    private static final int L1_SHIFT = L2_SHIFT + L2_BITS;
    private static final int L1_BITS = 32 - L1_SHIFT - 1;
    private static final int L1_SIZE = 1 << L1_BITS;
    private static final int L1_MASK = (L1_SIZE << 1) - 1;
    private static final int L4_MASK = 63;
    long[][][] bits = new long[L3_SIZE / 4][][];
    int cardinality = 0;

    public boolean get(int index) {
        int l1i = index >> L1_SHIFT & L1_MASK;
        int l2i = index >> L2_SHIFT & L2_MASK;
        int l3i = index >> L3_SHIFT & L3_MASK;
        int l4i = index & 0x3F;
        if (index < 0 || l1i < this.bits.length && this.bits[l1i] != null && this.bits[l1i][l2i] != null) {
            return (this.bits[l1i][l2i][l3i] & 1L << l4i) != 0L;
        }
        return false;
    }

    public void set(int index, boolean value) {
        int l1i = index >> L1_SHIFT & L1_MASK;
        int l2i = index >> L2_SHIFT & L2_MASK;
        int l3i = index >> L3_SHIFT & L3_MASK;
        int l4i = index & 0x3F;
        if (value) {
            int size;
            if (this.bits.length <= l1i && l1i < L1_SIZE && this.bits.length < (size = Math.min(L1_SIZE, Math.max(this.bits.length << 1, 1 << 32 - Integer.numberOfLeadingZeros(l1i))))) {
                this.bits = (long[][][])Arrays.copyOf(this.bits, size);
            }
            if (this.bits[l1i] == null) {
                this.bits[l1i] = new long[L2_SIZE][];
            }
            if (this.bits[l1i][l2i] == null) {
                this.bits[l1i][l2i] = new long[L3_SIZE];
            }
            long[] lArray = this.bits[l1i][l2i];
            int n = l3i;
            lArray[n] = lArray[n] | 1L << l4i;
            ++this.cardinality;
        } else if (l1i < this.bits.length && this.bits[l1i] != null && this.bits[l1i][l2i] != null) {
            long[] lArray = this.bits[l1i][l2i];
            int n = l3i;
            lArray[n] = lArray[n] & (1L << l4i ^ 0xFFFFFFFFFFFFFFFFL);
            --this.cardinality;
        }
    }

    public void set(int index) {
        this.set(index, true);
    }

    public void set(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.set(i);
        }
    }

    public void clear(int index) {
        this.set(index, false);
    }

    public void clear(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.clear(i);
        }
    }

    public void flip(int index) {
        this.set(index, !this.get(index));
    }

    public void flip(int start, int end) {
        for (int i = start; i < end; ++i) {
            this.flip(i);
        }
    }

    public void clear() {
        Arrays.fill((Object[])this.bits, null);
        this.cardinality = 0;
    }

    public int cardinality() {
        return this.cardinality;
    }

    public int nextSetBit(int index) {
        int l2i = index >> L2_SHIFT & L2_MASK;
        int l3i = index >> L3_SHIFT & L3_MASK;
        int l4i = index & 0x3F;
        for (int l1i = index >> L1_SHIFT & L1_MASK; l1i < this.bits.length; ++l1i) {
            while (this.bits[l1i] != null && l2i < this.bits[l1i].length) {
                while (this.bits[l1i][l2i] != null && l3i < this.bits[l1i][l2i].length) {
                    if ((this.bits[l1i][l2i][l3i] & 1L << (l4i += Long.numberOfTrailingZeros(this.bits[l1i][l2i][l3i] >> l4i))) != 0L) {
                        return l1i << L1_SHIFT | l2i << L2_SHIFT | l3i << L3_SHIFT | l4i;
                    }
                    ++l3i;
                    l4i = 0;
                }
                ++l2i;
                l3i = 0;
            }
            l2i = 0;
        }
        return -1;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = this.nextSetBit(0);
        while (i >= 0) {
            if (sb.length() > 1) {
                sb.append(", ");
            }
            sb.append(i);
            i = this.nextSetBit(i + 1);
        }
        sb.append("}");
        return sb.toString();
    }

    public static String parameters() {
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("%s parameters:\n", SparseBitSet.class.getName())).append(String.format("size:\tlevel 1=%d\tlevel 2=%d\tlevel 3=%d\n", L1_SIZE, L2_SIZE, L3_SIZE)).append(String.format("bits:\tlevel 1=%d\tlevel 2=%d\tlevel 3=%d\n", L1_BITS, L2_BITS, L3_BITS)).append(String.format("shift:\tlevel 1=%d\tlevel 2=%d\tlevel 3=%d\n", L1_SHIFT, L2_SHIFT, L3_SHIFT)).append(String.format("mask:\tlevel 1=%s\tlevel 2=%s\tlevel 3=%s\n", Integer.toHexString(L1_MASK), Integer.toHexString(L2_MASK), Integer.toHexString(L3_MASK)));
        return sb.toString();
    }
}

