/*
 * Decompiled with CFR 0.152.
 */
package joinery.impl.js;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import joinery.DataFrame;
import joinery.impl.Grouping;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DataFrameAdapter
extends ScriptableObject {
    private static final long serialVersionUID = 1L;
    private final DataFrame<Object> df;
    private static final DataFrame<Object> EMPTY_DF = new DataFrame();

    public DataFrameAdapter() {
        this.df = EMPTY_DF;
    }

    public DataFrameAdapter(DataFrame<Object> df) {
        this.df = df;
    }

    public DataFrameAdapter(Scriptable scope, DataFrame<Object> df) {
        this.df = df;
        this.setParentScope(scope.getParentScope());
        this.setPrototype(scope.getPrototype());
    }

    public static Scriptable jsConstructor(Context ctx, Object[] args, Function ctor, boolean newExpr) {
        if (args.length == 3 && args[0] instanceof NativeArray) {
            ArrayList<List<Object>> data = new ArrayList<List<Object>>();
            NativeArray array = (NativeArray)NativeArray.class.cast(args[2]);
            Object[] ids = array.getIds();
            int i = 0;
            while ((long)i < array.getLength()) {
                data.add(DataFrameAdapter.asList(array.get(((Integer)ids[i]).intValue(), null)));
                ++i;
            }
            return new DataFrameAdapter(new DataFrame<Object>(DataFrameAdapter.asList(args[0]), DataFrameAdapter.asList(args[1]), data));
        }
        if (args.length == 2 && args[0] instanceof NativeArray) {
            return new DataFrameAdapter(new DataFrame<Object>(DataFrameAdapter.asList(args[0]), DataFrameAdapter.asList(args[1])));
        }
        if (args.length == 1 && args[0] instanceof NativeArray) {
            return new DataFrameAdapter(new DataFrame<Object>((Collection<?>)DataFrameAdapter.asList(args[0])));
        }
        if (args.length > 0) {
            String[] columns = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                columns[i] = Context.toString((Object)args[i]);
            }
            return new DataFrameAdapter(new DataFrame<Object>(columns));
        }
        return new DataFrameAdapter(new DataFrame<Object>());
    }

    private static DataFrameAdapter cast(Scriptable object) {
        return (DataFrameAdapter)((Object)DataFrameAdapter.class.cast(object));
    }

    public static Scriptable jsFunction_add(Context ctx, Scriptable object, Object[] args, Function func) {
        if (args.length == 2 && args[1] instanceof NativeArray) {
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.add(args[0], DataFrameAdapter.asList(args[1])));
        }
        if (args.length == 1 && args[0] instanceof NativeArray) {
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.add(DataFrameAdapter.asList(args[0])));
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.add(args));
    }

    public static Scriptable jsFunction_drop(Context ctx, Scriptable object, Object[] args, Function func) {
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.drop(args));
    }

    public static Scriptable jsFunction_retain(Context ctx, Scriptable object, Object[] args, Function func) {
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.retain(args));
    }

    public static Scriptable jsFunction_reindex(Context ctx, Scriptable object, Object[] args, Function func) {
        if (args.length > 0 && args[0] instanceof NativeArray) {
            if (args.length > 1) {
                return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.reindex(DataFrameAdapter.asList(args[0]).toArray(), Context.toBoolean((Object)args[1])));
            }
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.reindex(DataFrameAdapter.asList(args[0]).toArray()));
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.reindex(args));
    }

    public DataFrameAdapter jsFunction_resetIndex() {
        return new DataFrameAdapter((Scriptable)this, this.df.resetIndex());
    }

    public DataFrameAdapter jsFunction_rename(Object old, Object name) {
        return new DataFrameAdapter((Scriptable)this, this.df.rename(old, name));
    }

    public static Scriptable jsFunction_append(Context ctx, Scriptable object, Object[] args, Function func) {
        if (args.length == 2 && args[1] instanceof NativeArray) {
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.append(args[0], DataFrameAdapter.asList(args[1])));
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.append(DataFrameAdapter.asList(args[0])));
    }

    public DataFrameAdapter jsFunction_reshape(Integer rows, Integer cols) {
        return new DataFrameAdapter((Scriptable)this, this.df.reshape(rows, cols));
    }

    public static Scriptable jsFunction_join(Context ctx, Scriptable object, Object[] args, Function func) {
        DataFrame.JoinType type;
        DataFrame<Object> other = ((DataFrameAdapter)((Object)DataFrameAdapter.class.cast((Object)args[0]))).df;
        DataFrame.JoinType joinType = type = args.length > 1 && args[1] instanceof NativeJavaObject ? (DataFrame.JoinType)((Object)DataFrame.JoinType.class.cast(Context.jsToJava((Object)args[1], DataFrame.JoinType.class))) : null;
        if (args.length > 1 && args[args.length - 1] instanceof Function) {
            DataFrame.KeyFunction f = (DataFrame.KeyFunction)Context.jsToJava((Object)args[args.length - 1], DataFrame.KeyFunction.class);
            if (type != null) {
                return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.join(other, type, f));
            }
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.join(other, f));
        }
        if (type != null) {
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.join(other, type));
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.join(other));
    }

    public static Scriptable jsFunction_joinOn(Context ctx, Scriptable object, Object[] args, Function func) {
        DataFrame.JoinType type;
        DataFrame<Object> other = ((DataFrameAdapter)((Object)DataFrameAdapter.class.cast((Object)args[0]))).df;
        DataFrame.JoinType joinType = type = args.length > 1 && args[1] instanceof NativeJavaObject ? (DataFrame.JoinType)((Object)DataFrame.JoinType.class.cast(Context.jsToJava((Object)args[1], DataFrame.JoinType.class))) : null;
        if (type != null) {
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.joinOn(other, type, Arrays.copyOfRange(args, 2, args.length)));
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.joinOn(other, Arrays.copyOfRange(args, 1, args.length)));
    }

    public static Scriptable jsFunction_merge(Context ctx, Scriptable object, Object[] args, Function func) {
        DataFrame.JoinType type;
        DataFrame<Object> other = ((DataFrameAdapter)((Object)DataFrameAdapter.class.cast((Object)args[0]))).df;
        DataFrame.JoinType joinType = type = args.length > 1 && args[1] instanceof NativeJavaObject ? (DataFrame.JoinType)((Object)DataFrame.JoinType.class.cast(Context.jsToJava((Object)args[1], DataFrame.JoinType.class))) : null;
        if (type != null) {
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.merge(other, type));
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.merge(other));
    }

    public static Scriptable jsFunction_update(Context ctx, Scriptable object, Object[] args, Function func) {
        DataFrame[] others = new DataFrame[args.length];
        for (int i = 0; i < args.length; ++i) {
            others[i] = ((DataFrameAdapter)((Object)DataFrameAdapter.class.cast((Object)args[i]))).df;
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.update(others));
    }

    public static Scriptable jsFunction_coalesce(Context ctx, Scriptable object, Object[] args, Function func) {
        DataFrame[] others = new DataFrame[args.length];
        for (int i = 0; i < args.length; ++i) {
            others[i] = ((DataFrameAdapter)((Object)DataFrameAdapter.class.cast((Object)args[i]))).df;
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.coalesce(others));
    }

    public int jsFunction_size() {
        return this.df.size();
    }

    public int jsFunction_length() {
        return this.df.length();
    }

    public boolean jsFunction_isEmpty() {
        return this.df.isEmpty();
    }

    public Set<Object> jsFunction_index() {
        return this.df.index();
    }

    public Set<Object> jsFunction_columns() {
        return this.df.columns();
    }

    public Object jsFunction_get(Integer row, Integer col) {
        return this.df.get(row, col);
    }

    public DataFrameAdapter jsFunction_slice(Integer rowStart, Integer rowEnd, Integer colStart, Integer colEnd) {
        return new DataFrameAdapter((Scriptable)this, this.df.slice(rowStart, rowEnd, colStart, colEnd));
    }

    public void jsFunction_set(Integer row, Integer col, Scriptable value) {
        this.df.set(row, col, Context.jsToJava((Object)value, Object.class));
    }

    public List<Object> jsFunction_col(Integer column) {
        return this.df.col(column);
    }

    public List<Object> jsFunction_row(Integer row) {
        return this.df.row(row);
    }

    public DataFrameAdapter jsFunction_select(Function predicate) {
        DataFrame.Predicate p = (DataFrame.Predicate)Context.jsToJava((Object)predicate, DataFrame.Predicate.class);
        return new DataFrameAdapter((Scriptable)this, this.df.select(p));
    }

    public static Scriptable jsFunction_head(Context ctx, Scriptable object, Object[] args, Function func) {
        Double limit = args.length == 1 ? Double.valueOf(Context.toNumber((Object)args[0])) : null;
        return new DataFrameAdapter(object, limit != null ? DataFrameAdapter.cast((Scriptable)object).df.head(((Number)limit).intValue()) : DataFrameAdapter.cast((Scriptable)object).df.head());
    }

    public static Scriptable jsFunction_tail(Context ctx, Scriptable object, Object[] args, Function func) {
        Double limit = args.length == 1 ? Double.valueOf(Context.toNumber((Object)args[0])) : null;
        return new DataFrameAdapter(object, limit != null ? DataFrameAdapter.cast((Scriptable)object).df.tail(((Number)limit).intValue()) : DataFrameAdapter.cast((Scriptable)object).df.tail());
    }

    public List<Object> jsFunction_flatten() {
        return this.df.flatten();
    }

    public DataFrameAdapter jsFunction_transpose() {
        return new DataFrameAdapter((Scriptable)this, this.df.transpose());
    }

    public DataFrameAdapter jsFunction_apply(Function function) {
        DataFrame.Function f = (DataFrame.Function)Context.jsToJava((Object)function, DataFrame.Function.class);
        return new DataFrameAdapter((Scriptable)this, this.df.apply(f));
    }

    public DataFrameAdapter jsFunction_transform(Function function) {
        DataFrame.RowFunction f = (DataFrame.RowFunction)Context.jsToJava((Object)function, DataFrame.RowFunction.class);
        return new DataFrameAdapter((Scriptable)this, this.df.transform(f));
    }

    public static Scriptable jsFunction_convert(Context ctx, Scriptable object, Object[] args, Function func) {
        if (args.length > 0) {
            Class[] types = new Class[args.length];
            for (int i = 0; i < args.length; ++i) {
                types[i] = (Class)Class.class.cast(Context.jsToJava((Object)args[i], Class.class));
            }
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.convert(types));
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.convert());
    }

    public DataFrameAdapter jsFunction_isnull() {
        return new DataFrameAdapter((Scriptable)this, this.df.isnull().cast(Object.class));
    }

    public DataFrameAdapter jsFunction_notnull() {
        return new DataFrameAdapter((Scriptable)this, this.df.notnull().cast(Object.class));
    }

    public static Scriptable jsFunction_groupBy(Context ctx, Scriptable object, Object[] args, Function func) {
        if (args.length == 1 && args[0] instanceof Function) {
            DataFrame.KeyFunction f = (DataFrame.KeyFunction)Context.jsToJava((Object)args[0], DataFrame.KeyFunction.class);
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.groupBy(f));
        }
        if (args.length == 1 && args[0] instanceof NativeArray) {
            return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.groupBy(DataFrameAdapter.asList(args[0]).toArray()));
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.groupBy(args));
    }

    public Grouping jsFunction_groups() {
        return this.df.groups();
    }

    public Map<Object, DataFrame<Object>> jsFunction_explode() {
        return this.df.explode();
    }

    public DataFrameAdapter jsFunction_aggregate(Function function) {
        DataFrame.Aggregate f = (DataFrame.Aggregate)Context.jsToJava((Object)function, DataFrame.Aggregate.class);
        return new DataFrameAdapter((Scriptable)this, this.df.aggregate(f));
    }

    public DataFrameAdapter jsFunction_count() {
        return new DataFrameAdapter((Scriptable)this, this.df.count());
    }

    public DataFrameAdapter jsFunction_collapse() {
        return new DataFrameAdapter((Scriptable)this, this.df.collapse());
    }

    public DataFrameAdapter jsFunction_sum() {
        return new DataFrameAdapter((Scriptable)this, this.df.sum());
    }

    public DataFrameAdapter jsFunction_prod() {
        return new DataFrameAdapter((Scriptable)this, this.df.prod());
    }

    public DataFrameAdapter jsFunction_mean() {
        return new DataFrameAdapter((Scriptable)this, this.df.mean());
    }

    public DataFrameAdapter jsFunction_stddev() {
        return new DataFrameAdapter((Scriptable)this, this.df.stddev());
    }

    public DataFrameAdapter jsFunction_var() {
        return new DataFrameAdapter((Scriptable)this, this.df.var());
    }

    public DataFrameAdapter jsFunction_skew() {
        return new DataFrameAdapter((Scriptable)this, this.df.skew());
    }

    public DataFrameAdapter jsFunction_kurt() {
        return new DataFrameAdapter((Scriptable)this, this.df.kurt());
    }

    public DataFrameAdapter jsFunction_min() {
        return new DataFrameAdapter((Scriptable)this, this.df.min());
    }

    public DataFrameAdapter jsFunction_max() {
        return new DataFrameAdapter((Scriptable)this, this.df.max());
    }

    public DataFrameAdapter jsFunction_median() {
        return new DataFrameAdapter((Scriptable)this, this.df.median());
    }

    public DataFrameAdapter jsFunction_cumsum() {
        return new DataFrameAdapter((Scriptable)this, this.df.cumsum());
    }

    public DataFrameAdapter jsFunction_cumprod() {
        return new DataFrameAdapter((Scriptable)this, this.df.cumprod());
    }

    public DataFrameAdapter jsFunction_cummin() {
        return new DataFrameAdapter((Scriptable)this, this.df.cummin());
    }

    public DataFrameAdapter jsFunction_cummax() {
        return new DataFrameAdapter((Scriptable)this, this.df.cummax());
    }

    public DataFrameAdapter jsFunction_describe() {
        return new DataFrameAdapter((Scriptable)this, this.df.describe());
    }

    public static Scriptable jsFunction_pivot(Context ctx, Scriptable object, Object[] args, Function func) {
        Object row = Context.jsToJava((Object)args[0], Object.class);
        Object col = Context.jsToJava((Object)args[0], Object.class);
        Object[] values = new Object[args.length - 2];
        for (int i = 0; i < values.length; ++i) {
            values[i] = Context.jsToJava((Object)args[i + 2], Object.class);
        }
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.pivot(row, col, values));
    }

    public static Scriptable jsFunction_sortBy(Context ctx, Scriptable object, Object[] args, Function func) {
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.sortBy(args));
    }

    public List<Class<?>> jsFunction_types() {
        return this.df.types();
    }

    public DataFrameAdapter jsFunction_numeric() {
        return new DataFrameAdapter((Scriptable)this, this.df.numeric().cast(Object.class));
    }

    public DataFrameAdapter jsFunction_nonnumeric() {
        return new DataFrameAdapter((Scriptable)this, this.df.nonnumeric());
    }

    public Map<Object, List<Object>> jsFunction_map(Object key, Object value) {
        return this.df.map(key, value);
    }

    public static Scriptable jsFunction_unique(Context ctx, Scriptable object, Object[] args, Function func) {
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.unique(args));
    }

    public static Scriptable jsFunction_diff(Context ctx, Scriptable object, Object[] args, Function func) {
        Double period = args.length == 1 ? Context.toNumber((Object)args[0]) : 1.0;
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.diff(((Number)period).intValue()));
    }

    public static Scriptable jsFunction_percentChange(Context ctx, Scriptable object, Object[] args, Function func) {
        Double period = args.length == 1 ? Context.toNumber((Object)args[0]) : 1.0;
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.percentChange(((Number)period).intValue()));
    }

    public static Scriptable jsFunction_rollapply(Context ctx, Scriptable object, Object[] args, Function func) {
        DataFrame.Function f = (DataFrame.Function)Context.jsToJava((Object)args[0], DataFrame.Function.class);
        Double period = args.length == 2 ? Context.toNumber((Object)args[1]) : 1.0;
        return new DataFrameAdapter(object, DataFrameAdapter.cast((Scriptable)object).df.rollapply(f, ((Number)period).intValue()));
    }

    public static Object jsFunction_plot(Context ctx, Scriptable object, Object[] args, Function func) {
        if (args.length > 0) {
            DataFrame.PlotType type = (DataFrame.PlotType)((Object)DataFrame.PlotType.class.cast(Context.jsToJava((Object)args[0], DataFrame.PlotType.class)));
            DataFrameAdapter.cast((Scriptable)object).df.plot(type);
            return Context.getUndefinedValue();
        }
        DataFrameAdapter.cast((Scriptable)object).df.plot();
        return Context.getUndefinedValue();
    }

    public void jsFunction_show() {
        this.df.show();
    }

    public static Scriptable jsStaticFunction_readCsv(Context ctx, Scriptable object, Object[] args, Function func) throws IOException {
        String file = Context.toString((Object)args[0]);
        DataFrame<Object> df = DataFrame.readCsv(file);
        return new DataFrameAdapter(ctx.newObject(object, df.getClass().getSimpleName()), df);
    }

    public void jsFunction_writeCsv(String file) throws IOException {
        this.df.writeCsv(file);
    }

    public static Scriptable jsStaticFunction_readXls(Context ctx, Scriptable object, Object[] args, Function func) throws IOException {
        String file = Context.toString((Object)args[0]);
        DataFrame<Object> df = DataFrame.readXls(file);
        return new DataFrameAdapter(ctx.newObject(object, df.getClass().getSimpleName()), df);
    }

    public void jsFunction_writeXls(String file) throws IOException {
        this.df.writeXls(file);
    }

    public static Scriptable jsFunction_toArray(Context ctx, Scriptable object, Object[] args, Function func) {
        return ctx.newArray(object, DataFrameAdapter.cast((Scriptable)object).df.toArray());
    }

    public static Object jsFunction_toString(Context ctx, Scriptable object, Object[] args, Function func) {
        Double limit = args.length == 1 ? Double.valueOf(Context.toNumber((Object)args[0])) : null;
        return limit != null ? DataFrameAdapter.cast((Scriptable)object).df.toString(((Number)limit).intValue()) : DataFrameAdapter.cast((Scriptable)object).df.toString();
    }

    public Object getDefaultValue(Class<?> hint) {
        if (hint == ScriptRuntime.BooleanClass) {
            return this.df.isEmpty();
        }
        return this.df.toString();
    }

    public String getClassName() {
        return this.df.getClass().getSimpleName();
    }

    public Object[] getIds() {
        ArrayList<String> ids = new ArrayList<String>();
        for (Method m : ((Object)((Object)this)).getClass().getMethods()) {
            String name = m.getName();
            if (!name.startsWith("js") || !name.contains("_")) continue;
            ids.add(name.substring(name.indexOf(95) + 1));
        }
        return ids.toArray();
    }

    public Object[] getAllIds() {
        return this.getIds();
    }

    public boolean equals(Object o) {
        return this.df.equals(o);
    }

    public int hashCode() {
        return this.df.hashCode();
    }

    private static List<Object> asList(Object array) {
        return DataFrameAdapter.asList((NativeArray)NativeArray.class.cast(array));
    }

    private static List<Object> asList(NativeArray array) {
        ArrayList<Object> list = new ArrayList<Object>((int)array.getLength());
        for (Object id : array.getIds()) {
            list.add(array.get(((Integer)id).intValue(), null));
        }
        return list;
    }
}

