/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.header;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.line.XEasyPdfLine;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

class XEasyPdfHeaderParam {
    private XEasyPdfText text;
    private XEasyPdfImage image;
    private List<XEasyPdfLine> lineList = new ArrayList<XEasyPdfLine>(6);
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(5.0f);
    private Float beginX;
    private Float beginY;
    private Float height;
    private boolean isTextPosition = true;

    void init(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        if (this.text == null && this.image == null) {
            throw new IllegalArgumentException("text or image can not be found");
        }
        float imageHeight = this.image != null ? this.image.getHeight(document, page) : 0.0f;
        float textHeight = this.text != null ? this.text.getTextHeight(document, page, this.marginLeft.floatValue(), this.marginRight.floatValue()) : 0.0f;
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        this.beginX = this.marginLeft;
        this.beginY = Float.valueOf(rectangle.getHeight() - imageHeight - this.marginTop.floatValue());
        if (imageHeight > textHeight) {
            this.isTextPosition = false;
        }
        if (this.height == null) {
            this.height = Float.valueOf(Math.max(imageHeight, textHeight) + this.marginTop.floatValue());
        }
    }

    public XEasyPdfText getText() {
        return this.text;
    }

    public XEasyPdfImage getImage() {
        return this.image;
    }

    public List<XEasyPdfLine> getLineList() {
        return this.lineList;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public Float getHeight() {
        return this.height;
    }

    public boolean isTextPosition() {
        return this.isTextPosition;
    }

    public XEasyPdfHeaderParam setText(XEasyPdfText text) {
        this.text = text;
        return this;
    }

    public XEasyPdfHeaderParam setImage(XEasyPdfImage image) {
        this.image = image;
        return this;
    }

    public XEasyPdfHeaderParam setLineList(List<XEasyPdfLine> lineList) {
        this.lineList = lineList;
        return this;
    }

    public XEasyPdfHeaderParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfHeaderParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfHeaderParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfHeaderParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfHeaderParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfHeaderParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfHeaderParam setTextPosition(boolean isTextPosition) {
        this.isTextPosition = isTextPosition;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfHeaderParam)) {
            return false;
        }
        XEasyPdfHeaderParam other = (XEasyPdfHeaderParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XEasyPdfText this$text = this.getText();
        XEasyPdfText other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        XEasyPdfImage this$image = this.getImage();
        XEasyPdfImage other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        List<XEasyPdfLine> this$lineList = this.getLineList();
        List<XEasyPdfLine> other$lineList = other.getLineList();
        if (this$lineList == null ? other$lineList != null : !((Object)this$lineList).equals(other$lineList)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        return this.isTextPosition() == other.isTextPosition();
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfHeaderParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XEasyPdfText $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        XEasyPdfImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        List<XEasyPdfLine> $lineList = this.getLineList();
        result = result * 59 + ($lineList == null ? 43 : ((Object)$lineList).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        result = result * 59 + (this.isTextPosition() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "XEasyPdfHeaderParam(text=" + this.getText() + ", image=" + this.getImage() + ", lineList=" + this.getLineList() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", height=" + this.getHeight() + ", isTextPosition=" + this.isTextPosition() + ")";
    }
}

