/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.image;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.graphics.image.LosslessFactory;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfImageUtil;

class XEasyPdfImageParam {
    private XEasyPdfComponent.ContentMode contentMode = XEasyPdfComponent.ContentMode.APPEND;
    private BufferedImage image;
    private String imageType;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Integer width;
    private Integer height;
    private boolean enableSelfAdaption = true;
    private XEasyPdfImage.ScaleMode scaleMode = XEasyPdfImage.ScaleMode.DEFAULT;
    private XEasyPdfImageStyle style = XEasyPdfImageStyle.CENTER;
    private Float beginX;
    private Float beginY;
    private boolean isDraw = false;

    PDImageXObject init(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        if (this.image == null) {
            throw new FileNotFoundException("the image can not be found");
        }
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        float pageWidth = rectangle.getWidth();
        PDImageXObject pdImage = PDImageXObject.createFromByteArray((PDDocument)document.getTarget(), (byte[])XEasyPdfImageUtil.toBytes(this.image, this.imageType), (String)this.imageType);
        int imageWidth = pdImage.getWidth();
        int imageHeight = pdImage.getHeight();
        if (this.width == null) {
            this.width = imageWidth;
        }
        if (this.height == null) {
            this.height = imageHeight;
        }
        if (this.enableSelfAdaption && (float)this.width.intValue() + this.marginLeft.floatValue() + this.marginRight.floatValue() > pageWidth) {
            this.width = (int)(pageWidth - this.marginLeft.floatValue() - this.marginRight.floatValue());
            this.height = (int)((double)this.width.intValue() / (double)imageWidth * (double)imageHeight);
        }
        if (this.width != imageWidth || this.height != imageHeight) {
            pdImage = LosslessFactory.createFromImage((PDDocument)document.getTarget(), (BufferedImage)XEasyPdfImageUtil.scale(this.image, this.width, this.height, this.scaleMode.getMode()));
        }
        return pdImage;
    }

    void initPosition(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        float pageWidth = rectangle.getWidth();
        float pageHeight = rectangle.getHeight();
        if (this.beginY == null) {
            float footerHeight = 0.0f;
            if (page.getParam().isAllowFooter() && page.getParam().getFooter() != null) {
                footerHeight = page.getParam().getFooter().getHeight();
            }
            if (page.getParam().getPageY() != null) {
                this.beginY = Float.valueOf(page.getParam().getPageY().floatValue() - this.marginTop.floatValue() - (float)this.height.intValue());
                if (this.beginY.floatValue() - footerHeight <= this.marginBottom.floatValue()) {
                    page.addNewPage(document, rectangle);
                    this.beginY = Float.valueOf(page.getParam().getPageY() == null ? pageHeight - this.marginTop.floatValue() - (float)this.height.intValue() : page.getParam().getPageY().floatValue() - this.marginTop.floatValue() - (float)this.height.intValue());
                }
            } else {
                this.beginY = Float.valueOf(pageHeight - this.marginTop.floatValue() - (float)this.height.intValue());
            }
        }
        if (this.beginX == null) {
            this.beginX = this.style == null || this.style == XEasyPdfImageStyle.CENTER ? Float.valueOf((pageWidth - (float)this.width.intValue()) / 2.0f) : (this.style == XEasyPdfImageStyle.LEFT ? this.marginLeft : Float.valueOf(pageWidth - (float)this.width.intValue() - this.marginRight.floatValue()));
        }
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public String getImageType() {
        return this.imageType;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Integer getWidth() {
        return this.width;
    }

    public Integer getHeight() {
        return this.height;
    }

    public boolean isEnableSelfAdaption() {
        return this.enableSelfAdaption;
    }

    public XEasyPdfImage.ScaleMode getScaleMode() {
        return this.scaleMode;
    }

    public XEasyPdfImageStyle getStyle() {
        return this.style;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public boolean isDraw() {
        return this.isDraw;
    }

    public XEasyPdfImageParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfImageParam setImage(BufferedImage image) {
        this.image = image;
        return this;
    }

    public XEasyPdfImageParam setImageType(String imageType) {
        this.imageType = imageType;
        return this;
    }

    public XEasyPdfImageParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfImageParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfImageParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfImageParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfImageParam setWidth(Integer width) {
        this.width = width;
        return this;
    }

    public XEasyPdfImageParam setHeight(Integer height) {
        this.height = height;
        return this;
    }

    public XEasyPdfImageParam setEnableSelfAdaption(boolean enableSelfAdaption) {
        this.enableSelfAdaption = enableSelfAdaption;
        return this;
    }

    public XEasyPdfImageParam setScaleMode(XEasyPdfImage.ScaleMode scaleMode) {
        this.scaleMode = scaleMode;
        return this;
    }

    public XEasyPdfImageParam setStyle(XEasyPdfImageStyle style) {
        this.style = style;
        return this;
    }

    public XEasyPdfImageParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfImageParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfImageParam setDraw(boolean isDraw) {
        this.isDraw = isDraw;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfImageParam)) {
            return false;
        }
        XEasyPdfImageParam other = (XEasyPdfImageParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        BufferedImage this$image = this.getImage();
        BufferedImage other$image = other.getImage();
        if (this$image == null ? other$image != null : !this$image.equals(other$image)) {
            return false;
        }
        String this$imageType = this.getImageType();
        String other$imageType = other.getImageType();
        if (this$imageType == null ? other$imageType != null : !this$imageType.equals(other$imageType)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Integer this$width = this.getWidth();
        Integer other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Integer this$height = this.getHeight();
        Integer other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        if (this.isEnableSelfAdaption() != other.isEnableSelfAdaption()) {
            return false;
        }
        XEasyPdfImage.ScaleMode this$scaleMode = this.getScaleMode();
        XEasyPdfImage.ScaleMode other$scaleMode = other.getScaleMode();
        if (this$scaleMode == null ? other$scaleMode != null : !((Object)((Object)this$scaleMode)).equals((Object)other$scaleMode)) {
            return false;
        }
        XEasyPdfImageStyle this$style = this.getStyle();
        XEasyPdfImageStyle other$style = other.getStyle();
        if (this$style == null ? other$style != null : !((Object)((Object)this$style)).equals((Object)other$style)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        return this.isDraw() == other.isDraw();
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfImageParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        BufferedImage $image = this.getImage();
        result = result * 59 + ($image == null ? 43 : $image.hashCode());
        String $imageType = this.getImageType();
        result = result * 59 + ($imageType == null ? 43 : $imageType.hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Integer $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Integer $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        result = result * 59 + (this.isEnableSelfAdaption() ? 79 : 97);
        XEasyPdfImage.ScaleMode $scaleMode = this.getScaleMode();
        result = result * 59 + ($scaleMode == null ? 43 : ((Object)((Object)$scaleMode)).hashCode());
        XEasyPdfImageStyle $style = this.getStyle();
        result = result * 59 + ($style == null ? 43 : ((Object)((Object)$style)).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        result = result * 59 + (this.isDraw() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "XEasyPdfImageParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", image=" + this.getImage() + ", imageType=" + this.getImageType() + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", enableSelfAdaption=" + this.isEnableSelfAdaption() + ", scaleMode=" + (Object)((Object)this.getScaleMode()) + ", style=" + (Object)((Object)this.getStyle()) + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", isDraw=" + this.isDraw() + ")";
    }
}

