/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.line;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.line.XEasyPdfBaseLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineCapStyle;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

public class XEasyPdfDottedSplitLine
implements XEasyPdfLine {
    private final XEasyPdfLineParam param = new XEasyPdfLineParam();
    private Float lineLength = Float.valueOf(10.0f);
    private Float lineSpace = Float.valueOf(10.0f);

    @Override
    public XEasyPdfDottedSplitLine setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public XEasyPdfDottedSplitLine setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfDottedSplitLine setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfDottedSplitLine setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setLineWidth(float lineWidth) {
        this.param.setLineWidth(Float.valueOf(lineWidth));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setColor(Color color) {
        this.param.setColor(color);
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setLineCapStyle(XEasyPdfLineCapStyle lineCapStyle) {
        this.param.setStyle(lineCapStyle);
        return this;
    }

    public XEasyPdfDottedSplitLine setLineLength(float lineLength) {
        this.lineLength = Float.valueOf(lineLength);
        return this;
    }

    public XEasyPdfDottedSplitLine setLineSpace(float lineSpace) {
        this.lineSpace = Float.valueOf(lineSpace);
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setPosition(float beginX, float beginY) {
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setWidth(float width) {
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setHeight(float height) {
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.setContentMode(mode);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        this.init(document, page);
        XEasyPdfBaseLine xpdfLine = new XEasyPdfBaseLine(this.param);
        xpdfLine.draw(document, page);
        int count = (int)Math.floor((page.getLastPage().getMediaBox().getWidth() - this.param.getMarginLeft().floatValue() - this.param.getMarginRight().floatValue()) / (this.lineLength.floatValue() + this.lineSpace.floatValue()));
        for (int j = 1; j <= count; ++j) {
            this.param.setBeginX(Float.valueOf(this.param.getEndX().floatValue() + this.lineSpace.floatValue())).setEndX(Float.valueOf(this.param.getBeginX().floatValue() + this.lineLength.floatValue()));
            xpdfLine = new XEasyPdfBaseLine(this.param);
            xpdfLine.draw(document, page);
        }
        if (page.getParam().isAllowResetPosition()) {
            page.getParam().setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getLineWidth().floatValue() / 2.0f));
        }
        this.param.setDraw(true);
        if (this.param.getFontPath() != null) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }

    private void init(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        this.param.checkPage(document, page);
        float lineWidth = this.param.getLineWidth().floatValue() / 2.0f;
        this.param.setBeginX(this.param.getMarginLeft()).setBeginY(Float.valueOf(page.getParam().getPageY() == null ? page.getLastPage().getMediaBox().getHeight() - this.param.getMarginTop().floatValue() - lineWidth : page.getParam().getPageY().floatValue() - this.param.getMarginTop().floatValue() - lineWidth)).setEndX(Float.valueOf(this.param.getBeginX().floatValue() + this.lineLength.floatValue())).setEndY(this.param.getBeginY());
        if (this.param.getFont() == null) {
            this.param.setFont(XEasyPdfFontUtil.loadFont(document, page, this.param.getFontPath()));
        }
    }
}

