/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.mark;

import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.graphics.state.PDExtendedGraphicsState;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

class XEasyPdfWatermarkParam {
    private String fontPath;
    private PDFont font;
    private Float fontSize = Float.valueOf(50.0f);
    private Float alpha = Float.valueOf(0.1f);
    private Double radians = 120.0;
    private String text;
    private Float wordSpace;
    private Float leading;

    PDExtendedGraphicsState init(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.font == null) {
            this.font = XEasyPdfFontUtil.loadFont(document, page, this.fontPath);
        }
        if (this.wordSpace == null) {
            this.wordSpace = Float.valueOf(this.fontSize.floatValue() * 6.0f);
        }
        if (this.leading == null) {
            this.leading = Float.valueOf(this.fontSize.floatValue() * 2.0f);
        }
        this.initText(this.text == null ? "XEasyPdf" : this.text, page.getLastPage().getMediaBox().getWidth());
        PDExtendedGraphicsState state = new PDExtendedGraphicsState();
        state.setNonStrokingAlphaConstant(this.alpha);
        state.setAlphaSourceFlag(true);
        return state;
    }

    private void initText(String text, float pageWidth) {
        int wordCount = (int)(pageWidth / this.fontSize.floatValue()) + 1;
        int blankCount = (int)(this.wordSpace.floatValue() / this.fontSize.floatValue());
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < wordCount; ++i) {
            builder.append(text);
            for (int j = 0; j < blankCount; ++j) {
                builder.append(' ');
            }
        }
        this.text = builder.toString();
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public Float getFontSize() {
        return this.fontSize;
    }

    public Float getAlpha() {
        return this.alpha;
    }

    public Double getRadians() {
        return this.radians;
    }

    public String getText() {
        return this.text;
    }

    public Float getWordSpace() {
        return this.wordSpace;
    }

    public Float getLeading() {
        return this.leading;
    }

    public XEasyPdfWatermarkParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfWatermarkParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfWatermarkParam setFontSize(Float fontSize) {
        this.fontSize = fontSize;
        return this;
    }

    public XEasyPdfWatermarkParam setAlpha(Float alpha) {
        this.alpha = alpha;
        return this;
    }

    public XEasyPdfWatermarkParam setRadians(Double radians) {
        this.radians = radians;
        return this;
    }

    public XEasyPdfWatermarkParam setText(String text) {
        this.text = text;
        return this;
    }

    public XEasyPdfWatermarkParam setWordSpace(Float wordSpace) {
        this.wordSpace = wordSpace;
        return this;
    }

    public XEasyPdfWatermarkParam setLeading(Float leading) {
        this.leading = leading;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfWatermarkParam)) {
            return false;
        }
        XEasyPdfWatermarkParam other = (XEasyPdfWatermarkParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        Float this$fontSize = this.getFontSize();
        Float other$fontSize = other.getFontSize();
        if (this$fontSize == null ? other$fontSize != null : !((Object)this$fontSize).equals(other$fontSize)) {
            return false;
        }
        Float this$alpha = this.getAlpha();
        Float other$alpha = other.getAlpha();
        if (this$alpha == null ? other$alpha != null : !((Object)this$alpha).equals(other$alpha)) {
            return false;
        }
        Double this$radians = this.getRadians();
        Double other$radians = other.getRadians();
        if (this$radians == null ? other$radians != null : !((Object)this$radians).equals(other$radians)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        Float this$wordSpace = this.getWordSpace();
        Float other$wordSpace = other.getWordSpace();
        if (this$wordSpace == null ? other$wordSpace != null : !((Object)this$wordSpace).equals(other$wordSpace)) {
            return false;
        }
        Float this$leading = this.getLeading();
        Float other$leading = other.getLeading();
        return !(this$leading == null ? other$leading != null : !((Object)this$leading).equals(other$leading));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfWatermarkParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        Float $fontSize = this.getFontSize();
        result = result * 59 + ($fontSize == null ? 43 : ((Object)$fontSize).hashCode());
        Float $alpha = this.getAlpha();
        result = result * 59 + ($alpha == null ? 43 : ((Object)$alpha).hashCode());
        Double $radians = this.getRadians();
        result = result * 59 + ($radians == null ? 43 : ((Object)$radians).hashCode());
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        Float $wordSpace = this.getWordSpace();
        result = result * 59 + ($wordSpace == null ? 43 : ((Object)$wordSpace).hashCode());
        Float $leading = this.getLeading();
        result = result * 59 + ($leading == null ? 43 : ((Object)$leading).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfWatermarkParam(fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", fontSize=" + this.getFontSize() + ", alpha=" + this.getAlpha() + ", radians=" + this.getRadians() + ", text=" + this.getText() + ", wordSpace=" + this.getWordSpace() + ", leading=" + this.getLeading() + ")";
    }
}

