/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.rect;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

class XEasyPdfRectParam {
    private XEasyPdfComponent.ContentMode contentMode = XEasyPdfComponent.ContentMode.APPEND;
    private Float marginLeft = Float.valueOf(0.0f);
    private Float marginRight = Float.valueOf(0.0f);
    private Float marginTop = Float.valueOf(0.0f);
    private Float marginBottom = Float.valueOf(0.0f);
    private Float width;
    private Float height;
    private Float beginX;
    private Float beginY;
    private boolean hasBorder = false;
    private Color backgroundColor = Color.WHITE;
    private Color borderColor = Color.BLACK;
    private boolean checkPage = true;
    private boolean isNewLine = true;
    private boolean isDraw = false;

    void init(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        Float pageY;
        if (this.width == null) {
            throw new RuntimeException("the width can not null");
        }
        if (this.height == null) {
            throw new RuntimeException("the height can not null");
        }
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        float footerHeight = 0.0f;
        if (this.beginY == null) {
            if (page.getParam().isAllowFooter() && page.getParam().getFooter() != null) {
                footerHeight = page.getParam().getFooter().getHeight();
            }
            this.beginY = Float.valueOf((pageY = page.getParam().getPageY()) == null ? rectangle.getHeight() - this.marginTop.floatValue() - this.height.floatValue() : pageY.floatValue() - this.marginTop.floatValue() - this.height.floatValue());
        }
        if (this.checkPage && this.beginY.floatValue() - footerHeight <= this.marginBottom.floatValue()) {
            page.addNewPage(document, rectangle);
            pageY = page.getParam().getPageY();
            this.beginY = Float.valueOf(pageY == null ? rectangle.getHeight() - this.marginTop.floatValue() - this.height.floatValue() : pageY.floatValue() - this.marginTop.floatValue() - this.height.floatValue());
        }
        if (this.beginX == null) {
            Float pageX = page.getParam().getPageX();
            this.beginX = Float.valueOf(pageX == null ? this.marginLeft.floatValue() : pageX.floatValue() + this.marginLeft.floatValue());
        }
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.contentMode;
    }

    public Float getMarginLeft() {
        return this.marginLeft;
    }

    public Float getMarginRight() {
        return this.marginRight;
    }

    public Float getMarginTop() {
        return this.marginTop;
    }

    public Float getMarginBottom() {
        return this.marginBottom;
    }

    public Float getWidth() {
        return this.width;
    }

    public Float getHeight() {
        return this.height;
    }

    public Float getBeginX() {
        return this.beginX;
    }

    public Float getBeginY() {
        return this.beginY;
    }

    public boolean isHasBorder() {
        return this.hasBorder;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public boolean isCheckPage() {
        return this.checkPage;
    }

    public boolean isNewLine() {
        return this.isNewLine;
    }

    public boolean isDraw() {
        return this.isDraw;
    }

    public XEasyPdfRectParam setContentMode(XEasyPdfComponent.ContentMode contentMode) {
        this.contentMode = contentMode;
        return this;
    }

    public XEasyPdfRectParam setMarginLeft(Float marginLeft) {
        this.marginLeft = marginLeft;
        return this;
    }

    public XEasyPdfRectParam setMarginRight(Float marginRight) {
        this.marginRight = marginRight;
        return this;
    }

    public XEasyPdfRectParam setMarginTop(Float marginTop) {
        this.marginTop = marginTop;
        return this;
    }

    public XEasyPdfRectParam setMarginBottom(Float marginBottom) {
        this.marginBottom = marginBottom;
        return this;
    }

    public XEasyPdfRectParam setWidth(Float width) {
        this.width = width;
        return this;
    }

    public XEasyPdfRectParam setHeight(Float height) {
        this.height = height;
        return this;
    }

    public XEasyPdfRectParam setBeginX(Float beginX) {
        this.beginX = beginX;
        return this;
    }

    public XEasyPdfRectParam setBeginY(Float beginY) {
        this.beginY = beginY;
        return this;
    }

    public XEasyPdfRectParam setHasBorder(boolean hasBorder) {
        this.hasBorder = hasBorder;
        return this;
    }

    public XEasyPdfRectParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public XEasyPdfRectParam setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
        return this;
    }

    public XEasyPdfRectParam setCheckPage(boolean checkPage) {
        this.checkPage = checkPage;
        return this;
    }

    public XEasyPdfRectParam setNewLine(boolean isNewLine) {
        this.isNewLine = isNewLine;
        return this;
    }

    public XEasyPdfRectParam setDraw(boolean isDraw) {
        this.isDraw = isDraw;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfRectParam)) {
            return false;
        }
        XEasyPdfRectParam other = (XEasyPdfRectParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XEasyPdfComponent.ContentMode this$contentMode = this.getContentMode();
        XEasyPdfComponent.ContentMode other$contentMode = other.getContentMode();
        if (this$contentMode == null ? other$contentMode != null : !((Object)((Object)this$contentMode)).equals((Object)other$contentMode)) {
            return false;
        }
        Float this$marginLeft = this.getMarginLeft();
        Float other$marginLeft = other.getMarginLeft();
        if (this$marginLeft == null ? other$marginLeft != null : !((Object)this$marginLeft).equals(other$marginLeft)) {
            return false;
        }
        Float this$marginRight = this.getMarginRight();
        Float other$marginRight = other.getMarginRight();
        if (this$marginRight == null ? other$marginRight != null : !((Object)this$marginRight).equals(other$marginRight)) {
            return false;
        }
        Float this$marginTop = this.getMarginTop();
        Float other$marginTop = other.getMarginTop();
        if (this$marginTop == null ? other$marginTop != null : !((Object)this$marginTop).equals(other$marginTop)) {
            return false;
        }
        Float this$marginBottom = this.getMarginBottom();
        Float other$marginBottom = other.getMarginBottom();
        if (this$marginBottom == null ? other$marginBottom != null : !((Object)this$marginBottom).equals(other$marginBottom)) {
            return false;
        }
        Float this$width = this.getWidth();
        Float other$width = other.getWidth();
        if (this$width == null ? other$width != null : !((Object)this$width).equals(other$width)) {
            return false;
        }
        Float this$height = this.getHeight();
        Float other$height = other.getHeight();
        if (this$height == null ? other$height != null : !((Object)this$height).equals(other$height)) {
            return false;
        }
        Float this$beginX = this.getBeginX();
        Float other$beginX = other.getBeginX();
        if (this$beginX == null ? other$beginX != null : !((Object)this$beginX).equals(other$beginX)) {
            return false;
        }
        Float this$beginY = this.getBeginY();
        Float other$beginY = other.getBeginY();
        if (this$beginY == null ? other$beginY != null : !((Object)this$beginY).equals(other$beginY)) {
            return false;
        }
        if (this.isHasBorder() != other.isHasBorder()) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        if (this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor)) {
            return false;
        }
        Color this$borderColor = this.getBorderColor();
        Color other$borderColor = other.getBorderColor();
        if (this$borderColor == null ? other$borderColor != null : !((Object)this$borderColor).equals(other$borderColor)) {
            return false;
        }
        if (this.isCheckPage() != other.isCheckPage()) {
            return false;
        }
        if (this.isNewLine() != other.isNewLine()) {
            return false;
        }
        return this.isDraw() == other.isDraw();
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfRectParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XEasyPdfComponent.ContentMode $contentMode = this.getContentMode();
        result = result * 59 + ($contentMode == null ? 43 : ((Object)((Object)$contentMode)).hashCode());
        Float $marginLeft = this.getMarginLeft();
        result = result * 59 + ($marginLeft == null ? 43 : ((Object)$marginLeft).hashCode());
        Float $marginRight = this.getMarginRight();
        result = result * 59 + ($marginRight == null ? 43 : ((Object)$marginRight).hashCode());
        Float $marginTop = this.getMarginTop();
        result = result * 59 + ($marginTop == null ? 43 : ((Object)$marginTop).hashCode());
        Float $marginBottom = this.getMarginBottom();
        result = result * 59 + ($marginBottom == null ? 43 : ((Object)$marginBottom).hashCode());
        Float $width = this.getWidth();
        result = result * 59 + ($width == null ? 43 : ((Object)$width).hashCode());
        Float $height = this.getHeight();
        result = result * 59 + ($height == null ? 43 : ((Object)$height).hashCode());
        Float $beginX = this.getBeginX();
        result = result * 59 + ($beginX == null ? 43 : ((Object)$beginX).hashCode());
        Float $beginY = this.getBeginY();
        result = result * 59 + ($beginY == null ? 43 : ((Object)$beginY).hashCode());
        result = result * 59 + (this.isHasBorder() ? 79 : 97);
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        Color $borderColor = this.getBorderColor();
        result = result * 59 + ($borderColor == null ? 43 : ((Object)$borderColor).hashCode());
        result = result * 59 + (this.isCheckPage() ? 79 : 97);
        result = result * 59 + (this.isNewLine() ? 79 : 97);
        result = result * 59 + (this.isDraw() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "XEasyPdfRectParam(contentMode=" + (Object)((Object)this.getContentMode()) + ", marginLeft=" + this.getMarginLeft() + ", marginRight=" + this.getMarginRight() + ", marginTop=" + this.getMarginTop() + ", marginBottom=" + this.getMarginBottom() + ", width=" + this.getWidth() + ", height=" + this.getHeight() + ", beginX=" + this.getBeginX() + ", beginY=" + this.getBeginY() + ", hasBorder=" + this.isHasBorder() + ", backgroundColor=" + this.getBackgroundColor() + ", borderColor=" + this.getBorderColor() + ", checkPage=" + this.isCheckPage() + ", isNewLine=" + this.isNewLine() + ", isDraw=" + this.isDraw() + ")";
    }
}

