/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.awt.Color;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.rect.XEasyPdfRect;
import wiki.xsx.core.pdf.component.table.XEasyPdfCellParam;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfCell {
    private final XEasyPdfCellParam param = new XEasyPdfCellParam();

    public XEasyPdfCell(String text) {
        this.param.setText(text);
    }

    public XEasyPdfCell(String text, boolean hasBorder) {
        this.param.setText(text).setHasBorder(hasBorder);
    }

    public XEasyPdfCell(float width, float height) {
        this.param.setWidth(Float.valueOf(width)).setHeight(Float.valueOf(height));
    }

    public XEasyPdfCell setWidth(float width) {
        this.param.setWidth(Float.valueOf(width + 1.0f));
        return this;
    }

    public XEasyPdfCell setHeight(float height) {
        this.param.setHeight(Float.valueOf(height));
        return this;
    }

    public XEasyPdfCell setHasBorder(boolean hasBorder) {
        this.param.setHasBorder(hasBorder);
        return this;
    }

    public XEasyPdfCell setBackgroundColor(Color backgroundColor) {
        this.param.setBackgroundColor(backgroundColor);
        return this;
    }

    public XEasyPdfCell setBorderColor(Color borderColor) {
        this.param.setBorderColor(borderColor);
        return this;
    }

    public XEasyPdfCell setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setTextMargin(float margin) {
        this.param.setTextMarginLeft(Float.valueOf(margin)).setTextMarginRight(Float.valueOf(margin)).setTextMarginTop(Float.valueOf(margin)).setTextMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setTextMarginLeft(float margin) {
        this.param.setTextMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setTextMarginRight(float margin) {
        this.param.setTextMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setTextMarginTop(float margin) {
        this.param.setTextMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setTextMarginBottom(float margin) {
        this.param.setTextMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfCell setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfCell setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public XEasyPdfCell setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(fontSize));
        return this;
    }

    public XEasyPdfCell setFontColor(Color fontColor) {
        this.param.setFontColor(fontColor);
        return this;
    }

    public XEasyPdfCell setText(String text) {
        this.param.setText(text);
        return this;
    }

    public XEasyPdfCell setStyle(XEasyPdfTextStyle style) {
        this.param.setStyle(style);
        return this;
    }

    XEasyPdfCellParam getParam() {
        return this.param;
    }

    void init(XEasyPdfDocument document, XEasyPdfRow row) throws IOException {
        this.param.init(document, row);
        row.getParam().setHeight(Float.valueOf(Math.max(row.getParam().getHeight().floatValue(), this.param.getHeight().floatValue())));
    }

    void doDraw(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row) throws IOException {
        if (this.param.isHasBorder()) {
            this.writeBorder(document, page, row);
        }
        if (this.param.getSplitTextList() != null) {
            this.writeText(document, page, row);
        }
        if (this.param.getFontPath() != null) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    private void writeBorder(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row) throws IOException {
        new XEasyPdfRect(this.param.getWidth().floatValue(), row.getParam().getHeight().floatValue(), row.getParam().getBeginX(), Float.valueOf(row.getParam().getBeginY().floatValue() - this.param.getMarginTop().floatValue())).setContentMode(this.param.getContentMode()).setBackgroundColor(this.param.getBackgroundColor()).setBorderColor(this.param.getBorderColor()).setNewLine(false).setHasBorder(true).disableCheckPage().draw(document, page);
    }

    private void writeText(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfRow row) throws IOException {
        new XEasyPdfText(this.param.getSplitTextList()).setContentMode(this.param.getContentMode()).setFont(this.param.getFont()).setFontSize(this.param.getFontSize().floatValue()).setFontColor(this.param.getFontColor()).setWidth(this.param.getWidth().floatValue()).setHeight(row.getParam().getHeight().floatValue()).setMarginLeft(this.param.getTextMarginLeft().floatValue()).setMarginRight(this.param.getTextMarginRight().floatValue()).setMarginTop(this.param.getTextMarginTop().floatValue()).setMarginBottom(this.param.getTextMarginBottom().floatValue()).setStyle(this.param.getStyle()).setPosition(row.getParam().getBeginX().floatValue() + 1.0f, row.getParam().getBeginY().floatValue() - this.param.getMarginTop().floatValue() - this.param.getFontSize().floatValue() + row.getParam().getHeight().floatValue()).draw(document, page);
    }
}

