/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableParam;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfTable
implements XEasyPdfComponent {
    private final XEasyPdfTableParam param = new XEasyPdfTableParam();

    public XEasyPdfTable(XEasyPdfRow ... rows) {
        Collections.addAll(this.param.getRows(), rows);
    }

    public XEasyPdfTable(List<XEasyPdfRow> rowList) {
        this.param.getRows().addAll(rowList);
    }

    public XEasyPdfTable addRow(XEasyPdfRow ... rows) {
        Collections.addAll(this.param.getRows(), rows);
        return this;
    }

    public XEasyPdfTable addRow(List<XEasyPdfRow> rowList) {
        this.param.getRows().addAll(rowList);
        return this;
    }

    public XEasyPdfTable setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfTable setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public XEasyPdfTable setFontSize(float fontSize) {
        this.param.setFontSize(fontSize);
        return this;
    }

    public XEasyPdfTable setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTable setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTable setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTable setStyle(XEasyPdfTextStyle style) {
        this.param.setStyle(style);
        return this;
    }

    @Override
    public XEasyPdfTable setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    @Deprecated
    public XEasyPdfTable setWidth(float width) {
        return this;
    }

    @Override
    @Deprecated
    public XEasyPdfTable setHeight(float height) {
        return this;
    }

    @Override
    public XEasyPdfTable setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.setContentMode(mode);
        return this;
    }

    XEasyPdfTableParam getParam() {
        return this.param;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        page.disablePosition();
        this.param.init(document, page);
        if (this.param.getBeginX() != null) {
            page.getParam().setPageX(this.param.getBeginX());
        }
        if (this.param.getBeginY() != null) {
            page.getParam().setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getMarginTop().floatValue()));
        } else {
            page.getParam().setPageY(Float.valueOf(page.getParam().getPageY() == null ? page.getLastPage().getMediaBox().getHeight() - this.param.getMarginTop().floatValue() : page.getParam().getPageY().floatValue() - this.param.getMarginTop().floatValue()));
        }
        List<XEasyPdfRow> rows = this.param.getRows();
        for (XEasyPdfRow row : rows) {
            row.doDraw(document, page, this);
        }
        page.enablePosition();
        this.param.setDraw(true);
        if (this.param.getFontPath() != null) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }
}

