/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.text;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextParam;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfText
implements XEasyPdfComponent {
    private final XEasyPdfTextParam param = new XEasyPdfTextParam();
    private int lastLineIndex = 0;

    public XEasyPdfText(String text) {
        this.param.setText(text);
    }

    public XEasyPdfText(List<String> textList) {
        this.param.setSplitTextList(textList);
    }

    public XEasyPdfText(float fontSize, String text) {
        this.param.setFontSize(Float.valueOf(fontSize)).setText(text);
    }

    public XEasyPdfText(float fontSize, List<String> textList) {
        this.param.setFontSize(Float.valueOf(fontSize)).setSplitTextList(textList);
    }

    public XEasyPdfText setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setLeading(float leading) {
        if (leading > 0.0f) {
            this.param.setLeading(Float.valueOf(leading));
        }
        return this;
    }

    public XEasyPdfText setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfText setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public XEasyPdfText setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(fontSize));
        return this;
    }

    public XEasyPdfText setFontColor(Color fontColor) {
        this.param.setFontColor(fontColor);
        return this;
    }

    public XEasyPdfText setStyle(XEasyPdfTextStyle style) {
        this.param.setStyle(style);
        return this;
    }

    public XEasyPdfText setSplitTextList(List<String> splitTextList) {
        this.param.setSplitTextList(splitTextList);
        return this;
    }

    public XEasyPdfText setNewLine(boolean isNewLine) {
        this.param.setNewLine(isNewLine);
        return this;
    }

    public XEasyPdfText setCheckPage(boolean isCheckPage) {
        this.param.setCheckPage(isCheckPage);
        return this;
    }

    @Override
    public XEasyPdfText setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfText setWidth(float width) {
        this.param.setMaxWidth(Float.valueOf(width));
        return this;
    }

    @Override
    public XEasyPdfText setHeight(float height) {
        this.param.setMaxHeight(Float.valueOf(height));
        return this;
    }

    @Override
    public XEasyPdfText setContentMode(XEasyPdfComponent.ContentMode mode) {
        this.param.setContentMode(mode);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        this.doDraw(document, page);
        if (this.param.getFontPath() != null) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
    }

    @Override
    public boolean isDraw() {
        return this.param.isDraw();
    }

    public float getTextHeight(XEasyPdfDocument document, XEasyPdfPage page, float marginLeft, float marginRight) throws IOException {
        return this.param.getTextHeight(document, page, marginLeft, marginRight);
    }

    private PDPageContentStream initPageContentStream(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.param.getContentMode().getMode(), true, false);
        contentStream.setFont(this.param.getFont(), this.param.getFontSize().floatValue());
        contentStream.setNonStrokingColor(this.param.getFontColor());
        contentStream.setLeading(this.param.getLeading().floatValue() + this.param.getFontSize().floatValue());
        return contentStream;
    }

    private void doDraw(XEasyPdfDocument document, XEasyPdfPage page) throws IOException {
        if (!this.param.isNewLine()) {
            page.disablePosition();
        }
        this.param.init(document, page);
        List<String> splitTextList = this.param.getSplitTextList();
        int totalLineIndex = splitTextList.size() - 1;
        boolean lineIndex = false;
        PDPageContentStream stream = null;
        if (this.param.getStyle() == null || this.param.getStyle() == XEasyPdfTextStyle.LEFT) {
            for (String text : splitTextList) {
                stream = this.writeTextWithLeft(document, page, this.checkPage(document, page, stream), text);
            }
            if (stream != null) {
                stream.endText();
                if (totalLineIndex > -1) {
                    this.param.setBeginY(Float.valueOf(this.param.getBeginY().floatValue() - (float)(this.lastLineIndex - 1) * (this.param.getFontSize().floatValue() + this.param.getLeading().floatValue()) - this.param.getLeading().floatValue()));
                }
            }
        } else if (this.param.getStyle() == XEasyPdfTextStyle.CENTER) {
            for (String text : splitTextList) {
                stream = this.writeTextWithCenter(document, page, this.checkPage(document, page, stream), text);
            }
            if (totalLineIndex > -1) {
                this.param.setBeginY(Float.valueOf(this.param.getBeginY().floatValue() + this.param.getFontSize().floatValue() + this.param.getLeading().floatValue()));
            }
        } else {
            for (String text : splitTextList) {
                stream = this.writeTextWithRight(document, page, this.checkPage(document, page, stream), text);
            }
            if (totalLineIndex > -1) {
                this.param.setBeginY(Float.valueOf(this.param.getBeginY().floatValue() + this.param.getFontSize().floatValue() + this.param.getLeading().floatValue()));
            }
        }
        if (splitTextList.size() > 0) {
            float textWidth = this.param.getFontSize().floatValue() * this.param.getFont().getStringWidth(splitTextList.get(totalLineIndex)) / 1000.0f;
            page.getParam().setPageX(Float.valueOf(page.getParam().getPageX() == null ? textWidth : textWidth + page.getParam().getPageX().floatValue()));
        }
        if (stream != null) {
            stream.setNonStrokingColor(Color.BLACK);
            stream.close();
            if (page.getParam().isAllowResetPosition()) {
                page.getParam().setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getFontSize().floatValue() / 3.0f));
            }
        }
        this.param.setDraw(true);
    }

    private PDPageContentStream checkPage(XEasyPdfDocument document, XEasyPdfPage page, PDPageContentStream stream) throws IOException {
        if (this.param.isCheckPage()) {
            float footerHeight = 0.0f;
            if (page.getParam().isAllowFooter() && page.getParam().getFooter() != null) {
                footerHeight = page.getParam().getFooter().getHeight();
            }
            if (this.param.getBeginY().floatValue() - ((float)this.lastLineIndex * (this.param.getFontSize().floatValue() + this.param.getLeading().floatValue()) - this.param.getLeading().floatValue()) - footerHeight <= this.param.getMarginBottom().floatValue()) {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
                PDRectangle rectangle = page.getLastPage().getMediaBox();
                page.addNewPage(document, rectangle);
                this.param.setBeginX(this.param.getMarginLeft()).setBeginY(Float.valueOf(page.getParam().getPageY() == null ? rectangle.getHeight() - this.param.getMarginTop().floatValue() - this.param.getFontSize().floatValue() - this.param.getLeading().floatValue() : page.getParam().getPageY().floatValue() - this.param.getMarginTop().floatValue() - this.param.getFontSize().floatValue() - this.param.getLeading().floatValue()));
            }
        }
        return stream;
    }

    private PDPageContentStream writeTextWithLeft(XEasyPdfDocument document, XEasyPdfPage page, PDPageContentStream stream, String text) throws IOException {
        if (stream == null) {
            this.lastLineIndex = 0;
            stream = this.initPageContentStream(document, page);
            stream.beginText();
            stream.newLineAtOffset(this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue());
        }
        stream.showText(text);
        stream.newLine();
        this.param.setBeginY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getFontSize().floatValue() - this.param.getLeading().floatValue()));
        return stream;
    }

    private PDPageContentStream writeTextWithCenter(XEasyPdfDocument document, XEasyPdfPage page, PDPageContentStream stream, String text) throws IOException {
        if (stream == null) {
            this.lastLineIndex = 0;
            stream = this.initPageContentStream(document, page);
        }
        stream.beginText();
        stream.newLineAtOffset(this.param.getBeginX().floatValue() + (this.param.getMaxWidth().floatValue() - this.param.getMarginLeft().floatValue() - this.param.getMarginRight().floatValue() - this.param.getFontSize().floatValue() * this.param.getFont().getStringWidth(text) / 1000.0f) / 2.0f, this.param.getBeginY().floatValue());
        stream.showText(text);
        stream.endText();
        this.param.setBeginY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getFontSize().floatValue() - this.param.getLeading().floatValue()));
        return stream;
    }

    private PDPageContentStream writeTextWithRight(XEasyPdfDocument document, XEasyPdfPage page, PDPageContentStream stream, String text) throws IOException {
        if (stream == null) {
            this.lastLineIndex = 0;
            stream = this.initPageContentStream(document, page);
        }
        stream.beginText();
        stream.newLineAtOffset(this.param.getBeginX().floatValue() + this.param.getMaxWidth().floatValue() - this.param.getFontSize().floatValue() * this.param.getFont().getStringWidth(text) / 1000.0f - this.param.getMarginRight().floatValue(), this.param.getBeginY().floatValue());
        stream.showText(text);
        stream.endText();
        this.param.setBeginY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getFontSize().floatValue() - this.param.getLeading().floatValue()));
        return stream;
    }
}

