/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.component.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.mark.XEasyPdfWatermark;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentInfo;
import wiki.xsx.core.pdf.doc.XEasyPdfDocumentPermission;
import wiki.xsx.core.pdf.page.XEasyPdfPage;
import wiki.xsx.core.pdf.util.XEasyPdfFontUtil;

class XEasyPdfDocumentParam {
    private String fontPath;
    private PDFont font;
    private PDDocument source;
    private PDDocument target;
    private List<XEasyPdfPage> pageList = new ArrayList<XEasyPdfPage>(256);
    private Map<String, String> formMap;
    private XEasyPdfImage globalBackgroundImage;
    private XEasyPdfWatermark globalWatermark;
    private XEasyPdfHeader globalHeader;
    private XEasyPdfFooter globalFooter;
    private XEasyPdfDocumentPermission permission;
    private XEasyPdfDocumentInfo documentInfo;
    private boolean isReset;
    private Color backgroundColor = Color.WHITE;

    void initFont(XEasyPdfDocument document) {
        this.font = XEasyPdfFontUtil.loadFont(document, this.fontPath);
    }

    void initInfo(XEasyPdfDocument document) {
        if (this.source != null) {
            PDDocumentInformation documentInformation = this.source.getDocumentInformation();
            this.documentInfo = new XEasyPdfDocumentInfo(document).setTitle(documentInformation.getTitle()).setAuthor(documentInformation.getAuthor()).setSubject(documentInformation.getSubject()).setKeywords(documentInformation.getKeywords()).setCreator(documentInformation.getCreator()).setCreateTime(documentInformation.getCreationDate()).setUpdateTime(documentInformation.getModificationDate());
        }
    }

    public String getFontPath() {
        return this.fontPath;
    }

    public PDFont getFont() {
        return this.font;
    }

    public PDDocument getSource() {
        return this.source;
    }

    public PDDocument getTarget() {
        return this.target;
    }

    public List<XEasyPdfPage> getPageList() {
        return this.pageList;
    }

    public Map<String, String> getFormMap() {
        return this.formMap;
    }

    public XEasyPdfImage getGlobalBackgroundImage() {
        return this.globalBackgroundImage;
    }

    public XEasyPdfWatermark getGlobalWatermark() {
        return this.globalWatermark;
    }

    public XEasyPdfHeader getGlobalHeader() {
        return this.globalHeader;
    }

    public XEasyPdfFooter getGlobalFooter() {
        return this.globalFooter;
    }

    public XEasyPdfDocumentPermission getPermission() {
        return this.permission;
    }

    public XEasyPdfDocumentInfo getDocumentInfo() {
        return this.documentInfo;
    }

    public boolean isReset() {
        return this.isReset;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public XEasyPdfDocumentParam setFontPath(String fontPath) {
        this.fontPath = fontPath;
        return this;
    }

    public XEasyPdfDocumentParam setFont(PDFont font) {
        this.font = font;
        return this;
    }

    public XEasyPdfDocumentParam setSource(PDDocument source) {
        this.source = source;
        return this;
    }

    public XEasyPdfDocumentParam setTarget(PDDocument target) {
        this.target = target;
        return this;
    }

    public XEasyPdfDocumentParam setPageList(List<XEasyPdfPage> pageList) {
        this.pageList = pageList;
        return this;
    }

    public XEasyPdfDocumentParam setFormMap(Map<String, String> formMap) {
        this.formMap = formMap;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalBackgroundImage(XEasyPdfImage globalBackgroundImage) {
        this.globalBackgroundImage = globalBackgroundImage;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalWatermark(XEasyPdfWatermark globalWatermark) {
        this.globalWatermark = globalWatermark;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalHeader(XEasyPdfHeader globalHeader) {
        this.globalHeader = globalHeader;
        return this;
    }

    public XEasyPdfDocumentParam setGlobalFooter(XEasyPdfFooter globalFooter) {
        this.globalFooter = globalFooter;
        return this;
    }

    public XEasyPdfDocumentParam setPermission(XEasyPdfDocumentPermission permission) {
        this.permission = permission;
        return this;
    }

    public XEasyPdfDocumentParam setDocumentInfo(XEasyPdfDocumentInfo documentInfo) {
        this.documentInfo = documentInfo;
        return this;
    }

    public XEasyPdfDocumentParam setReset(boolean isReset) {
        this.isReset = isReset;
        return this;
    }

    public XEasyPdfDocumentParam setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfDocumentParam)) {
            return false;
        }
        XEasyPdfDocumentParam other = (XEasyPdfDocumentParam)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fontPath = this.getFontPath();
        String other$fontPath = other.getFontPath();
        if (this$fontPath == null ? other$fontPath != null : !this$fontPath.equals(other$fontPath)) {
            return false;
        }
        PDFont this$font = this.getFont();
        PDFont other$font = other.getFont();
        if (this$font == null ? other$font != null : !this$font.equals(other$font)) {
            return false;
        }
        PDDocument this$source = this.getSource();
        PDDocument other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        PDDocument this$target = this.getTarget();
        PDDocument other$target = other.getTarget();
        if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
            return false;
        }
        List<XEasyPdfPage> this$pageList = this.getPageList();
        List<XEasyPdfPage> other$pageList = other.getPageList();
        if (this$pageList == null ? other$pageList != null : !((Object)this$pageList).equals(other$pageList)) {
            return false;
        }
        Map<String, String> this$formMap = this.getFormMap();
        Map<String, String> other$formMap = other.getFormMap();
        if (this$formMap == null ? other$formMap != null : !((Object)this$formMap).equals(other$formMap)) {
            return false;
        }
        XEasyPdfImage this$globalBackgroundImage = this.getGlobalBackgroundImage();
        XEasyPdfImage other$globalBackgroundImage = other.getGlobalBackgroundImage();
        if (this$globalBackgroundImage == null ? other$globalBackgroundImage != null : !this$globalBackgroundImage.equals(other$globalBackgroundImage)) {
            return false;
        }
        XEasyPdfWatermark this$globalWatermark = this.getGlobalWatermark();
        XEasyPdfWatermark other$globalWatermark = other.getGlobalWatermark();
        if (this$globalWatermark == null ? other$globalWatermark != null : !this$globalWatermark.equals(other$globalWatermark)) {
            return false;
        }
        XEasyPdfHeader this$globalHeader = this.getGlobalHeader();
        XEasyPdfHeader other$globalHeader = other.getGlobalHeader();
        if (this$globalHeader == null ? other$globalHeader != null : !this$globalHeader.equals(other$globalHeader)) {
            return false;
        }
        XEasyPdfFooter this$globalFooter = this.getGlobalFooter();
        XEasyPdfFooter other$globalFooter = other.getGlobalFooter();
        if (this$globalFooter == null ? other$globalFooter != null : !this$globalFooter.equals(other$globalFooter)) {
            return false;
        }
        XEasyPdfDocumentPermission this$permission = this.getPermission();
        XEasyPdfDocumentPermission other$permission = other.getPermission();
        if (this$permission == null ? other$permission != null : !this$permission.equals(other$permission)) {
            return false;
        }
        XEasyPdfDocumentInfo this$documentInfo = this.getDocumentInfo();
        XEasyPdfDocumentInfo other$documentInfo = other.getDocumentInfo();
        if (this$documentInfo == null ? other$documentInfo != null : !this$documentInfo.equals(other$documentInfo)) {
            return false;
        }
        if (this.isReset() != other.isReset()) {
            return false;
        }
        Color this$backgroundColor = this.getBackgroundColor();
        Color other$backgroundColor = other.getBackgroundColor();
        return !(this$backgroundColor == null ? other$backgroundColor != null : !((Object)this$backgroundColor).equals(other$backgroundColor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfDocumentParam;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fontPath = this.getFontPath();
        result = result * 59 + ($fontPath == null ? 43 : $fontPath.hashCode());
        PDFont $font = this.getFont();
        result = result * 59 + ($font == null ? 43 : $font.hashCode());
        PDDocument $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        PDDocument $target = this.getTarget();
        result = result * 59 + ($target == null ? 43 : $target.hashCode());
        List<XEasyPdfPage> $pageList = this.getPageList();
        result = result * 59 + ($pageList == null ? 43 : ((Object)$pageList).hashCode());
        Map<String, String> $formMap = this.getFormMap();
        result = result * 59 + ($formMap == null ? 43 : ((Object)$formMap).hashCode());
        XEasyPdfImage $globalBackgroundImage = this.getGlobalBackgroundImage();
        result = result * 59 + ($globalBackgroundImage == null ? 43 : $globalBackgroundImage.hashCode());
        XEasyPdfWatermark $globalWatermark = this.getGlobalWatermark();
        result = result * 59 + ($globalWatermark == null ? 43 : $globalWatermark.hashCode());
        XEasyPdfHeader $globalHeader = this.getGlobalHeader();
        result = result * 59 + ($globalHeader == null ? 43 : $globalHeader.hashCode());
        XEasyPdfFooter $globalFooter = this.getGlobalFooter();
        result = result * 59 + ($globalFooter == null ? 43 : $globalFooter.hashCode());
        XEasyPdfDocumentPermission $permission = this.getPermission();
        result = result * 59 + ($permission == null ? 43 : $permission.hashCode());
        XEasyPdfDocumentInfo $documentInfo = this.getDocumentInfo();
        result = result * 59 + ($documentInfo == null ? 43 : $documentInfo.hashCode());
        result = result * 59 + (this.isReset() ? 79 : 97);
        Color $backgroundColor = this.getBackgroundColor();
        result = result * 59 + ($backgroundColor == null ? 43 : ((Object)$backgroundColor).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfDocumentParam(fontPath=" + this.getFontPath() + ", font=" + this.getFont() + ", source=" + this.getSource() + ", target=" + this.getTarget() + ", pageList=" + this.getPageList() + ", formMap=" + this.getFormMap() + ", globalBackgroundImage=" + this.getGlobalBackgroundImage() + ", globalWatermark=" + this.getGlobalWatermark() + ", globalHeader=" + this.getGlobalHeader() + ", globalFooter=" + this.getGlobalFooter() + ", permission=" + this.getPermission() + ", documentInfo=" + this.getDocumentInfo() + ", isReset=" + this.isReset() + ", backgroundColor=" + this.getBackgroundColor() + ")";
    }
}

