/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.doc;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageTree;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.util.XEasyPdfConvertUtil;

public class XEasyPdfDocumentSplitter {
    private final PDDocument document;
    private final XEasyPdfDocument pdfDocument;
    private final List<List<Integer>> documentList = new ArrayList<List<Integer>>(10);

    XEasyPdfDocumentSplitter(XEasyPdfDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
        this.document = this.pdfDocument.getTarget();
    }

    public XEasyPdfDocumentSplitter addDocument(int ... pageIndex) {
        this.documentList.add(XEasyPdfConvertUtil.toInteger(pageIndex));
        return this;
    }

    public XEasyPdfDocumentSplitter split(String outputPath) throws IOException {
        return this.split(outputPath, null);
    }

    public XEasyPdfDocumentSplitter split(String outputPath, String prefix) throws IOException {
        if (prefix == null) {
            prefix = "x-easypdf";
        }
        if (!this.documentList.isEmpty()) {
            int count = this.documentList.size();
            for (int i = 0; i < count; ++i) {
                StringBuilder fileNameBuilder = new StringBuilder();
                fileNameBuilder.append(outputPath).append(File.separator).append(prefix).append(i + 1).append(".pdf");
                try (OutputStream outputStream = Files.newOutputStream(Paths.get(fileNameBuilder.toString(), new String[0]), new OpenOption[0]);){
                    this.split(outputStream, XEasyPdfConvertUtil.toInt(this.documentList.get(i)));
                    continue;
                }
            }
        } else {
            List documents = new Splitter().split(this.document);
            int index = 1;
            for (PDDocument target : documents) {
                StringBuilder fileNameBuilder = new StringBuilder();
                fileNameBuilder.append(outputPath).append(File.separator).append(prefix).append(index).append(".pdf");
                try (OutputStream outputStream = Files.newOutputStream(Paths.get(fileNameBuilder.toString(), new String[0]), new OpenOption[0]);){
                    this.pdfDocument.setInfoAndPolicy(target);
                    target.save(outputStream);
                    target.close();
                }
                ++index;
            }
        }
        return this;
    }

    public XEasyPdfDocumentSplitter split(OutputStream outputStream, int ... pageIndex) throws IOException {
        try (PDDocument target = new PDDocument();){
            PDPageTree sourcePages = this.document.getPages();
            for (int index : pageIndex) {
                target.addPage(sourcePages.get(index));
                PDPage pdPage = sourcePages.get(index);
                PDPage importPage = target.importPage(pdPage);
                importPage.setResources(pdPage.getResources());
            }
            this.pdfDocument.setInfoAndPolicy(target);
            target.save(outputStream);
        }
        return this;
    }

    public XEasyPdfDocument finish() {
        return this.pdfDocument;
    }
}

