/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.handler;

import java.io.File;
import java.io.InputStream;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.footer.XEasyPdfDefaultFooter;
import wiki.xsx.core.pdf.component.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.component.header.XEasyPdfDefaultHeader;
import wiki.xsx.core.pdf.component.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.component.image.XEasyPdfImage;
import wiki.xsx.core.pdf.component.line.XEasyPdfBaseLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfDottedSplitLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfSolidSplitLine;
import wiki.xsx.core.pdf.component.mark.XEasyPdfDefaultWatermark;
import wiki.xsx.core.pdf.component.rect.XEasyPdfRect;
import wiki.xsx.core.pdf.component.table.XEasyPdfCell;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTable;
import wiki.xsx.core.pdf.component.text.XEasyPdfText;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPage;

public class XEasyPdfHandler {

    public static class Footer {
        public static XEasyPdfFooter build(XEasyPdfText text) {
            return new XEasyPdfDefaultFooter(text);
        }

        public static XEasyPdfFooter build(XEasyPdfImage image) {
            return new XEasyPdfDefaultFooter(image);
        }

        public static XEasyPdfFooter build(XEasyPdfImage image, XEasyPdfText text) {
            return new XEasyPdfDefaultFooter(image, text);
        }
    }

    public static class Header {
        public static XEasyPdfHeader build(XEasyPdfText text) {
            return new XEasyPdfDefaultHeader(text);
        }

        public static XEasyPdfHeader build(XEasyPdfImage image) {
            return new XEasyPdfDefaultHeader(image);
        }

        public static XEasyPdfHeader build(XEasyPdfImage image, XEasyPdfText text) {
            return new XEasyPdfDefaultHeader(image, text);
        }
    }

    public static class Table {
        public static XEasyPdfTable build(XEasyPdfRow ... rows) {
            return new XEasyPdfTable(rows);
        }

        public static XEasyPdfTable build(List<XEasyPdfRow> rowList) {
            return new XEasyPdfTable(rowList);
        }

        public static class Row {
            public static XEasyPdfRow build(XEasyPdfCell ... cells) {
                return new XEasyPdfRow(cells);
            }

            public static XEasyPdfRow build(List<XEasyPdfCell> cellList) {
                return new XEasyPdfRow(cellList);
            }

            public static class Cell {
                public static XEasyPdfCell build(String text) {
                    return new XEasyPdfCell(text);
                }

                public static XEasyPdfCell build(String text, boolean hasBorder) {
                    return new XEasyPdfCell(text, hasBorder);
                }

                public static XEasyPdfCell build(float width, float height) {
                    return new XEasyPdfCell(width, height);
                }
            }
        }
    }

    public static class Rect {
        public static XEasyPdfRect build(float width, float height) {
            return new XEasyPdfRect(width, height);
        }

        public static XEasyPdfRect build(float width, float height, float beginX, float beginY) {
            return new XEasyPdfRect(width, height, Float.valueOf(beginX), Float.valueOf(beginY));
        }
    }

    public static class Image {
        public static XEasyPdfImage build(File image) {
            return new XEasyPdfImage(image);
        }

        public static XEasyPdfImage build(InputStream imageInputStream, String imageType) {
            return new XEasyPdfImage(imageInputStream, imageType);
        }

        public static XEasyPdfImage build(File image, int width, int height) {
            return new XEasyPdfImage(image, width, height);
        }

        public static XEasyPdfImage build(InputStream imageInputStream, String imageType, int width, int height) {
            return new XEasyPdfImage(imageInputStream, imageType, width, height);
        }
    }

    public static class SplitLine {

        public static class DottedLine {
            public static XEasyPdfDottedSplitLine build() {
                return new XEasyPdfDottedSplitLine();
            }
        }

        public static class SolidLine {
            public static XEasyPdfSolidSplitLine build() {
                return new XEasyPdfSolidSplitLine();
            }
        }
    }

    public static class Line {
        public static XEasyPdfBaseLine build(float beginX, float beginY, float endX, float endY) {
            return new XEasyPdfBaseLine(beginX, beginY, endX, endY);
        }
    }

    public static class Text {
        public static XEasyPdfText build(String text) {
            return new XEasyPdfText(text);
        }

        public static XEasyPdfText build(List<String> textList) {
            return new XEasyPdfText(textList);
        }

        public static XEasyPdfText build(float fontSize, String text) {
            return new XEasyPdfText(fontSize, text);
        }

        public static XEasyPdfText build(float fontSize, List<String> textList) {
            return new XEasyPdfText(fontSize, textList);
        }
    }

    public static class Watermark {
        public static XEasyPdfDefaultWatermark build(String text) {
            return new XEasyPdfDefaultWatermark(text);
        }

        public static XEasyPdfDefaultWatermark build(float fontSize, String text) {
            return new XEasyPdfDefaultWatermark(fontSize, text);
        }
    }

    public static class Page {
        public static XEasyPdfPage build(XEasyPdfComponent ... components) {
            return new XEasyPdfPage().addComponent(components);
        }

        public static XEasyPdfPage build(XEasyPdfDefaultWatermark watermark, XEasyPdfComponent ... components) {
            return new XEasyPdfPage().setWatermark(watermark).addComponent(components);
        }

        public static XEasyPdfPage build(PDRectangle pageSize, XEasyPdfComponent ... components) {
            return new XEasyPdfPage(pageSize).addComponent(components);
        }

        public static XEasyPdfPage build(PDRectangle pageSize, XEasyPdfDefaultWatermark watermark, XEasyPdfComponent ... components) {
            return new XEasyPdfPage(pageSize).setWatermark(watermark).addComponent(components);
        }
    }

    public static class Document {
        public static XEasyPdfDocument build() {
            return new XEasyPdfDocument();
        }

        public static XEasyPdfDocument load(String sourcePath) {
            return new XEasyPdfDocument(sourcePath);
        }

        public static XEasyPdfDocument load(InputStream sourceInputStream) {
            return new XEasyPdfDocument(sourceInputStream);
        }
    }
}

