/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.page;

import java.awt.Color;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.footer.XEasyPdfFooter;
import wiki.xsx.core.pdf.component.header.XEasyPdfHeader;
import wiki.xsx.core.pdf.component.mark.XEasyPdfWatermark;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.page.XEasyPdfPageParam;

public class XEasyPdfPage {
    private XEasyPdfPageParam param = new XEasyPdfPageParam();

    public XEasyPdfPage() {
    }

    public XEasyPdfPage(PDPage page) {
        this.param.getPageList().add(page);
    }

    public XEasyPdfPage(PDRectangle pageSize) {
        if (pageSize != null) {
            this.param.setPageSize(pageSize);
        }
    }

    public XEasyPdfPage addPage(PDPage page) {
        this.param.getPageList().add(page);
        return this;
    }

    public XEasyPdfPage addNewPage(XEasyPdfDocument document, PDRectangle pageSize) throws IOException {
        this.param.getNewPageList().add(pageSize == null ? new PDPage(this.param.getPageSize()) : new PDPage(pageSize));
        this.getParam().setPageX(null).setPageY(null);
        this.drawHeaderAndFooter(document);
        this.drawBackgroundImage(document);
        this.setLastPageBackgroundColor(document);
        return this;
    }

    public XEasyPdfPage setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfPage setFont(PDFont font) {
        this.param.setFont(font);
        this.param.setFontPath("");
        return this;
    }

    public PDFont getFont() {
        return this.param.getFont();
    }

    public XEasyPdfPage setBackgroundColor(Color backgroundColor) {
        this.param.setBackgroundColor(backgroundColor);
        return this;
    }

    public Color getBackgroundColor() {
        return this.param.getBackgroundColor();
    }

    public XEasyPdfPage setWatermark(XEasyPdfWatermark watermark) {
        this.param.setWatermark(watermark);
        return this;
    }

    public XEasyPdfWatermark getWatermark() {
        return this.param.getWatermark();
    }

    public XEasyPdfPage setHeader(XEasyPdfHeader header) {
        this.param.setHeader(header);
        return this;
    }

    public XEasyPdfHeader getHeader() {
        return this.param.getHeader();
    }

    public XEasyPdfPage setFooter(XEasyPdfFooter footer) {
        this.param.setFooter(footer);
        return this;
    }

    public XEasyPdfFooter getFooter() {
        return this.param.getFooter();
    }

    public PDPage getLastPage() {
        List<PDPage> oldPageList;
        List<PDPage> pageList = this.param.getNewPageList();
        PDPage pdPage = pageList.isEmpty() ? ((oldPageList = this.param.getPageList()).isEmpty() ? null : oldPageList.get(oldPageList.size() - 1)) : pageList.get(pageList.size() - 1);
        return pdPage;
    }

    public XEasyPdfPage enableWatermark() {
        this.param.setAllowWatermark(true);
        return this;
    }

    public XEasyPdfPage disableWatermark() {
        this.param.setAllowWatermark(false);
        return this;
    }

    public XEasyPdfPage enableHeader() {
        this.param.setAllowHeader(true);
        return this;
    }

    public XEasyPdfPage disableHeader() {
        this.param.setAllowHeader(false);
        return this;
    }

    public XEasyPdfPage enableFooter() {
        this.param.setAllowFooter(true);
        return this;
    }

    public XEasyPdfPage disableFooter() {
        this.param.setAllowFooter(false);
        return this;
    }

    public XEasyPdfPage enablePosition() {
        this.param.setAllowResetPosition(true);
        return this;
    }

    public XEasyPdfPage disablePosition() {
        this.param.setAllowResetPosition(false);
        return this;
    }

    public XEasyPdfPage addComponent(XEasyPdfComponent ... components) {
        if (components != null) {
            this.param.getComponentList().addAll(Arrays.asList(components));
        }
        return this;
    }

    public XEasyPdfPage build(XEasyPdfDocument document) throws IOException {
        return this.build(document, this.param.getPageSize());
    }

    public XEasyPdfPage build(XEasyPdfDocument document, PDRectangle pageSize) throws IOException {
        List<XEasyPdfComponent> componentList;
        this.param.init(document, this);
        if (this.param.getPageList().isEmpty()) {
            this.addNewPage(document, pageSize);
        }
        if (!(componentList = this.param.getComponentList()).isEmpty()) {
            for (XEasyPdfComponent component : componentList) {
                component.draw(document, this);
            }
        }
        this.drawWatermark(document);
        if (this.param.getFontPath() != null) {
            this.param.getFont().subset();
            this.param.setFont(null);
        }
        return this;
    }

    private XEasyPdfPage setLastPageBackgroundColor(XEasyPdfDocument document) throws IOException {
        PDPage lastPage;
        if (this.param.getBackgroundColor() != null && !Color.WHITE.equals(this.param.getBackgroundColor()) && (lastPage = this.getLastPage()) != null) {
            PDRectangle rectangle = lastPage.getMediaBox();
            PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), lastPage, PDPageContentStream.AppendMode.PREPEND, true, false);
            contentStream.addRect(0.0f, 0.0f, rectangle.getWidth(), rectangle.getHeight());
            contentStream.setNonStrokingColor(this.param.getBackgroundColor());
            contentStream.fill();
            contentStream.setNonStrokingColor(Color.BLACK);
            contentStream.close();
        }
        return this;
    }

    private void drawBackgroundImage(XEasyPdfDocument document) throws IOException {
        if (this.param.isAllowBackgroundImage()) {
            if (this.param.getBackgroundImage() == null) {
                this.param.setBackgroundImage(document.getGlobalBackgroundImage());
            }
            if (this.param.getBackgroundImage() != null) {
                this.disablePosition();
                this.param.getBackgroundImage().setContentMode(XEasyPdfComponent.ContentMode.PREPEND).draw(document, this);
                this.enablePosition();
            }
        }
    }

    private void drawHeaderAndFooter(XEasyPdfDocument document) throws IOException {
        this.drawHeader(document);
        this.drawFooter(document);
    }

    private void drawHeader(XEasyPdfDocument document) throws IOException {
        if (this.param.isAllowHeader()) {
            if (this.param.getHeader() == null) {
                this.param.setHeader(document.getGlobalHeader());
            }
            if (this.param.getHeader() != null) {
                this.param.getHeader().draw(document, this);
            }
        }
    }

    private void drawFooter(XEasyPdfDocument document) throws IOException {
        if (this.param.isAllowFooter()) {
            if (this.param.getFooter() == null) {
                this.param.setFooter(document.getGlobalFooter());
            }
            if (this.param.getFooter() != null) {
                this.param.getFooter().draw(document, this);
            }
        }
    }

    private void drawWatermark(XEasyPdfDocument document) throws IOException {
        if (this.param.isAllowWatermark()) {
            if (this.param.getWatermark() == null) {
                this.param.setWatermark(document.getGlobalWatermark());
            }
            if (this.param.getWatermark() != null) {
                this.param.getWatermark().draw(document, this);
            }
        }
    }

    public XEasyPdfPageParam getParam() {
        return this.param;
    }

    public XEasyPdfPage setParam(XEasyPdfPageParam param) {
        this.param = param;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfPage)) {
            return false;
        }
        XEasyPdfPage other = (XEasyPdfPage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XEasyPdfPageParam this$param = this.getParam();
        XEasyPdfPageParam other$param = other.getParam();
        return !(this$param == null ? other$param != null : !((Object)this$param).equals(other$param));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfPage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XEasyPdfPageParam $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        return result;
    }

    public String toString() {
        return "XEasyPdfPage(param=" + this.getParam() + ")";
    }
}

