/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.util;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;

public class XEasyPdfImageUtil {
    public static BufferedImage read(File imageFile) throws IOException {
        if (imageFile == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        return ImageIO.read(imageFile);
    }

    public static BufferedImage read(InputStream imageStream) throws IOException {
        if (imageStream == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        return ImageIO.read(imageStream);
    }

    public static String parseType(File imageFile) {
        if (imageFile == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        String name = imageFile.getName();
        int dot = imageFile.getName().lastIndexOf(46);
        if (dot == -1) {
            throw new IllegalArgumentException("Image type not supported: " + name);
        }
        return name.substring(dot + 1).toLowerCase();
    }

    public static BufferedImage scale(BufferedImage sourceImage, int width, int height, int scaleMode) {
        if (sourceImage == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        Image temp = sourceImage.getScaledInstance(width, height, scaleMode);
        BufferedImage image = new BufferedImage(width, height, 1);
        Graphics2D graphics = image.createGraphics();
        graphics.drawImage(temp, 0, 0, null);
        graphics.dispose();
        return image;
    }

    public static byte[] toBytes(BufferedImage sourceImage, String imageType) throws IOException {
        if (sourceImage == null) {
            throw new IllegalArgumentException("Image can not be null");
        }
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageIO.write((RenderedImage)sourceImage, imageType, outputStream);
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
    }
}

