/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.dialect.hive.parser;

import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLTableElement;
import com.alibaba.druid.sql.dialect.hive.stmt.HiveCreateTableStatement;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLCreateTableParser;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;

public class HiveCreateTableParser
extends SQLCreateTableParser {
    public HiveCreateTableParser(SQLExprParser exprParser) {
        super(exprParser);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public SQLCreateTableStatement parseCreateTable(boolean acceptCreate) {
        HiveCreateTableStatement stmt = this.newCreateStatement();
        if (acceptCreate) {
            if (this.lexer.hasComment() && this.lexer.isKeepComments()) {
                stmt.addBeforeComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.CREATE);
        }
        if (this.lexer.identifierEquals("GLOBAL")) {
            this.lexer.nextToken();
            if (!this.lexer.identifierEquals("TEMPORARY")) throw new ParserException("syntax error " + this.lexer.info());
            this.lexer.nextToken();
            stmt.setType(SQLCreateTableStatement.Type.GLOBAL_TEMPORARY);
        } else if (this.lexer.token() == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("LOCAL")) {
            this.lexer.nextToken();
            if (this.lexer.token() != Token.IDENTIFIER || !this.lexer.stringVal().equalsIgnoreCase("TEMPORAY")) throw new ParserException("syntax error. " + this.lexer.info());
            this.lexer.nextToken();
            stmt.setType(SQLCreateTableStatement.Type.LOCAL_TEMPORARY);
        }
        this.accept(Token.TABLE);
        if (this.lexer.token() == Token.IF || this.lexer.identifierEquals("IF")) {
            this.lexer.nextToken();
            this.accept(Token.NOT);
            this.accept(Token.EXISTS);
            stmt.setIfNotExiists(true);
        }
        stmt.setName(this.exprParser.name());
        if (this.lexer.token() == Token.LPAREN) {
            this.lexer.nextToken();
            do {
                SQLColumnDefinition column;
                Token token;
                if ((token = this.lexer.token()) == Token.IDENTIFIER && this.lexer.stringVal().equalsIgnoreCase("SUPPLEMENTAL") && "oracle".equals(this.dbType)) {
                    this.parseCreateTableSupplementalLogingProps(stmt);
                } else if (token == Token.IDENTIFIER || token == Token.LITERAL_ALIAS) {
                    column = this.exprParser.parseColumn();
                    stmt.getTableElementList().add(column);
                } else if (token == Token.PRIMARY || token == Token.UNIQUE || token == Token.CHECK || token == Token.CONSTRAINT || token == Token.FOREIGN) {
                    SQLConstraint constraint = this.exprParser.parseConstaint();
                    constraint.setParent(stmt);
                    stmt.getTableElementList().add((SQLTableElement)((Object)constraint));
                } else {
                    if (token == Token.TABLESPACE) {
                        throw new ParserException("TODO " + this.lexer.info());
                    }
                    column = this.exprParser.parseColumn();
                    stmt.getTableElementList().add(column);
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            } while (this.lexer.token() != Token.RPAREN);
            this.accept(Token.RPAREN);
            if (this.lexer.identifierEquals("INHERITS")) {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLName inherits = this.exprParser.name();
                stmt.setInherits(new SQLExprTableSource(inherits));
                this.accept(Token.RPAREN);
            }
        }
        if (this.lexer.token() == Token.PARTITIONED) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                if (this.lexer.token() != Token.IDENTIFIER) {
                    throw new ParserException("expect identifier. " + this.lexer.info());
                }
                SQLColumnDefinition column = this.exprParser.parseColumn();
                stmt.addPartitionColumn(column);
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    column.addAfterComment(this.lexer.readAndResetComments());
                }
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
                if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                column.addAfterComment(this.lexer.readAndResetComments());
            }
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CLUSTERED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            this.exprParser.names(stmt.getClusteredBy());
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SORTED)) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            this.accept(Token.LPAREN);
            while (true) {
                SQLSelectOrderByItem item = this.exprParser.parseSelectOrderByItem();
                stmt.addSortedByItem(item);
                if (this.lexer.token() != Token.COMMA) break;
                this.lexer.nextToken();
            }
            this.accept(Token.RPAREN);
        }
        if (stmt.getClusteredBy().size() > 0 || stmt.getSortedBy().size() > 0) {
            this.accept(Token.INTO);
            if (this.lexer.token() != Token.LITERAL_INT) {
                throw new ParserException("into buckets must be integer. " + this.lexer.info());
            }
            stmt.setBuckets(this.lexer.integerValue().intValue());
            this.lexer.nextToken();
            this.acceptIdentifier("BUCKETS");
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.STORED)) {
            this.lexer.nextToken();
            this.accept(Token.AS);
            SQLName name = this.exprParser.name();
            stmt.setStoredAs(name);
        }
        if (this.lexer.token() != Token.AS) return stmt;
        this.lexer.nextToken();
        SQLSelect select = this.createSQLSelectParser().select();
        stmt.setSelect(select);
        return stmt;
    }

    @Override
    protected HiveCreateTableStatement newCreateStatement() {
        return new HiveCreateTableStatement();
    }
}

