/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.druid.sql.parser;

import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLCommentHint;
import com.alibaba.druid.sql.ast.SQLDataType;
import com.alibaba.druid.sql.ast.SQLDataTypeImpl;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLExprImpl;
import com.alibaba.druid.sql.ast.SQLLimit;
import com.alibaba.druid.sql.ast.SQLName;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLOrderBy;
import com.alibaba.druid.sql.ast.SQLOrderingSpecification;
import com.alibaba.druid.sql.ast.SQLOver;
import com.alibaba.druid.sql.ast.SQLPartitionValue;
import com.alibaba.druid.sql.ast.expr.SQLAggregateExpr;
import com.alibaba.druid.sql.ast.expr.SQLAggregateOption;
import com.alibaba.druid.sql.ast.expr.SQLAllColumnExpr;
import com.alibaba.druid.sql.ast.expr.SQLAllExpr;
import com.alibaba.druid.sql.ast.expr.SQLAnyExpr;
import com.alibaba.druid.sql.ast.expr.SQLBetweenExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLBooleanExpr;
import com.alibaba.druid.sql.ast.expr.SQLCaseExpr;
import com.alibaba.druid.sql.ast.expr.SQLCastExpr;
import com.alibaba.druid.sql.ast.expr.SQLCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLCurrentOfCursorExpr;
import com.alibaba.druid.sql.ast.expr.SQLDateExpr;
import com.alibaba.druid.sql.ast.expr.SQLDefaultExpr;
import com.alibaba.druid.sql.ast.expr.SQLExistsExpr;
import com.alibaba.druid.sql.ast.expr.SQLGroupingSetExpr;
import com.alibaba.druid.sql.ast.expr.SQLHexExpr;
import com.alibaba.druid.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.druid.sql.ast.expr.SQLInListExpr;
import com.alibaba.druid.sql.ast.expr.SQLInSubQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLIntegerExpr;
import com.alibaba.druid.sql.ast.expr.SQLListExpr;
import com.alibaba.druid.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.druid.sql.ast.expr.SQLNCharExpr;
import com.alibaba.druid.sql.ast.expr.SQLNotExpr;
import com.alibaba.druid.sql.ast.expr.SQLNullExpr;
import com.alibaba.druid.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.druid.sql.ast.expr.SQLQueryExpr;
import com.alibaba.druid.sql.ast.expr.SQLSequenceExpr;
import com.alibaba.druid.sql.ast.expr.SQLSomeExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryExpr;
import com.alibaba.druid.sql.ast.expr.SQLUnaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLVariantRefExpr;
import com.alibaba.druid.sql.ast.statement.SQLAssignItem;
import com.alibaba.druid.sql.ast.statement.SQLCharacterDataType;
import com.alibaba.druid.sql.ast.statement.SQLCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnCheck;
import com.alibaba.druid.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.druid.sql.ast.statement.SQLColumnPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLColumnReference;
import com.alibaba.druid.sql.ast.statement.SQLColumnUniqueKey;
import com.alibaba.druid.sql.ast.statement.SQLConstraint;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyConstraint;
import com.alibaba.druid.sql.ast.statement.SQLForeignKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLNotNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLNullConstraint;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKey;
import com.alibaba.druid.sql.ast.statement.SQLPrimaryKeyImpl;
import com.alibaba.druid.sql.ast.statement.SQLSelect;
import com.alibaba.druid.sql.ast.statement.SQLSelectItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectOrderByItem;
import com.alibaba.druid.sql.ast.statement.SQLSelectQuery;
import com.alibaba.druid.sql.ast.statement.SQLUnique;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.dialect.oracle.ast.expr.OracleArgumentExpr;
import com.alibaba.druid.sql.dialect.postgresql.ast.expr.PGTypeCastExpr;
import com.alibaba.druid.sql.parser.EOFParserException;
import com.alibaba.druid.sql.parser.Lexer;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLParser;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.alibaba.druid.sql.parser.SQLSelectParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.util.FnvHash;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class SQLExprParser
extends SQLParser {
    public static final String[] AGGREGATE_FUNCTIONS;
    public static final long[] AGGREGATE_FUNCTIONS_CODES;
    protected String[] aggregateFunctions = AGGREGATE_FUNCTIONS;
    protected long[] aggregateFunctionHashCodes = AGGREGATE_FUNCTIONS_CODES;

    public SQLExprParser(String sql) {
        super(sql);
    }

    public SQLExprParser(String sql, String dbType) {
        super(sql, dbType);
    }

    public SQLExprParser(Lexer lexer) {
        super(lexer);
    }

    public SQLExprParser(Lexer lexer, String dbType) {
        super(lexer, dbType);
    }

    public SQLExpr expr() {
        if (this.lexer.token == Token.STAR) {
            this.lexer.nextToken();
            SQLAllColumnExpr expr = new SQLAllColumnExpr();
            if (this.lexer.token == Token.DOT) {
                this.lexer.nextToken();
                this.accept(Token.STAR);
                return new SQLPropertyExpr(expr, "*");
            }
            return expr;
        }
        SQLExpr expr = this.primary();
        Token token = this.lexer.token;
        if (token == Token.COMMA) {
            return expr;
        }
        if (token == Token.EQ) {
            expr = this.equalityRest2(expr);
            expr = this.andRest(expr);
            expr = this.orRest(expr);
            return expr;
        }
        return this.exprRest(expr);
    }

    public SQLExpr exprRest(SQLExpr expr) {
        expr = this.bitXorRest(expr);
        expr = this.multiplicativeRest(expr);
        expr = this.additiveRest(expr);
        expr = this.shiftRest(expr);
        expr = this.bitAndRest(expr);
        expr = this.bitOrRest(expr);
        expr = this.inRest(expr);
        expr = this.relationalRest(expr);
        expr = this.equalityRest(expr);
        expr = this.andRest(expr);
        expr = this.orRest(expr);
        return expr;
    }

    public final SQLExpr bitXor() {
        SQLExpr expr = this.primary();
        return this.bitXorRest(expr);
    }

    public SQLExpr bitXorRest(SQLExpr expr) {
        Token token = this.lexer.token;
        switch (token) {
            case CARET: {
                SQLBinaryOperator op;
                this.lexer.nextToken();
                if (this.lexer.token == Token.EQ) {
                    this.lexer.nextToken();
                    op = SQLBinaryOperator.BitwiseXorEQ;
                } else {
                    op = SQLBinaryOperator.BitwiseXor;
                }
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, op, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
            case SUBGT: {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.SubGt, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
            case LT_SUB_GT: {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.PG_ST_DISTANCE, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
            case SUBGTGT: {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.SubGtGt, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
            case POUNDGT: {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.PoundGt, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
            case POUNDGTGT: {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.PoundGtGt, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
            case QUESQUES: {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.QuesQues, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
            case QUESBAR: {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.QuesBar, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
            case QUESAMP: {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.QuesAmp, rightExp, this.dbType);
                expr = this.bitXorRest(expr);
                break;
            }
        }
        return expr;
    }

    public final SQLExpr multiplicative() {
        SQLExpr expr = this.bitXor();
        return this.multiplicativeRest(expr);
    }

    public SQLExpr multiplicativeRest(SQLExpr expr) {
        Token token = this.lexer.token;
        if (token == Token.STAR) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitXor();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Multiply, rightExp, this.getDbType());
            expr = this.multiplicativeRest(expr);
        } else if (token == Token.SLASH) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitXor();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Divide, rightExp, this.getDbType());
            expr = this.multiplicativeRest(expr);
        } else if (token == Token.PERCENT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitXor();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Modulus, rightExp, this.getDbType());
            expr = this.multiplicativeRest(expr);
        } else if (token == Token.DIV) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitXor();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.DIV, rightExp, this.getDbType());
            expr = this.multiplicativeRest(expr);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.MOD)) {
            Lexer.SavePoint savePoint = this.lexer.mark();
            this.lexer.nextToken();
            if (this.lexer.token == Token.COMMA) {
                this.lexer.reset(savePoint);
                return expr;
            }
            SQLExpr rightExp = this.primary();
            rightExp = this.relationalRest(rightExp);
            return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Modulus, rightExp, "mysql");
        }
        return expr;
    }

    public SQLIntegerExpr integerExpr() {
        SQLIntegerExpr intExpr = new SQLIntegerExpr(this.lexer.integerValue());
        this.accept(Token.LITERAL_INT);
        return intExpr;
    }

    public int parseIntValue() {
        if (this.lexer.token == Token.LITERAL_INT) {
            Number number = this.lexer.integerValue();
            int intVal = (Integer)number;
            this.lexer.nextToken();
            return intVal;
        }
        throw new ParserException("not int. " + this.lexer.info());
    }

    public SQLExpr primary() {
        List<String> beforeComments = null;
        if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
            beforeComments = this.lexer.readAndResetComments();
        }
        SQLExpr sqlExpr = null;
        Token tok = this.lexer.token;
        block0 : switch (tok) {
            case LPAREN: {
                this.lexer.nextToken();
                sqlExpr = this.expr();
                if (this.lexer.token == Token.COMMA) {
                    SQLListExpr listExpr = new SQLListExpr();
                    listExpr.addItem(sqlExpr);
                    do {
                        this.lexer.nextToken();
                        listExpr.addItem(this.expr());
                    } while (this.lexer.token == Token.COMMA);
                    sqlExpr = listExpr;
                }
                if (sqlExpr instanceof SQLBinaryOpExpr) {
                    ((SQLBinaryOpExpr)sqlExpr).setBracket(true);
                }
                this.accept(Token.RPAREN);
                if (this.lexer.token != Token.UNION || !(sqlExpr instanceof SQLQueryExpr)) break;
                SQLQueryExpr queryExpr = (SQLQueryExpr)sqlExpr;
                SQLSelectQuery query = this.createSelectParser().queryRest(queryExpr.getSubQuery().getQuery());
                queryExpr.getSubQuery().setQuery(query);
                break;
            }
            case INSERT: {
                this.lexer.nextToken();
                if (this.lexer.token != Token.LPAREN) {
                    throw new ParserException("syntax error. " + this.lexer.info());
                }
                sqlExpr = new SQLIdentifierExpr("INSERT");
                break;
            }
            case IDENTIFIER: {
                String ident = this.lexer.stringVal();
                long hash_lower = this.lexer.hash_lower;
                this.lexer.nextToken();
                if (hash_lower == FnvHash.Constants.DATE && (this.lexer.token == Token.LITERAL_CHARS || this.lexer.token == Token.VARIANT) && ("oracle".equals(this.dbType) || "postgresql".equals(this.dbType) || "mysql".equals(this.dbType))) {
                    SQLExpr literal = this.primary();
                    SQLDateExpr dateExpr = new SQLDateExpr();
                    dateExpr.setLiteral(literal);
                    sqlExpr = dateExpr;
                    break;
                }
                if ("mysql".equalsIgnoreCase(this.dbType) && ident.startsWith("0x") && ident.length() % 2 == 0) {
                    sqlExpr = new SQLHexExpr(ident.substring(2));
                    break;
                }
                sqlExpr = new SQLIdentifierExpr(ident, hash_lower);
                break;
            }
            case NEW: {
                throw new ParserException("TODO " + this.lexer.info());
            }
            case LITERAL_INT: {
                sqlExpr = new SQLIntegerExpr(this.lexer.integerValue());
                this.lexer.nextToken();
                break;
            }
            case LITERAL_FLOAT: {
                sqlExpr = this.lexer.numberExpr();
                this.lexer.nextToken();
                break;
            }
            case LITERAL_CHARS: {
                sqlExpr = new SQLCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                if (!"mysql".equals(this.dbType)) break;
                SQLMethodInvokeExpr concat = null;
                while (true) {
                    SQLCharExpr concat_right;
                    if (this.lexer.token == Token.LITERAL_ALIAS) {
                        if (concat == null) {
                            concat = new SQLMethodInvokeExpr("CONCAT");
                            concat.addParameter(sqlExpr);
                            sqlExpr = concat;
                        }
                        String alias = this.lexer.stringVal();
                        this.lexer.nextToken();
                        concat_right = new SQLCharExpr(alias.substring(1, alias.length() - 1));
                        concat.addParameter(concat_right);
                        continue;
                    }
                    if (this.lexer.token != Token.LITERAL_CHARS && this.lexer.token != Token.LITERAL_NCHARS) break block0;
                    if (concat == null) {
                        concat = new SQLMethodInvokeExpr("CONCAT");
                        concat.addParameter(sqlExpr);
                        sqlExpr = concat;
                    }
                    String chars = this.lexer.stringVal();
                    this.lexer.nextToken();
                    concat_right = new SQLCharExpr(chars);
                    concat.addParameter(concat_right);
                }
            }
            case LITERAL_NCHARS: {
                sqlExpr = new SQLNCharExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                if (!"mysql".equals(this.dbType)) break;
                SQLMethodInvokeExpr concat = null;
                while (true) {
                    SQLCharExpr concat_right;
                    if (this.lexer.token == Token.LITERAL_ALIAS) {
                        if (concat == null) {
                            concat = new SQLMethodInvokeExpr("CONCAT");
                            concat.addParameter(sqlExpr);
                            sqlExpr = concat;
                        }
                        String alias = this.lexer.stringVal();
                        this.lexer.nextToken();
                        concat_right = new SQLCharExpr(alias.substring(1, alias.length() - 1));
                        concat.addParameter(concat_right);
                        continue;
                    }
                    if (this.lexer.token != Token.LITERAL_CHARS && this.lexer.token != Token.LITERAL_NCHARS) break block0;
                    if (concat == null) {
                        concat = new SQLMethodInvokeExpr("CONCAT");
                        concat.addParameter(sqlExpr);
                        sqlExpr = concat;
                    }
                    String chars = this.lexer.stringVal();
                    this.lexer.nextToken();
                    concat_right = new SQLCharExpr(chars);
                    concat.addParameter(concat_right);
                }
            }
            case VARIANT: {
                String varName = this.lexer.stringVal();
                this.lexer.nextToken();
                if (varName.equals(":") && this.lexer.token == Token.IDENTIFIER && "oracle".equals(this.dbType)) {
                    String part2 = this.lexer.stringVal();
                    this.lexer.nextToken();
                    varName = varName + part2;
                }
                SQLVariantRefExpr varRefExpr = new SQLVariantRefExpr(varName);
                if (varName.startsWith(":")) {
                    varRefExpr.setIndex(this.lexer.nextVarIndex());
                }
                if (varRefExpr.getName().equals("@") && this.lexer.token == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                } else if (varRefExpr.getName().equals("@@") && this.lexer.token == Token.LITERAL_CHARS) {
                    varRefExpr.setName("@@'" + this.lexer.stringVal() + "'");
                    this.lexer.nextToken();
                }
                sqlExpr = varRefExpr;
                break;
            }
            case DEFAULT: {
                sqlExpr = new SQLDefaultExpr();
                this.lexer.nextToken();
                break;
            }
            case DUAL: 
            case KEY: 
            case DISTINCT: 
            case LIMIT: 
            case SCHEMA: 
            case COLUMN: 
            case IF: 
            case END: 
            case COMMENT: 
            case COMPUTE: 
            case ENABLE: 
            case DISABLE: 
            case INITIALLY: 
            case SEQUENCE: 
            case USER: 
            case EXPLAIN: 
            case WITH: 
            case GRANT: 
            case REPLACE: 
            case INDEX: 
            case MODEL: 
            case PCTFREE: 
            case INITRANS: 
            case MAXTRANS: 
            case SEGMENT: 
            case CREATION: 
            case IMMEDIATE: 
            case DEFERRED: 
            case STORAGE: 
            case NEXT: 
            case MINEXTENTS: 
            case MAXEXTENTS: 
            case MAXSIZE: 
            case PCTINCREASE: 
            case FLASH_CACHE: 
            case CELL_FLASH_CACHE: 
            case NONE: 
            case LOB: 
            case STORE: 
            case ROW: 
            case CHUNK: 
            case CACHE: 
            case NOCACHE: 
            case LOGGING: 
            case NOCOMPRESS: 
            case KEEP_DUPLICATES: 
            case EXCEPTIONS: 
            case PURGE: 
            case FULL: 
            case TO: 
            case IDENTIFIED: 
            case PASSWORD: 
            case BINARY: 
            case WINDOW: 
            case OFFSET: 
            case SHARE: 
            case START: 
            case CONNECT: 
            case MATCHED: 
            case ERRORS: 
            case REJECT: 
            case UNLIMITED: 
            case BEGIN: 
            case EXCLUSIVE: 
            case MODE: 
            case ADVISE: 
            case VIEW: 
            case ESCAPE: 
            case OVER: 
            case ORDER: 
            case CONSTRAINT: 
            case TYPE: 
            case OPEN: 
            case REPEAT: 
            case TABLE: 
            case TRUNCATE: 
            case EXCEPTION: 
            case FUNCTION: 
            case IDENTITY: 
            case EXTRACT: 
            case DESC: 
            case DO: 
            case GROUP: 
            case MOD: 
            case CONCAT: {
                sqlExpr = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                break;
            }
            case CASE: {
                SQLCaseExpr caseExpr = new SQLCaseExpr();
                this.lexer.nextToken();
                if (this.lexer.token != Token.WHEN) {
                    caseExpr.setValueExpr(this.expr());
                }
                this.accept(Token.WHEN);
                SQLExpr testExpr = this.expr();
                this.accept(Token.THEN);
                SQLExpr valueExpr = this.expr();
                SQLCaseExpr.Item caseItem = new SQLCaseExpr.Item(testExpr, valueExpr);
                caseExpr.addItem(caseItem);
                while (this.lexer.token == Token.WHEN) {
                    this.lexer.nextToken();
                    testExpr = this.expr();
                    this.accept(Token.THEN);
                    valueExpr = this.expr();
                    caseItem = new SQLCaseExpr.Item(testExpr, valueExpr);
                    caseExpr.addItem(caseItem);
                }
                if (this.lexer.token == Token.ELSE) {
                    this.lexer.nextToken();
                    caseExpr.setElseExpr(this.expr());
                }
                this.accept(Token.END);
                sqlExpr = caseExpr;
                break;
            }
            case EXISTS: {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                sqlExpr = new SQLExistsExpr(this.createSelectParser().select());
                this.accept(Token.RPAREN);
                break;
            }
            case NOT: {
                this.lexer.nextToken();
                if (this.lexer.token == Token.EXISTS) {
                    this.lexer.nextToken();
                    this.accept(Token.LPAREN);
                    sqlExpr = new SQLExistsExpr(this.createSelectParser().select(), true);
                    this.accept(Token.RPAREN);
                    break;
                }
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLExpr notTarget = this.expr();
                    this.accept(Token.RPAREN);
                    notTarget = this.relationalRest(notTarget);
                    sqlExpr = new SQLNotExpr(notTarget);
                    return this.primaryRest(sqlExpr);
                }
                SQLExpr restExpr = this.relational();
                sqlExpr = new SQLNotExpr(restExpr);
                break;
            }
            case SELECT: {
                SQLQueryExpr queryExpr = new SQLQueryExpr(this.createSelectParser().select());
                sqlExpr = queryExpr;
                break;
            }
            case CAST: {
                this.lexer.nextToken();
                this.accept(Token.LPAREN);
                SQLCastExpr cast = new SQLCastExpr();
                cast.setExpr(this.expr());
                this.accept(Token.AS);
                cast.setDataType(this.parseDataType(false));
                this.accept(Token.RPAREN);
                sqlExpr = cast;
                break;
            }
            case SUB: {
                this.lexer.nextToken();
                switch (this.lexer.token) {
                    case LITERAL_INT: {
                        long longVal;
                        int intVal;
                        Number integerValue = this.lexer.integerValue();
                        integerValue = integerValue instanceof Integer ? (Number)((intVal = ((Integer)integerValue).intValue()) == Integer.MIN_VALUE ? (Number)((long)intVal * -1L) : (Number)(intVal * -1)) : (Number)(integerValue instanceof Long ? ((longVal = ((Long)integerValue).longValue()) == 0x80000000L ? (Number)((int)(longVal * -1L)) : (Number)(longVal * -1L)) : ((BigInteger)integerValue).negate());
                        sqlExpr = new SQLIntegerExpr(integerValue);
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LITERAL_FLOAT: {
                        sqlExpr = this.lexer.numberExpr(true);
                        this.lexer.nextToken();
                        break block0;
                    }
                    case IDENTIFIER: {
                        sqlExpr = new SQLIdentifierExpr(this.lexer.stringVal());
                        this.lexer.nextToken();
                        if (this.lexer.token == Token.LPAREN || this.lexer.token == Token.LBRACKET) {
                            sqlExpr = this.primaryRest(sqlExpr);
                        }
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Negative, sqlExpr);
                        break block0;
                    }
                    case QUES: {
                        SQLVariantRefExpr variantRefExpr = new SQLVariantRefExpr("?");
                        variantRefExpr.setIndex(this.lexer.nextVarIndex());
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Negative, variantRefExpr);
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LPAREN: {
                        this.lexer.nextToken();
                        sqlExpr = this.expr();
                        this.accept(Token.RPAREN);
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Negative, sqlExpr);
                        break block0;
                    }
                    case BANG: {
                        sqlExpr = this.expr();
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Negative, sqlExpr);
                        break block0;
                    }
                }
                throw new ParserException("TODO : " + this.lexer.info());
            }
            case PLUS: {
                this.lexer.nextToken();
                switch (this.lexer.token) {
                    case LITERAL_INT: {
                        sqlExpr = new SQLIntegerExpr(this.lexer.integerValue());
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LITERAL_FLOAT: {
                        sqlExpr = this.lexer.numberExpr();
                        this.lexer.nextToken();
                        break block0;
                    }
                    case IDENTIFIER: {
                        sqlExpr = new SQLIdentifierExpr(this.lexer.stringVal());
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Plus, sqlExpr);
                        this.lexer.nextToken();
                        break block0;
                    }
                    case LPAREN: {
                        this.lexer.nextToken();
                        sqlExpr = this.expr();
                        this.accept(Token.RPAREN);
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Plus, sqlExpr);
                        break block0;
                    }
                    case SUB: {
                        sqlExpr = this.expr();
                        sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Plus, sqlExpr);
                        break block0;
                    }
                }
                throw new ParserException("TODO " + this.lexer.info());
            }
            case TILDE: {
                this.lexer.nextToken();
                SQLExpr unaryValueExpr = this.primary();
                SQLUnaryExpr unary = new SQLUnaryExpr(SQLUnaryOperator.Compl, unaryValueExpr);
                sqlExpr = unary;
                break;
            }
            case QUES: {
                this.lexer.nextToken();
                SQLVariantRefExpr quesVarRefExpr = new SQLVariantRefExpr("?");
                quesVarRefExpr.setIndex(this.lexer.nextVarIndex());
                sqlExpr = quesVarRefExpr;
                break;
            }
            case LEFT: {
                sqlExpr = new SQLIdentifierExpr("LEFT");
                this.lexer.nextToken();
                break;
            }
            case RIGHT: {
                sqlExpr = new SQLIdentifierExpr("RIGHT");
                this.lexer.nextToken();
                break;
            }
            case DATABASE: {
                sqlExpr = new SQLIdentifierExpr("DATABASE");
                this.lexer.nextToken();
                break;
            }
            case LOCK: {
                sqlExpr = new SQLIdentifierExpr("LOCK");
                this.lexer.nextToken();
                break;
            }
            case NULL: {
                sqlExpr = new SQLNullExpr();
                this.lexer.nextToken();
                break;
            }
            case BANG: {
                this.lexer.nextToken();
                SQLExpr bangExpr = this.primary();
                sqlExpr = new SQLUnaryExpr(SQLUnaryOperator.Not, bangExpr);
                break;
            }
            case LITERAL_HEX: {
                String hex = this.lexer.hexString();
                sqlExpr = new SQLHexExpr(hex);
                this.lexer.nextToken();
                break;
            }
            case INTERVAL: {
                sqlExpr = this.parseInterval();
                break;
            }
            case COLON: {
                this.lexer.nextToken();
                if (this.lexer.token != Token.LITERAL_ALIAS) break;
                sqlExpr = new SQLVariantRefExpr(":\"" + this.lexer.stringVal() + "\"");
                this.lexer.nextToken();
                break;
            }
            case ANY: {
                sqlExpr = this.parseAny();
                break;
            }
            case SOME: {
                sqlExpr = this.parseSome();
                break;
            }
            case ALL: {
                sqlExpr = this.parseAll();
                break;
            }
            case LITERAL_ALIAS: {
                sqlExpr = this.parseAliasExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                break;
            }
            case EOF: {
                throw new EOFParserException();
            }
            case TRUE: {
                this.lexer.nextToken();
                sqlExpr = new SQLBooleanExpr(true);
                break;
            }
            case FALSE: {
                this.lexer.nextToken();
                sqlExpr = new SQLBooleanExpr(false);
                break;
            }
            case BITS: {
                String strVal = this.lexer.stringVal();
                this.lexer.nextToken();
                sqlExpr = new SQLBinaryExpr(strVal);
                break;
            }
            case SET: {
                Lexer.SavePoint savePoint = this.lexer.mark();
                this.lexer.nextToken();
                if (this.lexer.token() == Token.LPAREN) {
                    sqlExpr = new SQLIdentifierExpr("SET");
                    break;
                }
                this.lexer.reset(savePoint);
                throw new ParserException("ERROR. " + this.lexer.info());
            }
            default: {
                throw new ParserException("ERROR. " + this.lexer.info());
            }
        }
        SQLExpr expr = this.primaryRest(sqlExpr);
        if (beforeComments != null) {
            expr.addBeforeComment(beforeComments);
        }
        return expr;
    }

    protected SQLExpr parseAll() {
        this.lexer.nextToken();
        SQLAllExpr allExpr = new SQLAllExpr();
        this.accept(Token.LPAREN);
        SQLSelect allSubQuery = this.createSelectParser().select();
        allExpr.setSubQuery(allSubQuery);
        this.accept(Token.RPAREN);
        allSubQuery.setParent(allExpr);
        SQLAllExpr sqlExpr = allExpr;
        return sqlExpr;
    }

    protected SQLExpr parseSome() {
        this.lexer.nextToken();
        SQLSomeExpr someExpr = new SQLSomeExpr();
        this.accept(Token.LPAREN);
        SQLSelect someSubQuery = this.createSelectParser().select();
        someExpr.setSubQuery(someSubQuery);
        this.accept(Token.RPAREN);
        someSubQuery.setParent(someExpr);
        SQLSomeExpr sqlExpr = someExpr;
        return sqlExpr;
    }

    protected SQLExpr parseAny() {
        SQLExprImpl sqlExpr;
        this.lexer.nextToken();
        if (this.lexer.token == Token.LPAREN) {
            this.accept(Token.LPAREN);
            if (this.lexer.token == Token.ARRAY || this.lexer.token == Token.IDENTIFIER) {
                SQLExpr expr = this.expr();
                SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr("ANY");
                methodInvokeExpr.addParameter(expr);
                this.accept(Token.RPAREN);
                return methodInvokeExpr;
            }
            SQLSelect anySubQuery = this.createSelectParser().select();
            SQLAnyExpr anyExpr = new SQLAnyExpr(anySubQuery);
            this.accept(Token.RPAREN);
            sqlExpr = anyExpr;
        } else {
            sqlExpr = new SQLIdentifierExpr("ANY");
        }
        return sqlExpr;
    }

    protected SQLExpr parseAliasExpr(String alias) {
        return new SQLIdentifierExpr(alias);
    }

    protected SQLExpr parseInterval() {
        throw new ParserException("TODO. " + this.lexer.info());
    }

    public SQLSelectParser createSelectParser() {
        return new SQLSelectParser(this);
    }

    public SQLExpr primaryRest(SQLExpr expr) {
        if (expr == null) {
            throw new IllegalArgumentException("expr");
        }
        Token token = this.lexer.token;
        if (token == Token.OF) {
            long hashCode64;
            if (expr instanceof SQLIdentifierExpr && (hashCode64 = ((SQLIdentifierExpr)expr).hashCode64()) == FnvHash.Constants.CURRENT) {
                this.lexer.nextToken();
                SQLName cursorName = this.name();
                return new SQLCurrentOfCursorExpr(cursorName);
            }
        } else if (token == Token.FOR && expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr idenExpr = (SQLIdentifierExpr)expr;
            if (idenExpr.hashCode64() == FnvHash.Constants.NEXTVAL) {
                this.lexer.nextToken();
                SQLName seqName = this.name();
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(seqName, SQLSequenceExpr.Function.NextVal);
                return seqExpr;
            }
            if (idenExpr.hashCode64() == FnvHash.Constants.CURRVAL) {
                this.lexer.nextToken();
                SQLName seqName = this.name();
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(seqName, SQLSequenceExpr.Function.CurrVal);
                return seqExpr;
            }
            if (idenExpr.hashCode64() == FnvHash.Constants.PREVVAL) {
                this.lexer.nextToken();
                SQLName seqName = this.name();
                SQLSequenceExpr seqExpr = new SQLSequenceExpr(seqName, SQLSequenceExpr.Function.PrevVal);
                return seqExpr;
            }
        }
        if (token == Token.DOT) {
            this.lexer.nextToken();
            if (expr instanceof SQLCharExpr) {
                String text = ((SQLCharExpr)expr).getText();
                expr = new SQLIdentifierExpr(text);
            }
            expr = this.dotRest(expr);
            return this.primaryRest(expr);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.SETS) && expr.getClass() == SQLIdentifierExpr.class && "GROUPING".equalsIgnoreCase(((SQLIdentifierExpr)expr).getName())) {
            SQLGroupingSetExpr groupingSets = new SQLGroupingSetExpr();
            this.lexer.nextToken();
            this.accept(Token.LPAREN);
            while (true) {
                SQLExpr item;
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    SQLListExpr listExpr = new SQLListExpr();
                    this.exprList(listExpr.getItems(), listExpr);
                    item = listExpr;
                    this.accept(Token.RPAREN);
                } else {
                    item = this.expr();
                }
                item.setParent(groupingSets);
                groupingSets.addParameter(item);
                if (this.lexer.token == Token.RPAREN) break;
                this.accept(Token.COMMA);
            }
            this.exprList(groupingSets.getParameters(), groupingSets);
            this.accept(Token.RPAREN);
            return groupingSets;
        }
        if (this.lexer.token == Token.LPAREN) {
            return this.methodRest(expr, true);
        }
        return expr;
    }

    protected SQLExpr parseExtract() {
        throw new ParserException("not supported.");
    }

    protected SQLExpr parsePosition() {
        throw new ParserException("not supported.");
    }

    protected SQLExpr parseMatch() {
        throw new ParserException("not supported.");
    }

    protected SQLExpr methodRest(SQLExpr expr, boolean acceptLPAREN) {
        Token token;
        if (acceptLPAREN) {
            this.accept(Token.LPAREN);
        }
        boolean distinct = false;
        if (this.lexer.token == Token.DISTINCT) {
            this.lexer.nextToken();
            distinct = true;
        }
        String methodName = null;
        String aggMethodName = null;
        SQLExpr owner = null;
        String trimOption = null;
        long hash_lower = 0L;
        if (expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identifierExpr = (SQLIdentifierExpr)expr;
            methodName = identifierExpr.getName();
            hash_lower = identifierExpr.nameHashCode64();
            if (hash_lower == FnvHash.Constants.TRIM) {
                if (this.lexer.identifierEquals(FnvHash.Constants.LEADING)) {
                    trimOption = this.lexer.stringVal();
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals(FnvHash.Constants.BOTH)) {
                    trimOption = this.lexer.stringVal();
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals(FnvHash.Constants.TRAILING)) {
                    trimOption = this.lexer.stringVal();
                    this.lexer.nextToken();
                }
            } else {
                if (hash_lower == FnvHash.Constants.MATCH && "mysql".equals(this.dbType)) {
                    return this.parseMatch();
                }
                if (hash_lower == FnvHash.Constants.EXTRACT && "mysql".equals(this.dbType)) {
                    return this.parseExtract();
                }
                if (hash_lower == FnvHash.Constants.POSITION && "mysql".equals(this.dbType)) {
                    return this.parsePosition();
                }
                if (hash_lower == FnvHash.Constants.INT4 && "postgresql".equals(this.dbType)) {
                    PGTypeCastExpr castExpr = new PGTypeCastExpr();
                    castExpr.setExpr(this.expr());
                    castExpr.setDataType(new SQLDataTypeImpl(methodName));
                    this.accept(Token.RPAREN);
                    return castExpr;
                }
                if (hash_lower == FnvHash.Constants.VARBIT && "postgresql".equals(this.dbType)) {
                    PGTypeCastExpr castExpr = new PGTypeCastExpr();
                    SQLExpr len = this.primary();
                    castExpr.setDataType(new SQLDataTypeImpl(methodName, len));
                    this.accept(Token.RPAREN);
                    castExpr.setExpr(this.expr());
                    return castExpr;
                }
            }
            aggMethodName = this.getAggreateFunction(hash_lower);
        } else if (expr instanceof SQLPropertyExpr) {
            methodName = expr.toString();
            aggMethodName = SQLUtils.normalize(methodName);
            hash_lower = FnvHash.fnv1a_64_lower(aggMethodName);
            aggMethodName = this.getAggreateFunction(hash_lower);
            owner = ((SQLPropertyExpr)expr).getOwner();
        } else if (expr instanceof SQLDefaultExpr) {
            methodName = "DEFAULT";
        } else if (expr instanceof SQLCharExpr) {
            methodName = ((SQLCharExpr)expr).getText();
        }
        if (aggMethodName != null) {
            SQLAggregateExpr aggregateExpr = this.parseAggregateExpr(aggMethodName);
            if (distinct) {
                aggregateExpr.setOption(SQLAggregateOption.DISTINCT);
            }
            return aggregateExpr;
        }
        SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(methodName, hash_lower);
        if (owner != null) {
            methodInvokeExpr.setOwner(owner);
        }
        if (trimOption != null) {
            methodInvokeExpr.setTrimOption(trimOption);
        }
        if ((token = this.lexer.token) != Token.RPAREN && token != Token.FROM) {
            this.exprList(methodInvokeExpr.getParameters(), methodInvokeExpr);
        }
        if (this.lexer.token == Token.FROM) {
            this.lexer.nextToken();
            SQLExpr from = this.expr();
            methodInvokeExpr.setFrom(from);
            if (this.lexer.token == Token.FOR) {
                this.lexer.nextToken();
                SQLExpr forExpr = this.expr();
                methodInvokeExpr.setFor(forExpr);
            }
        }
        if (this.lexer.token == Token.USING || this.lexer.identifierEquals(FnvHash.Constants.USING)) {
            SQLExpr using;
            this.lexer.nextToken();
            if (this.lexer.token == Token.STAR) {
                this.lexer.nextToken();
                using = new SQLAllColumnExpr();
            } else if (this.lexer.token == Token.BINARY) {
                using = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
            } else {
                using = this.primary();
            }
            methodInvokeExpr.setUsing(using);
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token == Token.OVER) {
            SQLAggregateExpr aggregateExpr = new SQLAggregateExpr(methodName);
            aggregateExpr.getArguments().addAll(methodInvokeExpr.getParameters());
            this.over(aggregateExpr);
            return this.primaryRest(aggregateExpr);
        }
        return this.primaryRest(methodInvokeExpr);
    }

    protected SQLExpr dotRest(SQLExpr expr) {
        if (this.lexer.token == Token.STAR) {
            this.lexer.nextToken();
            expr = new SQLPropertyExpr(expr, "*");
        } else {
            String name;
            long hash_lower = 0L;
            if (this.lexer.token == Token.IDENTIFIER) {
                name = this.lexer.stringVal();
                hash_lower = this.lexer.hash_lower;
                this.lexer.nextToken();
            } else if (this.lexer.token == Token.LITERAL_CHARS || this.lexer.token == Token.LITERAL_ALIAS) {
                name = this.lexer.stringVal();
                this.lexer.nextToken();
            } else if (this.lexer.getKeywods().containsValue(this.lexer.token)) {
                name = this.lexer.stringVal();
                this.lexer.nextToken();
            } else {
                throw new ParserException("error : " + this.lexer.info());
            }
            if (this.lexer.token == Token.LPAREN) {
                boolean aggregate = hash_lower == FnvHash.Constants.WM_CONCAT && expr instanceof SQLIdentifierExpr && ((SQLIdentifierExpr)expr).nameHashCode64() == FnvHash.Constants.WMSYS;
                expr = this.methodRest(expr, name, aggregate);
            } else {
                expr = new SQLPropertyExpr(expr, name, hash_lower);
            }
        }
        expr = this.primaryRest(expr);
        return expr;
    }

    private SQLExpr methodRest(SQLExpr expr, String name, boolean aggregate) {
        this.lexer.nextToken();
        if (this.lexer.token == Token.DISTINCT) {
            this.lexer.nextToken();
            String aggreateMethodName = expr.toString() + "." + name;
            SQLAggregateExpr aggregateExpr = new SQLAggregateExpr(aggreateMethodName, SQLAggregateOption.DISTINCT);
            if (this.lexer.token == Token.RPAREN) {
                this.lexer.nextToken();
            } else {
                if (this.lexer.token == Token.PLUS) {
                    aggregateExpr.getArguments().add(new SQLIdentifierExpr("+"));
                    this.lexer.nextToken();
                } else {
                    this.exprList(aggregateExpr.getArguments(), aggregateExpr);
                }
                this.accept(Token.RPAREN);
            }
            expr = aggregateExpr;
        } else if (aggregate) {
            SQLAggregateExpr methodInvokeExpr = new SQLAggregateExpr(name);
            methodInvokeExpr.setMethodName(expr.toString() + "." + name);
            if (this.lexer.token == Token.RPAREN) {
                this.lexer.nextToken();
            } else {
                if (this.lexer.token == Token.PLUS) {
                    methodInvokeExpr.addArgument(new SQLIdentifierExpr("+"));
                    this.lexer.nextToken();
                } else {
                    this.exprList(methodInvokeExpr.getArguments(), methodInvokeExpr);
                }
                this.accept(Token.RPAREN);
            }
            expr = methodInvokeExpr;
        } else {
            SQLMethodInvokeExpr methodInvokeExpr = new SQLMethodInvokeExpr(name);
            methodInvokeExpr.setOwner(expr);
            if (this.lexer.token == Token.RPAREN) {
                this.lexer.nextToken();
            } else {
                if (this.lexer.token == Token.PLUS) {
                    methodInvokeExpr.addParameter(new SQLIdentifierExpr("+"));
                    this.lexer.nextToken();
                } else {
                    this.exprList(methodInvokeExpr.getParameters(), methodInvokeExpr);
                }
                this.accept(Token.RPAREN);
            }
            expr = methodInvokeExpr;
        }
        return expr;
    }

    public final SQLExpr groupComparisionRest(SQLExpr expr) {
        return expr;
    }

    public final void names(Collection<SQLName> exprCol) {
        this.names(exprCol, null);
    }

    public final void names(Collection<SQLName> exprCol, SQLObject parent) {
        if (this.lexer.token == Token.RBRACE) {
            return;
        }
        if (this.lexer.token == Token.EOF) {
            return;
        }
        SQLName name = this.name();
        name.setParent(parent);
        exprCol.add(name);
        while (this.lexer.token == Token.COMMA) {
            this.lexer.nextToken();
            name = this.name();
            name.setParent(parent);
            exprCol.add(name);
        }
    }

    @Deprecated
    public final void exprList(Collection<SQLExpr> exprCol) {
        this.exprList(exprCol, null);
    }

    public final void exprList(Collection<SQLExpr> exprCol, SQLObject parent) {
        if (this.lexer.token == Token.RPAREN || this.lexer.token == Token.RBRACKET) {
            return;
        }
        if (this.lexer.token == Token.EOF) {
            return;
        }
        SQLExpr expr = this.expr();
        expr.setParent(parent);
        exprCol.add(expr);
        while (this.lexer.token == Token.COMMA) {
            this.lexer.nextToken();
            expr = this.expr();
            expr.setParent(parent);
            exprCol.add(expr);
        }
    }

    public SQLName name() {
        String identName;
        long hash = 0L;
        if (this.lexer.token == Token.LITERAL_ALIAS) {
            identName = this.lexer.stringVal();
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.IDENTIFIER) {
            identName = this.lexer.stringVal();
            char c0 = identName.charAt(0);
            if (c0 != '[') {
                hash = this.lexer.hash_lower();
            }
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.LITERAL_CHARS) {
            identName = '\'' + this.lexer.stringVal() + '\'';
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.VARIANT) {
            identName = this.lexer.stringVal();
            this.lexer.nextToken();
        } else {
            switch (this.lexer.token) {
                case KEY: 
                case SCHEMA: 
                case END: 
                case COMMENT: 
                case ENABLE: 
                case DISABLE: 
                case INITIALLY: 
                case SEQUENCE: 
                case USER: 
                case EXPLAIN: 
                case GRANT: 
                case MODEL: 
                case PCTFREE: 
                case INITRANS: 
                case MAXTRANS: 
                case SEGMENT: 
                case CREATION: 
                case IMMEDIATE: 
                case DEFERRED: 
                case STORAGE: 
                case NEXT: 
                case MINEXTENTS: 
                case MAXEXTENTS: 
                case MAXSIZE: 
                case PCTINCREASE: 
                case FLASH_CACHE: 
                case CELL_FLASH_CACHE: 
                case NONE: 
                case LOB: 
                case STORE: 
                case ROW: 
                case CHUNK: 
                case CACHE: 
                case NOCACHE: 
                case LOGGING: 
                case NOCOMPRESS: 
                case KEEP_DUPLICATES: 
                case EXCEPTIONS: 
                case PURGE: 
                case BINARY: 
                case OVER: 
                case ORDER: 
                case TYPE: 
                case FUNCTION: 
                case DO: 
                case INTERVAL: 
                case ANALYZE: 
                case OPTIMIZE: 
                case REVOKE: 
                case JOIN: {
                    identName = this.lexer.stringVal();
                    this.lexer.nextToken();
                    break;
                }
                default: {
                    throw new ParserException("error " + this.lexer.info());
                }
            }
        }
        SQLName name = new SQLIdentifierExpr(identName, hash);
        name = this.nameRest(name);
        return name;
    }

    public SQLName nameRest(SQLName name) {
        if (this.lexer.token == Token.DOT) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.KEY) {
                name = new SQLPropertyExpr(name, "KEY");
                this.lexer.nextToken();
                return name;
            }
            if (this.lexer.token != Token.LITERAL_ALIAS && this.lexer.token != Token.IDENTIFIER && !this.lexer.getKeywods().containsValue(this.lexer.token)) {
                throw new ParserException("error, " + this.lexer.info());
            }
            name = this.lexer.token == Token.LITERAL_ALIAS ? new SQLPropertyExpr(name, this.lexer.stringVal()) : new SQLPropertyExpr(name, this.lexer.stringVal());
            this.lexer.nextToken();
            name = this.nameRest(name);
        }
        return name;
    }

    public boolean isAggreateFunction(String word) {
        long hash_lower = FnvHash.fnv1a_64_lower(word);
        return this.isAggreateFunction(hash_lower);
    }

    protected boolean isAggreateFunction(long hash_lower) {
        return Arrays.binarySearch(this.aggregateFunctionHashCodes, hash_lower) >= 0;
    }

    protected String getAggreateFunction(long hash_lower) {
        int index = Arrays.binarySearch(this.aggregateFunctionHashCodes, hash_lower);
        if (index < 0) {
            return null;
        }
        return this.aggregateFunctions[index];
    }

    protected SQLAggregateExpr parseAggregateExpr(String methodName) {
        SQLAggregateExpr aggregateExpr;
        if (this.lexer.token == Token.ALL) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.ALL);
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.DISTINCT) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.DISTINCT);
            this.lexer.nextToken();
        } else if (this.lexer.identifierEquals(FnvHash.Constants.DEDUPLICATION)) {
            aggregateExpr = new SQLAggregateExpr(methodName, SQLAggregateOption.DEDUPLICATION);
            this.lexer.nextToken();
        } else {
            aggregateExpr = new SQLAggregateExpr(methodName);
        }
        this.exprList(aggregateExpr.getArguments(), aggregateExpr);
        if (this.lexer.token != Token.RPAREN) {
            this.parseAggregateExprRest(aggregateExpr);
        }
        this.accept(Token.RPAREN);
        if (this.lexer.token == Token.OVER) {
            this.over(aggregateExpr);
        }
        return aggregateExpr;
    }

    protected void over(SQLAggregateExpr aggregateExpr) {
        this.lexer.nextToken();
        SQLOver over = new SQLOver();
        this.accept(Token.LPAREN);
        if (this.lexer.token == Token.PARTITION || this.lexer.identifierEquals("PARTITION")) {
            this.lexer.nextToken();
            this.accept(Token.BY);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                this.exprList(over.getPartitionBy(), over);
                this.accept(Token.RPAREN);
            } else {
                this.exprList(over.getPartitionBy(), over);
            }
        }
        over.setOrderBy(this.parseOrderBy());
        if (this.lexer.token == Token.OF) {
            this.lexer.nextToken();
            SQLName of = this.name();
            over.setOf(of);
        }
        SQLOver.WindowingType windowingType = null;
        if (this.lexer.identifierEquals(FnvHash.Constants.ROWS)) {
            windowingType = SQLOver.WindowingType.ROWS;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RANGE)) {
            windowingType = SQLOver.WindowingType.RANGE;
        }
        if (windowingType != null) {
            over.setWindowingType(windowingType);
            this.lexer.nextToken();
            if (this.lexer.token == Token.BETWEEN) {
                this.lexer.nextToken();
                SQLIntegerExpr rowsBegin = (SQLIntegerExpr)this.primary();
                over.setWindowingBetweenBegin(rowsBegin);
                if (this.lexer.identifierEquals(FnvHash.Constants.PRECEDING)) {
                    over.setWindowingBetweenBeginPreceding(true);
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals(FnvHash.Constants.FOLLOWING)) {
                    over.setWindowingBetweenBeginFollowing(true);
                    this.lexer.nextToken();
                }
                this.accept(Token.AND);
                SQLIntegerExpr betweenEnd = (SQLIntegerExpr)this.primary();
                over.setWindowingBetweenEnd(betweenEnd);
                if (this.lexer.identifierEquals(FnvHash.Constants.PRECEDING)) {
                    over.setWindowingBetweenEndPreceding(true);
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals(FnvHash.Constants.FOLLOWING)) {
                    over.setWindowingBetweenEndFollowing(true);
                    this.lexer.nextToken();
                }
            } else if (this.lexer.identifierEquals(FnvHash.Constants.CURRENT)) {
                this.lexer.nextToken();
                this.acceptIdentifier("ROW");
                over.setWindowing(new SQLIdentifierExpr("CURRENT ROW"));
            } else if (this.lexer.identifierEquals(FnvHash.Constants.UNBOUNDED)) {
                this.lexer.nextToken();
                over.setWindowing(new SQLIdentifierExpr("UNBOUNDED"));
                if (this.lexer.identifierEquals(FnvHash.Constants.PRECEDING)) {
                    over.setWindowingPreceding(true);
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals("FOLLOWING")) {
                    over.setWindowingFollowing(true);
                    this.lexer.nextToken();
                }
            } else {
                SQLIntegerExpr rowsExpr = (SQLIntegerExpr)this.primary();
                over.setWindowing(rowsExpr);
                if (this.lexer.identifierEquals(FnvHash.Constants.PRECEDING)) {
                    over.setWindowingPreceding(true);
                    this.lexer.nextToken();
                } else if (this.lexer.identifierEquals(FnvHash.Constants.FOLLOWING)) {
                    over.setWindowingFollowing(true);
                    this.lexer.nextToken();
                }
            }
        }
        this.accept(Token.RPAREN);
        aggregateExpr.setOver(over);
    }

    protected SQLAggregateExpr parseAggregateExprRest(SQLAggregateExpr aggregateExpr) {
        return aggregateExpr;
    }

    public SQLOrderBy parseOrderBy() {
        if (this.lexer.token == Token.ORDER) {
            SQLOrderBy orderBy = new SQLOrderBy();
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.SIBLINGS)) {
                this.lexer.nextToken();
                orderBy.setSibings(true);
            }
            this.accept(Token.BY);
            this.orderBy(orderBy.getItems(), orderBy);
            return orderBy;
        }
        return null;
    }

    public void orderBy(List<SQLSelectOrderByItem> items, SQLObject parent) {
        SQLSelectOrderByItem item = this.parseSelectOrderByItem();
        item.setParent(parent);
        items.add(item);
        while (this.lexer.token == Token.COMMA) {
            this.lexer.nextToken();
            item = this.parseSelectOrderByItem();
            item.setParent(parent);
            items.add(item);
        }
    }

    public SQLSelectOrderByItem parseSelectOrderByItem() {
        SQLSelectOrderByItem item = new SQLSelectOrderByItem();
        item.setExpr(this.expr());
        if (this.lexer.token == Token.ASC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.ASC);
        } else if (this.lexer.token == Token.DESC) {
            this.lexer.nextToken();
            item.setType(SQLOrderingSpecification.DESC);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.NULLS)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals(FnvHash.Constants.FIRST)) {
                this.lexer.nextToken();
                item.setNullsOrderType(SQLSelectOrderByItem.NullsOrderType.NullsFirst);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.LAST)) {
                this.lexer.nextToken();
                item.setNullsOrderType(SQLSelectOrderByItem.NullsOrderType.NullsLast);
            } else {
                throw new ParserException("TODO " + this.lexer.info());
            }
        }
        return item;
    }

    public SQLUpdateSetItem parseUpdateSetItem() {
        SQLUpdateSetItem item = new SQLUpdateSetItem();
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            SQLListExpr list = new SQLListExpr();
            this.exprList(list.getItems(), list);
            this.accept(Token.RPAREN);
            item.setColumn(list);
        } else {
            long hash;
            String identName;
            Token token = this.lexer.token();
            if (token == Token.IDENTIFIER) {
                identName = this.lexer.stringVal();
                hash = this.lexer.hash_lower();
            } else if (token == Token.LITERAL_CHARS) {
                identName = '\'' + this.lexer.stringVal() + '\'';
                hash = 0L;
            } else {
                identName = this.lexer.stringVal();
                hash = 0L;
            }
            this.lexer.nextTokenEq();
            SQLExprImpl expr = new SQLIdentifierExpr(identName, hash);
            while (this.lexer.token() == Token.DOT) {
                this.lexer.nextToken();
                String propertyName = this.lexer.stringVal();
                this.lexer.nextTokenEq();
                expr = new SQLPropertyExpr(expr, propertyName);
            }
            item.setColumn(expr);
        }
        if (this.lexer.token == Token.COLONEQ) {
            this.lexer.nextTokenValue();
        } else if (this.lexer.token == Token.EQ) {
            this.lexer.nextTokenValue();
        } else {
            throw new ParserException("syntax error, expect EQ, actual " + (Object)((Object)this.lexer.token) + " " + this.lexer.info());
        }
        item.setValue(this.expr());
        return item;
    }

    public final SQLExpr bitAnd() {
        SQLExpr expr = this.shift();
        return this.bitAndRest(expr);
    }

    public final SQLExpr bitAndRest(SQLExpr expr) {
        while (this.lexer.token == Token.AMP) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.shift();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BitwiseAnd, rightExp, this.getDbType());
        }
        return expr;
    }

    public final SQLExpr bitOr() {
        SQLExpr expr = this.bitAnd();
        return this.bitOrRest(expr);
    }

    public final SQLExpr bitOrRest(SQLExpr expr) {
        while (this.lexer.token == Token.BAR) {
            this.lexer.nextToken();
            SQLBinaryOperator op = SQLBinaryOperator.BitwiseOr;
            if (this.lexer.token == Token.BAR) {
                this.lexer.nextToken();
                op = SQLBinaryOperator.Concat;
            }
            SQLExpr rightExp = this.bitAnd();
            expr = new SQLBinaryOpExpr(expr, op, rightExp, this.getDbType());
            expr = this.bitAndRest(expr);
        }
        return expr;
    }

    public final SQLExpr equality() {
        SQLExpr expr = this.bitOr();
        return this.equalityRest(expr);
    }

    private SQLExpr equalityRest2(SQLExpr expr) {
        SQLExpr rightExp;
        this.lexer.nextToken();
        try {
            if (this.lexer.token == Token.LITERAL_INT) {
                rightExp = new SQLIntegerExpr(this.lexer.integerValue());
                this.lexer.nextToken();
                if (this.lexer.token == Token.AND || this.lexer.token == Token.RPAREN || this.lexer.token == Token.EOF || this.lexer.token == Token.OR) {
                    return new SQLBinaryOpExpr(expr, SQLBinaryOperator.Equality, rightExp, this.dbType);
                }
                rightExp = this.primaryRest(rightExp);
                rightExp = this.bitXorRest(rightExp);
                rightExp = this.multiplicativeRest(rightExp);
                rightExp = this.additiveRest(rightExp);
                rightExp = this.shiftRest(rightExp);
                rightExp = this.bitAndRest(rightExp);
                rightExp = this.bitOrRest(rightExp);
                rightExp = this.inRest(rightExp);
                rightExp = this.relationalRest(rightExp);
            } else {
                rightExp = this.bitOr();
            }
        }
        catch (EOFParserException e) {
            throw new ParserException("EOF, " + expr + "=", e);
        }
        if (this.lexer.token == Token.COLONEQ) {
            this.lexer.nextToken();
            SQLExpr colonExpr = this.expr();
            rightExp = new SQLBinaryOpExpr(rightExp, SQLBinaryOperator.Assignment, colonExpr, this.dbType);
        }
        expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Equality, rightExp, this.dbType);
        if (this.lexer.token == Token.IS || this.lexer.token == Token.BETWEEN) {
            expr = this.relationalRest(expr);
        }
        return expr;
    }

    public SQLExpr equalityRest(SQLExpr expr) {
        Token token = this.lexer.token;
        if (token == Token.EQ) {
            SQLExpr rightExp;
            this.lexer.nextToken();
            try {
                rightExp = this.bitOr();
            }
            catch (EOFParserException e) {
                throw new ParserException("EOF, " + expr + "=", e);
            }
            if (this.lexer.token == Token.COLONEQ) {
                this.lexer.nextToken();
                SQLExpr colonExpr = this.expr();
                rightExp = new SQLBinaryOpExpr(rightExp, SQLBinaryOperator.Assignment, colonExpr, this.dbType);
            }
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Equality, rightExp, this.dbType);
        } else {
            if (this.lexer.token() == Token.EQGT) {
                this.lexer.nextToken();
                SQLExpr rightExp = this.expr();
                String argumentName = ((SQLIdentifierExpr)expr).getName();
                return new OracleArgumentExpr(argumentName, rightExp);
            }
            if (token == Token.BANGEQ || token == Token.CARETEQ) {
                this.lexer.nextToken();
                SQLExpr rightExp = this.bitOr();
                rightExp = this.equalityRest(rightExp);
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotEqual, rightExp, this.dbType);
            } else if (token == Token.COLONEQ) {
                this.lexer.nextToken();
                SQLExpr rightExp = this.expr();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Assignment, rightExp, this.dbType);
            }
        }
        if (this.lexer.token == Token.IS || this.lexer.token == Token.BETWEEN) {
            expr = this.relationalRest(expr);
        }
        return expr;
    }

    public final SQLExpr inRest(SQLExpr expr) {
        if (this.lexer.token == Token.IN) {
            SQLExpr targetExpr;
            this.lexer.nextTokenLParen();
            SQLInListExpr inListExpr = new SQLInListExpr(expr);
            List<SQLExpr> targetList = inListExpr.getTargetList();
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextTokenValue();
                if (this.lexer.token == Token.WITH) {
                    SQLSelect select = this.createSelectParser().select();
                    SQLInSubQueryExpr queryExpr = new SQLInSubQueryExpr(select);
                    queryExpr.setExpr(expr);
                    this.accept(Token.RPAREN);
                    return queryExpr;
                }
                while (true) {
                    SQLExpr item;
                    if (this.lexer.token == Token.LITERAL_INT) {
                        item = new SQLIntegerExpr(this.lexer.integerValue());
                        this.lexer.nextToken();
                        if (this.lexer.token != Token.COMMA && this.lexer.token != Token.RPAREN) {
                            item = this.primaryRest(item);
                            item = this.exprRest(item);
                        }
                    } else {
                        item = this.expr();
                    }
                    item.setParent(inListExpr);
                    targetList.add(item);
                    if (this.lexer.token != Token.COMMA) break;
                    this.lexer.nextTokenValue();
                }
                this.accept(Token.RPAREN);
            } else {
                SQLExpr itemExpr = this.primary();
                itemExpr.setParent(inListExpr);
                targetList.add(itemExpr);
            }
            expr = inListExpr;
            if (targetList.size() == 1 && (targetExpr = targetList.get(0)) instanceof SQLQueryExpr) {
                SQLInSubQueryExpr inSubQueryExpr = new SQLInSubQueryExpr();
                inSubQueryExpr.setExpr(inListExpr.getExpr());
                inSubQueryExpr.setSubQuery(((SQLQueryExpr)targetExpr).getSubQuery());
                expr = inSubQueryExpr;
            }
        }
        return expr;
    }

    public final SQLExpr additive() {
        SQLExpr expr = this.multiplicative();
        return this.additiveRest(expr);
    }

    public SQLExpr additiveRest(SQLExpr expr) {
        Token token = this.lexer.token;
        if (token == Token.PLUS) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.multiplicative();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Add, rightExp, this.dbType);
            expr = this.additiveRest(expr);
        } else if (!(token != Token.BARBAR && token != Token.CONCAT || "mysql".equals(this.dbType))) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.multiplicative();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Concat, rightExp, this.dbType);
            expr = this.additiveRest(expr);
        } else if (token == Token.SUB) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.multiplicative();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Subtract, rightExp, this.dbType);
            expr = this.additiveRest(expr);
        }
        return expr;
    }

    public final SQLExpr shift() {
        SQLExpr expr = this.additive();
        return this.shiftRest(expr);
    }

    public SQLExpr shiftRest(SQLExpr expr) {
        if (this.lexer.token == Token.LTLT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.additive();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.LeftShift, rightExp, this.dbType);
            expr = this.shiftRest(expr);
        } else if (this.lexer.token == Token.GTGT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.additive();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.RightShift, rightExp, this.dbType);
            expr = this.shiftRest(expr);
        }
        return expr;
    }

    public SQLExpr and() {
        SQLExpr expr = this.relational();
        return this.andRest(expr);
    }

    public SQLExpr andRest(SQLExpr expr) {
        while (true) {
            SQLExpr rightExp;
            Token token;
            if ((token = this.lexer.token) == Token.AND) {
                if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                    expr.addAfterComment(this.lexer.readAndResetComments());
                }
                this.lexer.nextToken();
                rightExp = this.relational();
                if (this.lexer.token == Token.AND && this.lexer.isEnabled(SQLParserFeature.EnableSQLBinaryOpExprGroup)) {
                    SQLBinaryOpExprGroup group = new SQLBinaryOpExprGroup(SQLBinaryOperator.BooleanAnd, this.dbType);
                    group.add(expr);
                    group.add(rightExp);
                    if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                        rightExp.addAfterComment(this.lexer.readAndResetComments());
                    }
                    while (true) {
                        this.lexer.nextToken();
                        SQLExpr more = this.relational();
                        group.add(more);
                        if (this.lexer.token != Token.AND) break;
                        if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                        more.addAfterComment(this.lexer.readAndResetComments());
                    }
                    expr = group;
                    continue;
                }
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanAnd, rightExp, this.dbType);
                continue;
            }
            if (token != Token.AMPAMP) break;
            if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                expr.addAfterComment(this.lexer.readAndResetComments());
            }
            this.lexer.nextToken();
            rightExp = this.relational();
            SQLBinaryOperator operator = "postgresql".equals(this.dbType) ? SQLBinaryOperator.PG_And : SQLBinaryOperator.BooleanAnd;
            expr = new SQLBinaryOpExpr(expr, operator, rightExp, this.dbType);
        }
        return expr;
    }

    public SQLExpr or() {
        SQLExpr expr = this.and();
        return this.orRest(expr);
    }

    public SQLExpr orRest(SQLExpr expr) {
        while (true) {
            SQLExpr rightExp;
            if (this.lexer.token == Token.OR) {
                this.lexer.nextToken();
                rightExp = this.and();
                if (this.lexer.token == Token.OR && this.lexer.isEnabled(SQLParserFeature.EnableSQLBinaryOpExprGroup)) {
                    SQLBinaryOpExprGroup group = new SQLBinaryOpExprGroup(SQLBinaryOperator.BooleanOr, this.dbType);
                    group.add(expr);
                    group.add(rightExp);
                    if (this.lexer.isKeepComments() && this.lexer.hasComment()) {
                        rightExp.addAfterComment(this.lexer.readAndResetComments());
                    }
                    while (true) {
                        this.lexer.nextToken();
                        SQLExpr more = this.relational();
                        group.add(more);
                        if (this.lexer.token != Token.OR) break;
                        if (!this.lexer.isKeepComments() || !this.lexer.hasComment()) continue;
                        more.addAfterComment(this.lexer.readAndResetComments());
                    }
                    expr = group;
                    continue;
                }
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanOr, rightExp, this.dbType);
                continue;
            }
            if (this.lexer.token == Token.BARBAR && "mysql".equals(this.dbType)) {
                this.lexer.nextToken();
                rightExp = this.and();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanOr, rightExp, this.dbType);
                continue;
            }
            if (this.lexer.token != Token.XOR) break;
            this.lexer.nextToken();
            rightExp = this.and();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.BooleanXor, rightExp, this.dbType);
        }
        return expr;
    }

    public SQLExpr relational() {
        SQLExpr expr = this.equality();
        return this.relationalRest(expr);
    }

    public SQLExpr relationalRest(SQLExpr expr) {
        Token token = this.lexer.token;
        if (token == Token.LT) {
            SQLBinaryOperator op = SQLBinaryOperator.LessThan;
            this.lexer.nextToken();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
                op = SQLBinaryOperator.LessThanOrEqual;
            }
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, op, rightExp, this.getDbType());
        } else if (token == Token.LTEQ) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.LessThanOrEqual, rightExp, this.getDbType());
        } else if (token == Token.LTEQGT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.LessThanOrEqualOrGreaterThan, rightExp, this.getDbType());
        } else if (token == Token.GT) {
            SQLBinaryOperator op = SQLBinaryOperator.GreaterThan;
            this.lexer.nextToken();
            if (this.lexer.token == Token.EQ) {
                this.lexer.nextToken();
                op = SQLBinaryOperator.GreaterThanOrEqual;
            }
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, op, rightExp, this.getDbType());
        } else if (token == Token.GTEQ) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.GreaterThanOrEqual, rightExp, this.getDbType());
        } else if (token == Token.BANGLT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotLessThan, rightExp, this.getDbType());
        } else if (token == Token.BANGGT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotGreaterThan, rightExp, this.getDbType());
        } else if (token == Token.LTGT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.LessThanOrGreater, rightExp, this.getDbType());
        } else if (token == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.bitOr();
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Like, rightExp, this.getDbType());
            if (this.lexer.token == Token.ESCAPE) {
                this.lexer.nextToken();
                rightExp = this.primary();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Escape, rightExp, this.getDbType());
            }
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RLIKE)) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.RLike, rightExp, this.getDbType());
        } else if (token == Token.ILIKE) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.ILike, rightExp, this.getDbType());
        } else if (token == Token.MONKEYS_AT_AT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.AT_AT, rightExp, this.getDbType());
        } else if (token == Token.MONKEYS_AT_GT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Array_Contains, rightExp, this.getDbType());
        } else if (token == Token.LT_MONKEYS_AT) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Array_ContainedBy, rightExp, this.getDbType());
        } else if (token == Token.NOT) {
            this.lexer.nextToken();
            expr = this.notRationalRest(expr);
        } else if (token == Token.BETWEEN) {
            this.lexer.nextToken();
            SQLExpr beginExpr = this.bitOr();
            this.accept(Token.AND);
            SQLExpr endExpr = this.bitOr();
            expr = new SQLBetweenExpr(expr, beginExpr, endExpr);
        } else if (token == Token.IS) {
            SQLBinaryOperator op;
            this.lexer.nextTokenNotOrNull();
            if (this.lexer.token == Token.NOT) {
                op = SQLBinaryOperator.IsNot;
                this.lexer.nextTokenNotOrNull();
            } else {
                op = SQLBinaryOperator.Is;
            }
            SQLExpr rightExp = this.primary();
            expr = new SQLBinaryOpExpr(expr, op, rightExp, this.dbType);
        } else if (token == Token.IN) {
            expr = this.inRest(expr);
        } else {
            if (this.lexer.identifierEquals(FnvHash.Constants.REGEXP)) {
                this.lexer.nextToken();
                SQLExpr rightExp = this.equality();
                rightExp = this.relationalRest(rightExp);
                return new SQLBinaryOpExpr(expr, SQLBinaryOperator.RegExp, rightExp, "mysql");
            }
            if ("postgresql".equals(this.lexer.dbType)) {
                if (this.lexer.identifierEquals(FnvHash.Constants.SIMILAR)) {
                    this.lexer.nextToken();
                    this.accept(Token.TO);
                    SQLExpr rightExp = this.equality();
                    rightExp = this.relationalRest(rightExp);
                    expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.SIMILAR_TO, rightExp, this.getDbType());
                } else if (token == Token.TILDE) {
                    this.lexer.nextToken();
                    SQLExpr rightExp = this.equality();
                    rightExp = this.relationalRest(rightExp);
                    expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.POSIX_Regular_Match, rightExp, this.getDbType());
                } else if (token == Token.TILDE_STAR) {
                    this.lexer.nextToken();
                    SQLExpr rightExp = this.equality();
                    rightExp = this.relationalRest(rightExp);
                    expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.POSIX_Regular_Match_Insensitive, rightExp, this.getDbType());
                } else if (token == Token.BANG_TILDE) {
                    this.lexer.nextToken();
                    SQLExpr rightExp = this.equality();
                    rightExp = this.relationalRest(rightExp);
                    expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.POSIX_Regular_Not_Match, rightExp, this.getDbType());
                } else if (token == Token.BANG_TILDE_STAR) {
                    this.lexer.nextToken();
                    SQLExpr rightExp = this.equality();
                    rightExp = this.relationalRest(rightExp);
                    expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.POSIX_Regular_Not_Match_POSIX_Regular_Match_Insensitive, rightExp, this.getDbType());
                } else if (token == Token.TILDE_EQ) {
                    this.lexer.nextToken();
                    SQLExpr rightExp = this.equality();
                    rightExp = this.relationalRest(rightExp);
                    expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.SAME_AS, rightExp, this.getDbType());
                }
            }
        }
        if (this.lexer.token == Token.IS || this.lexer.token == Token.BETWEEN) {
            expr = this.relationalRest(expr);
        }
        return expr;
    }

    public SQLExpr notRationalRest(SQLExpr expr) {
        if (this.lexer.token == Token.LIKE) {
            this.lexer.nextToken();
            SQLExpr rightExp = this.equality();
            rightExp = this.relationalRest(rightExp);
            expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotLike, rightExp, this.getDbType());
            if (this.lexer.token == Token.ESCAPE) {
                this.lexer.nextToken();
                rightExp = this.expr();
                expr = new SQLBinaryOpExpr(expr, SQLBinaryOperator.Escape, rightExp, this.getDbType());
            }
        } else {
            if (this.lexer.token == Token.IN) {
                SQLExpr targetExpr;
                this.lexer.nextToken();
                SQLInListExpr inListExpr = new SQLInListExpr(expr, true);
                if (this.lexer.token == Token.LPAREN) {
                    this.lexer.nextToken();
                    this.exprList(inListExpr.getTargetList(), inListExpr);
                    expr = inListExpr;
                    this.accept(Token.RPAREN);
                } else {
                    SQLExpr valueExpr = this.primary();
                    valueExpr.setParent(inListExpr);
                    inListExpr.getTargetList().add(valueExpr);
                    expr = inListExpr;
                }
                if (inListExpr.getTargetList().size() == 1 && (targetExpr = inListExpr.getTargetList().get(0)) instanceof SQLQueryExpr) {
                    SQLInSubQueryExpr inSubQueryExpr = new SQLInSubQueryExpr();
                    inSubQueryExpr.setNot(true);
                    inSubQueryExpr.setExpr(inListExpr.getExpr());
                    inSubQueryExpr.setSubQuery(((SQLQueryExpr)targetExpr).getSubQuery());
                    expr = inSubQueryExpr;
                }
                expr = this.relationalRest(expr);
                return expr;
            }
            if (this.lexer.token == Token.BETWEEN) {
                this.lexer.nextToken();
                SQLExpr beginExpr = this.bitOr();
                this.accept(Token.AND);
                SQLExpr endExpr = this.bitOr();
                expr = new SQLBetweenExpr(expr, true, beginExpr, endExpr);
                return expr;
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.RLIKE)) {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                rightExp = this.relationalRest(rightExp);
                return new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotRLike, rightExp, this.getDbType());
            }
            if (this.lexer.token == Token.ILIKE) {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                rightExp = this.relationalRest(rightExp);
                return new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotILike, rightExp, this.getDbType());
            }
            if (this.lexer.identifierEquals(FnvHash.Constants.REGEXP)) {
                this.lexer.nextToken();
                SQLExpr rightExp = this.primary();
                rightExp = this.relationalRest(rightExp);
                return new SQLBinaryOpExpr(expr, SQLBinaryOperator.NotRegExp, rightExp, "mysql");
            }
            throw new ParserException("TODO " + this.lexer.info());
        }
        return expr;
    }

    public SQLDataType parseDataType() {
        return this.parseDataType(true);
    }

    public SQLDataType parseDataType(boolean restrict) {
        Token token = this.lexer.token;
        if (token == Token.DEFAULT || token == Token.NOT || token == Token.NULL) {
            return null;
        }
        SQLName typeExpr = this.name();
        String typeName = typeExpr.toString();
        if ("long".equalsIgnoreCase(typeName) && this.lexer.identifierEquals("byte") && "mysql".equals(this.getDbType())) {
            typeName = typeName + ' ' + this.lexer.stringVal();
            this.lexer.nextToken();
        } else if ("double".equalsIgnoreCase(typeName) && "postgresql".equals(this.getDbType())) {
            typeName = typeName + ' ' + this.lexer.stringVal();
            this.lexer.nextToken();
        }
        if (this.isCharType(typeName)) {
            SQLCharacterDataType charType = new SQLCharacterDataType(typeName);
            if (this.lexer.token == Token.LPAREN) {
                this.lexer.nextToken();
                SQLExpr arg = this.expr();
                arg.setParent(charType);
                charType.addArgument(arg);
                this.accept(Token.RPAREN);
            }
            charType = (SQLCharacterDataType)this.parseCharTypeRest(charType);
            if (this.lexer.token == Token.HINT) {
                List<SQLCommentHint> hints = this.parseHints();
                charType.setHints(hints);
            }
            return charType;
        }
        if ("character".equalsIgnoreCase(typeName) && "varying".equalsIgnoreCase(this.lexer.stringVal())) {
            typeName = typeName + ' ' + this.lexer.stringVal();
            this.lexer.nextToken();
        }
        SQLDataTypeImpl dataType = new SQLDataTypeImpl(typeName);
        dataType.setDbType(this.dbType);
        return this.parseDataTypeRest(dataType);
    }

    protected SQLDataType parseDataTypeRest(SQLDataType dataType) {
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.exprList(dataType.getArguments(), dataType);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.PRECISION) && dataType.nameHashCode64() == FnvHash.Constants.DOUBLE) {
            this.lexer.nextToken();
            dataType.setName("DOUBLE PRECISION");
        }
        if (FnvHash.Constants.TIMESTAMP == dataType.nameHashCode64()) {
            if (this.lexer.identifierEquals(FnvHash.Constants.WITHOUT)) {
                this.lexer.nextToken();
                this.acceptIdentifier("TIME");
                this.acceptIdentifier("ZONE");
                dataType.setWithTimeZone(false);
            } else if (this.lexer.token == Token.WITH) {
                this.lexer.nextToken();
                this.acceptIdentifier("TIME");
                this.acceptIdentifier("ZONE");
                dataType.setWithTimeZone(true);
            }
        }
        return dataType;
    }

    protected boolean isCharType(String dataTypeName) {
        long hash = FnvHash.hashCode64(dataTypeName);
        return this.isCharType(hash);
    }

    protected boolean isCharType(long hash) {
        return hash == FnvHash.Constants.CHAR || hash == FnvHash.Constants.VARCHAR || hash == FnvHash.Constants.NCHAR || hash == FnvHash.Constants.NVARCHAR || hash == FnvHash.Constants.TINYTEXT || hash == FnvHash.Constants.TEXT || hash == FnvHash.Constants.MEDIUMTEXT || hash == FnvHash.Constants.LONGTEXT;
    }

    protected SQLDataType parseCharTypeRest(SQLCharacterDataType charType) {
        if (this.lexer.token == Token.BINARY) {
            charType.setHasBinary(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.CHARACTER)) {
            this.lexer.nextToken();
            this.accept(Token.SET);
            if (this.lexer.token != Token.IDENTIFIER && this.lexer.token != Token.LITERAL_CHARS && this.lexer.token != Token.BINARY) {
                throw new ParserException(this.lexer.info());
            }
            charType.setCharSetName(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        if (this.lexer.token == Token.BINARY) {
            charType.setHasBinary(true);
            this.lexer.nextToken();
        }
        if (this.lexer.identifierEquals(FnvHash.Constants.COLLATE)) {
            this.lexer.nextToken();
            if (this.lexer.token != Token.IDENTIFIER) {
                throw new ParserException();
            }
            charType.setCollate(this.lexer.stringVal());
            this.lexer.nextToken();
        }
        return charType;
    }

    @Override
    public void accept(Token token) {
        if (this.lexer.token != token) {
            throw new ParserException("syntax error, expect " + (Object)((Object)token) + ", actual " + (Object)((Object)this.lexer.token) + " " + this.lexer.info());
        }
        this.lexer.nextToken();
    }

    public SQLColumnDefinition parseColumn() {
        SQLColumnDefinition column = this.createColumnDefinition();
        column.setName(this.name());
        Token token = this.lexer.token;
        if (token != Token.SET && token != Token.DROP && token != Token.PRIMARY && token != Token.RPAREN) {
            column.setDataType(this.parseDataType());
        }
        return this.parseColumnRest(column);
    }

    public SQLColumnDefinition createColumnDefinition() {
        SQLColumnDefinition column = new SQLColumnDefinition();
        column.setDbType(this.dbType);
        return column;
    }

    public SQLColumnDefinition parseColumnRest(SQLColumnDefinition column) {
        if (this.lexer.token == Token.DEFAULT) {
            this.lexer.nextToken();
            column.setDefaultExpr(this.bitOr());
            return this.parseColumnRest(column);
        }
        if (this.lexer.token == Token.NOT) {
            this.lexer.nextToken();
            this.accept(Token.NULL);
            SQLNotNullConstraint notNull = new SQLNotNullConstraint();
            if (this.lexer.token == Token.HINT) {
                List<SQLCommentHint> hints = this.parseHints();
                notNull.setHints(hints);
            }
            column.addConstraint(notNull);
            return this.parseColumnRest(column);
        }
        if (this.lexer.token == Token.NULL) {
            this.lexer.nextToken();
            column.getConstraints().add(new SQLNullConstraint());
            return this.parseColumnRest(column);
        }
        if (this.lexer.token == Token.PRIMARY) {
            this.lexer.nextToken();
            this.accept(Token.KEY);
            column.addConstraint(new SQLColumnPrimaryKey());
            return this.parseColumnRest(column);
        }
        if (this.lexer.token == Token.UNIQUE) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.KEY) {
                this.lexer.nextToken();
            }
            column.addConstraint(new SQLColumnUniqueKey());
            return this.parseColumnRest(column);
        }
        if (this.lexer.token == Token.KEY) {
            this.lexer.nextToken();
            column.addConstraint(new SQLColumnUniqueKey());
            return this.parseColumnRest(column);
        }
        if (this.lexer.token == Token.REFERENCES) {
            SQLColumnReference ref = this.parseReference();
            column.addConstraint(ref);
            return this.parseColumnRest(column);
        }
        if (this.lexer.token == Token.CONSTRAINT) {
            this.lexer.nextToken();
            SQLName name = this.name();
            if (this.lexer.token == Token.PRIMARY) {
                this.lexer.nextToken();
                this.accept(Token.KEY);
                SQLColumnPrimaryKey pk = new SQLColumnPrimaryKey();
                pk.setName(name);
                column.addConstraint(pk);
                return this.parseColumnRest(column);
            }
            if (this.lexer.token == Token.UNIQUE) {
                this.lexer.nextToken();
                SQLColumnUniqueKey uk = new SQLColumnUniqueKey();
                uk.setName(name);
                column.addConstraint(uk);
                return this.parseColumnRest(column);
            }
            if (this.lexer.token == Token.REFERENCES) {
                SQLColumnReference ref = this.parseReference();
                ref.setName(name);
                column.addConstraint(ref);
                return this.parseColumnRest(column);
            }
            if (this.lexer.token == Token.NOT) {
                this.lexer.nextToken();
                this.accept(Token.NULL);
                SQLNotNullConstraint notNull = new SQLNotNullConstraint();
                notNull.setName(name);
                column.addConstraint(notNull);
                return this.parseColumnRest(column);
            }
            if (this.lexer.token == Token.CHECK) {
                SQLColumnCheck check = this.parseColumnCheck();
                check.setName(name);
                check.setParent(column);
                column.addConstraint(check);
                return this.parseColumnRest(column);
            }
            if (this.lexer.token == Token.DEFAULT) {
                this.lexer.nextToken();
                SQLExpr expr = this.expr();
                column.setDefaultExpr(expr);
                return this.parseColumnRest(column);
            }
            throw new ParserException("TODO : " + this.lexer.info());
        }
        if (this.lexer.token == Token.CHECK) {
            SQLColumnCheck check = this.parseColumnCheck();
            column.addConstraint(check);
            return this.parseColumnRest(column);
        }
        if (this.lexer.token == Token.COMMENT) {
            this.lexer.nextToken();
            if (this.lexer.token == Token.LITERAL_ALIAS) {
                String alias = this.lexer.stringVal();
                if (alias.length() > 2 && alias.charAt(0) == '\"' && alias.charAt(alias.length() - 1) == '\"') {
                    alias = alias.substring(1, alias.length() - 1);
                }
                column.setComment(alias);
                this.lexer.nextToken();
            } else {
                column.setComment(this.primary());
            }
            return this.parseColumnRest(column);
        }
        return column;
    }

    private SQLColumnReference parseReference() {
        SQLColumnReference fk = new SQLColumnReference();
        this.lexer.nextToken();
        fk.setTable(this.name());
        this.accept(Token.LPAREN);
        this.names(fk.getColumns(), fk);
        this.accept(Token.RPAREN);
        if (this.lexer.identifierEquals(FnvHash.Constants.MATCH)) {
            this.lexer.nextToken();
            if (this.lexer.identifierEquals("FULL") || this.lexer.token() == Token.FULL) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.FULL);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.PARTIAL)) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.PARTIAL);
                this.lexer.nextToken();
            } else if (this.lexer.identifierEquals(FnvHash.Constants.SIMPLE)) {
                fk.setReferenceMatch(SQLForeignKeyImpl.Match.SIMPLE);
                this.lexer.nextToken();
            } else {
                throw new ParserException("TODO : " + this.lexer.info());
            }
        }
        while (this.lexer.token() == Token.ON) {
            SQLForeignKeyImpl.Option option;
            this.lexer.nextToken();
            if (this.lexer.token() == Token.DELETE) {
                this.lexer.nextToken();
                option = this.parseReferenceOption();
                fk.setOnDelete(option);
                continue;
            }
            if (this.lexer.token() == Token.UPDATE) {
                this.lexer.nextToken();
                option = this.parseReferenceOption();
                fk.setOnUpdate(option);
                continue;
            }
            throw new ParserException("syntax error, expect DELETE or UPDATE, actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.info());
        }
        return fk;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected SQLForeignKeyImpl.Option parseReferenceOption() {
        SQLForeignKeyImpl.Option option;
        if (this.lexer.token() == Token.RESTRICT || this.lexer.identifierEquals(FnvHash.Constants.RESTRICT)) {
            option = SQLForeignKeyImpl.Option.RESTRICT;
            this.lexer.nextToken();
            return option;
        } else if (this.lexer.identifierEquals(FnvHash.Constants.CASCADE)) {
            option = SQLForeignKeyImpl.Option.CASCADE;
            this.lexer.nextToken();
            return option;
        } else {
            if (this.lexer.token() == Token.SET) {
                this.lexer.nextToken();
                this.accept(Token.NULL);
                return SQLForeignKeyImpl.Option.SET_NULL;
            }
            if (this.lexer.token() != Token.ON) {
                if (!this.lexer.identifierEquals(FnvHash.Constants.ON)) throw new ParserException("syntax error, expect ACTION, actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.info());
            }
            this.lexer.nextToken();
            if (!this.lexer.identifierEquals(FnvHash.Constants.ACTION)) throw new ParserException("syntax error, expect ACTION, actual " + (Object)((Object)this.lexer.token()) + " " + this.lexer.info());
            option = SQLForeignKeyImpl.Option.NO_ACTION;
            this.lexer.nextToken();
        }
        return option;
    }

    protected SQLColumnCheck parseColumnCheck() {
        this.lexer.nextToken();
        SQLExpr expr = this.expr();
        SQLColumnCheck check = new SQLColumnCheck(expr);
        if (this.lexer.token == Token.DISABLE) {
            this.lexer.nextToken();
            check.setEnable(false);
        } else if (this.lexer.token == Token.ENABLE) {
            this.lexer.nextToken();
            check.setEnable(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.VALIDATE)) {
            this.lexer.nextToken();
            check.setValidate(Boolean.TRUE);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.NOVALIDATE)) {
            this.lexer.nextToken();
            check.setValidate(Boolean.FALSE);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RELY)) {
            this.lexer.nextToken();
            check.setRely(Boolean.TRUE);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.NORELY)) {
            this.lexer.nextToken();
            check.setRely(Boolean.FALSE);
        }
        return check;
    }

    public SQLPrimaryKey parsePrimaryKey() {
        this.accept(Token.PRIMARY);
        this.accept(Token.KEY);
        SQLPrimaryKeyImpl pk = new SQLPrimaryKeyImpl();
        this.accept(Token.LPAREN);
        this.orderBy(pk.getColumns(), pk);
        this.accept(Token.RPAREN);
        return pk;
    }

    public SQLUnique parseUnique() {
        this.accept(Token.UNIQUE);
        SQLUnique unique = new SQLUnique();
        this.accept(Token.LPAREN);
        this.orderBy(unique.getColumns(), unique);
        this.accept(Token.RPAREN);
        if (this.lexer.token == Token.DISABLE) {
            this.lexer.nextToken();
            unique.setEnable(false);
        } else if (this.lexer.token == Token.ENABLE) {
            this.lexer.nextToken();
            unique.setEnable(true);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.VALIDATE)) {
            this.lexer.nextToken();
            unique.setValidate(Boolean.TRUE);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.NOVALIDATE)) {
            this.lexer.nextToken();
            unique.setValidate(Boolean.FALSE);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.RELY)) {
            this.lexer.nextToken();
            unique.setRely(Boolean.TRUE);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.NORELY)) {
            this.lexer.nextToken();
            unique.setRely(Boolean.FALSE);
        }
        return unique;
    }

    public SQLAssignItem parseAssignItem() {
        SQLAssignItem item = new SQLAssignItem();
        SQLExpr var = this.primary();
        if (var instanceof SQLIdentifierExpr) {
            var = new SQLVariantRefExpr(((SQLIdentifierExpr)var).getName());
        }
        item.setTarget(var);
        if (this.lexer.token == Token.COLONEQ) {
            this.lexer.nextToken();
        } else {
            if (this.lexer.token == Token.TRUE || this.lexer.identifierEquals(FnvHash.Constants.TRUE)) {
                this.lexer.nextToken();
                item.setValue(new SQLBooleanExpr(true));
                return item;
            }
            if (this.lexer.token == Token.ON) {
                this.lexer.nextToken();
                item.setValue(new SQLIdentifierExpr("ON"));
                return item;
            }
            this.accept(Token.EQ);
        }
        if (this.lexer.token == Token.ON) {
            item.setValue(new SQLIdentifierExpr(this.lexer.stringVal()));
            this.lexer.nextToken();
        } else if (this.lexer.token == Token.ALL) {
            item.setValue(new SQLIdentifierExpr(this.lexer.stringVal()));
            this.lexer.nextToken();
        } else {
            SQLExpr expr = this.expr();
            if (this.lexer.token == Token.COMMA && "postgresql".equals(this.dbType)) {
                SQLListExpr listExpr = new SQLListExpr();
                listExpr.addItem(expr);
                expr.setParent(listExpr);
                do {
                    this.lexer.nextToken();
                    SQLExpr listItem = this.expr();
                    listItem.setParent(listExpr);
                    listExpr.addItem(listItem);
                } while (this.lexer.token == Token.COMMA);
                item.setValue(listExpr);
            } else {
                item.setValue(expr);
            }
        }
        return item;
    }

    public List<SQLCommentHint> parseHints() {
        ArrayList<SQLCommentHint> hints = new ArrayList<SQLCommentHint>();
        this.parseHints(hints);
        return hints;
    }

    public void parseHints(List hints) {
        if (this.lexer.token == Token.HINT) {
            hints.add(new SQLCommentHint(this.lexer.stringVal()));
            this.lexer.nextToken();
        }
    }

    public SQLConstraint parseConstaint() {
        SQLConstraint constraint;
        SQLName name = null;
        if (this.lexer.token == Token.CONSTRAINT) {
            this.lexer.nextToken();
            name = this.name();
        }
        if (this.lexer.token == Token.PRIMARY) {
            constraint = this.parsePrimaryKey();
        } else if (this.lexer.token == Token.UNIQUE) {
            constraint = this.parseUnique();
        } else if (this.lexer.token == Token.KEY) {
            constraint = this.parseUnique();
        } else if (this.lexer.token == Token.FOREIGN) {
            constraint = this.parseForeignKey();
        } else if (this.lexer.token == Token.CHECK) {
            constraint = this.parseCheck();
        } else {
            throw new ParserException("TODO : " + this.lexer.info());
        }
        constraint.setName(name);
        return constraint;
    }

    public SQLCheck parseCheck() {
        this.accept(Token.CHECK);
        SQLCheck check = this.createCheck();
        this.accept(Token.LPAREN);
        check.setExpr(this.expr());
        this.accept(Token.RPAREN);
        return check;
    }

    protected SQLCheck createCheck() {
        return new SQLCheck();
    }

    public SQLForeignKeyConstraint parseForeignKey() {
        this.accept(Token.FOREIGN);
        this.accept(Token.KEY);
        SQLForeignKeyImpl fk = this.createForeignKey();
        this.accept(Token.LPAREN);
        this.names(fk.getReferencingColumns(), fk);
        this.accept(Token.RPAREN);
        this.accept(Token.REFERENCES);
        fk.setReferencedTableName(this.name());
        if (this.lexer.token == Token.LPAREN) {
            this.lexer.nextToken();
            this.names(fk.getReferencedColumns(), fk);
            this.accept(Token.RPAREN);
        }
        if (this.lexer.token == Token.ON) {
            this.lexer.nextToken();
            this.accept(Token.DELETE);
            if (this.lexer.identifierEquals(FnvHash.Constants.CASCADE)) {
                this.lexer.nextToken();
                fk.setOnDeleteCascade(true);
            } else {
                this.accept(Token.SET);
                this.accept(Token.NULL);
                fk.setOnDeleteSetNull(true);
            }
        }
        return fk;
    }

    protected SQLForeignKeyImpl createForeignKey() {
        return new SQLForeignKeyImpl();
    }

    public SQLSelectItem parseSelectItem() {
        String alias;
        SQLExpr expr;
        boolean connectByRoot = false;
        Token token = this.lexer.token;
        if (token == Token.IDENTIFIER) {
            String as;
            String ident = this.lexer.stringVal();
            long hash_lower = this.lexer.hash_lower();
            this.lexer.nextTokenComma();
            if (hash_lower == FnvHash.Constants.CONNECT_BY_ROOT) {
                connectByRoot = true;
                expr = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
            } else if (FnvHash.Constants.DATE == hash_lower && this.lexer.token == Token.LITERAL_CHARS && ("oracle".equals(this.getDbType()) || "postgresql".equals(this.getDbType()))) {
                String literal = this.lexer.stringVal();
                this.lexer.nextToken();
                SQLDateExpr dateExpr = new SQLDateExpr();
                dateExpr.setLiteral(literal);
                expr = dateExpr;
            } else {
                expr = new SQLIdentifierExpr(ident, hash_lower);
            }
            token = this.lexer.token;
            if (token == Token.DOT) {
                long name_hash_lower;
                String name;
                this.lexer.nextTokenIdent();
                if (this.lexer.token == Token.STAR) {
                    name = "*";
                    name_hash_lower = FnvHash.Constants.STAR;
                } else {
                    name = this.lexer.stringVal();
                    name_hash_lower = this.lexer.hash_lower();
                }
                this.lexer.nextTokenComma();
                token = this.lexer.token;
                if (token == Token.LPAREN) {
                    boolean aggregate = hash_lower == FnvHash.Constants.WMSYS && name_hash_lower == FnvHash.Constants.WM_CONCAT;
                    expr = this.methodRest(expr, name, aggregate);
                    token = this.lexer.token;
                } else {
                    expr = name_hash_lower == FnvHash.Constants.NEXTVAL ? new SQLSequenceExpr((SQLIdentifierExpr)expr, SQLSequenceExpr.Function.NextVal) : (name_hash_lower == FnvHash.Constants.CURRVAL ? new SQLSequenceExpr((SQLIdentifierExpr)expr, SQLSequenceExpr.Function.CurrVal) : (name_hash_lower == FnvHash.Constants.PREVVAL ? new SQLSequenceExpr((SQLIdentifierExpr)expr, SQLSequenceExpr.Function.PrevVal) : new SQLPropertyExpr(expr, name, name_hash_lower)));
                }
            }
            if (token == Token.COMMA) {
                return new SQLSelectItem(expr, null, connectByRoot);
            }
            if (token == Token.AS) {
                this.lexer.nextToken();
                as = null;
                if (this.lexer.token != Token.COMMA && this.lexer.token != Token.FROM) {
                    as = this.lexer.stringVal();
                    this.lexer.nextTokenComma();
                    if (this.lexer.token == Token.DOT) {
                        this.lexer.nextToken();
                        as = as + '.' + this.lexer.stringVal();
                        this.lexer.nextToken();
                    }
                }
                return new SQLSelectItem(expr, as, connectByRoot);
            }
            if (token == Token.LITERAL_ALIAS) {
                as = this.lexer.stringVal();
                this.lexer.nextTokenComma();
                return new SQLSelectItem(expr, as, connectByRoot);
            }
            if (token == Token.IDENTIFIER && hash_lower != FnvHash.Constants.CURRENT || token == Token.MODEL) {
                if (this.lexer.hash_lower == FnvHash.Constants.FORCE && "mysql".equals(this.dbType)) {
                    String force = this.lexer.stringVal();
                    Lexer.SavePoint savePoint = this.lexer.mark();
                    this.lexer.nextToken();
                    if (this.lexer.token == Token.PARTITION) {
                        this.lexer.reset(savePoint);
                        as = null;
                    } else {
                        as = force;
                        this.lexer.nextTokenComma();
                    }
                } else {
                    as = this.lexer.stringVal();
                    this.lexer.nextTokenComma();
                }
                return new SQLSelectItem(expr, as, connectByRoot);
            }
            if (token == Token.LPAREN) {
                this.lexer.nextToken();
                expr = this.methodRest(expr, false);
            } else {
                expr = this.primaryRest(expr);
            }
            expr = this.exprRest(expr);
        } else {
            if (token == Token.STAR) {
                SQLAllColumnExpr expr2 = new SQLAllColumnExpr();
                this.lexer.nextToken();
                return new SQLSelectItem(expr2, null, connectByRoot);
            }
            if (token == Token.DO || token == Token.JOIN) {
                expr = this.name();
                expr = this.exprRest(expr);
            } else {
                expr = this.expr();
            }
        }
        switch (this.lexer.token) {
            case MODEL: 
            case FULL: 
            case TABLESPACE: {
                alias = this.lexer.stringVal();
                this.lexer.nextToken();
                break;
            }
            default: {
                alias = this.as();
            }
        }
        SQLSelectItem selectItem = new SQLSelectItem(expr, alias, connectByRoot);
        if (this.lexer.token == Token.HINT && !this.lexer.isEnabled(SQLParserFeature.StrictForWall)) {
            String comment = "/*" + this.lexer.stringVal() + "*/";
            selectItem.addAfterComment(comment);
            this.lexer.nextToken();
        }
        return selectItem;
    }

    public SQLExpr parseGroupingSet() {
        String tmp = this.lexer.stringVal();
        this.acceptIdentifier("GROUPING");
        SQLGroupingSetExpr expr = new SQLGroupingSetExpr();
        if (this.lexer.token != Token.SET && !this.lexer.identifierEquals(FnvHash.Constants.SET)) {
            return new SQLIdentifierExpr(tmp);
        }
        this.lexer.nextToken();
        this.accept(Token.LPAREN);
        this.exprList(expr.getParameters(), expr);
        this.accept(Token.RPAREN);
        return expr;
    }

    public SQLPartitionValue parsePartitionValues() {
        if (this.lexer.token != Token.VALUES) {
            return null;
        }
        this.lexer.nextToken();
        SQLPartitionValue values = null;
        if (this.lexer.token == Token.IN) {
            this.lexer.nextToken();
            values = new SQLPartitionValue(SQLPartitionValue.Operator.In);
            this.accept(Token.LPAREN);
            this.exprList(values.getItems(), values);
            this.accept(Token.RPAREN);
        } else if (this.lexer.identifierEquals(FnvHash.Constants.LESS)) {
            this.lexer.nextToken();
            this.acceptIdentifier("THAN");
            values = new SQLPartitionValue(SQLPartitionValue.Operator.LessThan);
            if (this.lexer.identifierEquals(FnvHash.Constants.MAXVALUE)) {
                SQLIdentifierExpr maxValue = new SQLIdentifierExpr(this.lexer.stringVal());
                this.lexer.nextToken();
                maxValue.setParent(values);
                values.addItem(maxValue);
            } else {
                this.accept(Token.LPAREN);
                this.exprList(values.getItems(), values);
                this.accept(Token.RPAREN);
            }
        } else if (this.lexer.token == Token.LPAREN) {
            values = new SQLPartitionValue(SQLPartitionValue.Operator.List);
            this.lexer.nextToken();
            this.exprList(values.getItems(), values);
            this.accept(Token.RPAREN);
        }
        return values;
    }

    protected static boolean isIdent(SQLExpr expr, String name) {
        if (expr instanceof SQLIdentifierExpr) {
            SQLIdentifierExpr identExpr = (SQLIdentifierExpr)expr;
            return identExpr.getName().equalsIgnoreCase(name);
        }
        return false;
    }

    public SQLLimit parseLimit() {
        if (this.lexer.token == Token.LIMIT) {
            SQLExpr temp;
            this.lexer.nextTokenValue();
            SQLLimit limit = new SQLLimit();
            if (this.lexer.token == Token.LITERAL_INT) {
                temp = new SQLIntegerExpr(this.lexer.integerValue());
                this.lexer.nextTokenComma();
                if (this.lexer.token != Token.COMMA && this.lexer.token != Token.EOF && this.lexer.token != Token.IDENTIFIER) {
                    temp = this.primaryRest(temp);
                    temp = this.exprRest(temp);
                }
            } else {
                temp = this.expr();
            }
            if (this.lexer.token == Token.COMMA) {
                SQLExpr rowCount;
                limit.setOffset(temp);
                this.lexer.nextTokenValue();
                if (this.lexer.token == Token.LITERAL_INT) {
                    rowCount = new SQLIntegerExpr(this.lexer.integerValue());
                    this.lexer.nextToken();
                    if (this.lexer.token != Token.EOF && this.lexer.token != Token.IDENTIFIER) {
                        rowCount = this.primaryRest(rowCount);
                        rowCount = this.exprRest(rowCount);
                    }
                } else {
                    rowCount = this.expr();
                }
                limit.setRowCount(rowCount);
            } else if (this.lexer.identifierEquals(FnvHash.Constants.OFFSET)) {
                limit.setRowCount(temp);
                this.lexer.nextToken();
                limit.setOffset(this.expr());
            } else {
                limit.setRowCount(temp);
            }
            return limit;
        }
        return null;
    }

    static {
        String[] strings = new String[]{"AVG", "COUNT", "MAX", "MIN", "STDDEV", "SUM"};
        AGGREGATE_FUNCTIONS_CODES = FnvHash.fnv1a_64_lower(strings, true);
        AGGREGATE_FUNCTIONS = new String[AGGREGATE_FUNCTIONS_CODES.length];
        for (String str : strings) {
            long hash = FnvHash.fnv1a_64_lower(str);
            int index = Arrays.binarySearch(AGGREGATE_FUNCTIONS_CODES, hash);
            SQLExprParser.AGGREGATE_FUNCTIONS[index] = str;
        }
    }
}

