/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.easy.base.component.BaseServiceImpl;
import com.easy.base.constant.BeanConstant;
import com.easy.base.entity.RowMap;
import com.easy.base.entity.ServiceResponse;
import com.easy.base.entity.ServiceSession;
import com.easy.base.util.TypeUtils;
import com.easy.base.util.UniqueID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public abstract class BaseCompomentServiceImpl<X, Y>
extends BaseServiceImpl<Y> {
    private String collectionName;
    private String keyfieldName;

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getKeyfieldName() {
        return this.keyfieldName;
    }

    public void setKeyfieldName(String keyfieldName) {
        this.keyfieldName = keyfieldName;
    }

    public BaseCompomentServiceImpl(String collectionName, String keyfieldName) {
        this.setCollectionName(collectionName);
        this.setKeyfieldName(keyfieldName);
    }

    protected abstract X getTemplate();

    protected abstract long onCount(X var1, Query var2, String var3);

    protected abstract <T> List<T> onFind(X var1, Query var2, Class<T> var3, String var4);

    protected abstract void onUpsert(X var1, Query var2, Update var3, String var4);

    protected abstract void onRemove(X var1, Query var2, String var3);

    protected void onBeforeQuery(Criteria criteria) {
    }

    protected void onAfterQuery(List<RowMap> dataList) {
        for (RowMap dataMap : dataList) {
            this.onRowAfterQuery(dataMap);
        }
    }

    protected void onQueryForEntID(ServiceSession session, JSONObject params) {
        params.put("ent_id", (Object)session.getEnt_id());
    }

    protected void onRowAfterQuery(RowMap dataMap) {
        if (dataMap.containsKey(this.getKeyfieldName())) {
            dataMap.put(this.getKeyfieldName(), TypeUtils.castToString(dataMap.get(this.getKeyfieldName())));
        }
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put("fields", 1);
        keyMap.put("order_field", 1);
        keyMap.put("order_direction", 1);
        keyMap.put("page_no", 1);
        keyMap.put("page_size", 1);
        if (paramsObject.containsKey((Object)"ent_id")) {
            this.onQueryForEntID(session, paramsObject);
        }
        if (paramsObject.containsKey((Object)this.getKeyfieldName())) {
            paramsObject.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(paramsObject.get((Object)this.getKeyfieldName())));
        }
        Set keySet = paramsObject.keySet();
        Criteria criteria = null;
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName)) continue;
            if (criteria == null) {
                criteria = Criteria.where((String)keyName).is(paramsObject.get((Object)keyName));
                continue;
            }
            criteria.and(keyName).is(paramsObject.get((Object)keyName));
        }
        this.onBeforeQuery(criteria);
        Query query = null;
        query = criteria != null ? new Query(criteria) : new Query();
        long rowCount = this.onCount(template, query, this.getCollectionName());
        JSONObject response = new JSONObject();
        response.put("total_results", (Object)rowCount);
        if (rowCount > 0L) {
            Integer pageno = BeanConstant.QueryPage.DEFAULT_PAGENO;
            Integer pageSize = BeanConstant.QueryPage.DEFAULT_PAGESIZE;
            if (paramsObject.containsKey((Object)"page_no")) {
                pageno = paramsObject.getInteger("page_no") - 1;
            }
            if (paramsObject.containsKey((Object)"page_size")) {
                pageSize = paramsObject.getInteger("page_size");
            }
            if (pageno < 0) {
                pageno = 0;
            }
            query.with((Pageable)new PageRequest(pageno.intValue(), pageSize.intValue()));
            List<RowMap> dataList = this.onFind(template, query, RowMap.class, this.getCollectionName());
            this.onAfterQuery(dataList);
            response.put(this.getCollectionName(), dataList);
        } else {
            response.put(this.getCollectionName(), new ArrayList());
        }
        return ServiceResponse.buildSuccess(response);
    }

    protected void onBeforeUpdate(Criteria criteria) {
    }

    protected void doUpdate(X template, Query query, Update update) {
        this.onUpsert(template, query, update, this.getCollectionName());
    }

    protected void onRowUpdateForEntID(ServiceSession session, JSONObject params) {
        params.put("ent_id", (Object)session.getEnt_id());
    }

    protected void onAfterRowUpdate(X template, Query query, JSONObject params) {
    }

    public ServiceResponse onUpdate(ServiceSession session, JSONObject paramsObject) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        if (paramsObject.containsKey((Object)this.getCollectionName())) {
            Object dataObject = paramsObject.get((Object)this.getCollectionName());
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(this.getCollectionName());
                for (int i = 0; i < paramsArray.size(); ++i) {
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (params.containsKey((Object)"ent_id")) {
                        this.onRowUpdateForEntID(session, params);
                    }
                    if (params.containsKey((Object)this.getKeyfieldName())) {
                        if (StringUtils.isEmpty((Object)params.get((Object)this.getKeyfieldName()))) {
                            params.put(this.getKeyfieldName(), (Object)UniqueID.getUniqueID(true));
                        } else {
                            params.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(params.get((Object)this.getKeyfieldName())));
                        }
                    } else {
                        return ServiceResponse.buildFailure(session, "50000", "\u8bf7\u6c42\u6761\u4ef6\u7f3a\u5185\u90e8ID\u5173\u952e\u5b57{0}", this.getKeyfieldName());
                    }
                    HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
                    keyMap.put(this.getKeyfieldName(), 1);
                    Criteria criteria = Criteria.where((String)this.getKeyfieldName()).is(params.get((Object)this.getKeyfieldName()));
                    if (params.containsKey((Object)"ent_id") && !"ent_id".equals(this.getKeyfieldName())) {
                        criteria.and("ent_id").is(params.get((Object)"ent_id"));
                        keyMap.put("ent_id", 1);
                    }
                    this.onBeforeUpdate(criteria);
                    Query query = new Query((CriteriaDefinition)criteria);
                    System.out.println(query.toString());
                    Update update = new Update();
                    Set keySet = params.keySet();
                    for (String keyName : keySet) {
                        if (keyMap.containsKey(keyName)) continue;
                        this.onAssistMap(update, (Map<String, Object>)params, keyName);
                    }
                    this.doUpdate(template, query, update);
                    this.onAfterRowUpdate(template, query, params);
                }
            }
        } else {
            HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
            keyMap.put(this.getKeyfieldName(), 1);
            if (paramsObject.containsKey((Object)"ent_id")) {
                this.onRowUpdateForEntID(session, paramsObject);
                keyMap.put("ent_id", 1);
            }
            if (paramsObject.containsKey((Object)this.getKeyfieldName())) {
                paramsObject.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(paramsObject.get((Object)this.getKeyfieldName())));
            }
            Criteria criteria = Criteria.where((String)this.getKeyfieldName()).is(paramsObject.get((Object)this.getKeyfieldName()));
            if (paramsObject.containsKey((Object)"ent_id") && !"ent_id".equals(this.getKeyfieldName())) {
                criteria.and("ent_id").is(paramsObject.get((Object)"ent_id"));
                keyMap.put("ent_id", 1);
            }
            this.onBeforeUpdate(criteria);
            Query query = new Query((CriteriaDefinition)criteria);
            Update update = new Update();
            Set keySet = paramsObject.keySet();
            for (String keyName : keySet) {
                if (keyMap.containsKey(keyName)) continue;
                this.onAssistMap(update, (Map<String, Object>)paramsObject, keyName);
            }
            this.doUpdate(template, query, update);
            this.onAfterRowUpdate(template, query, paramsObject);
        }
        JSONObject response = new JSONObject();
        return ServiceResponse.buildSuccess(response);
    }

    protected void onBeforeDelete(Criteria criteria) {
    }

    protected void doDelete(X template, Query query) {
        this.onRemove(template, query, this.getCollectionName());
    }

    protected void onDeleteForEntID(ServiceSession session, JSONObject params) {
        params.put("ent_id", (Object)session.getEnt_id());
    }

    public ServiceResponse onDelete(ServiceSession session, JSONObject paramsObject) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        if (paramsObject.containsKey((Object)this.getCollectionName())) {
            Object dataObject = paramsObject.get((Object)this.getCollectionName());
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(this.getCollectionName());
                for (int i = 0; i < paramsArray.size(); ++i) {
                    HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
                    keyMap.put("fields", 1);
                    keyMap.put("order_field", 1);
                    keyMap.put("order_direction", 1);
                    keyMap.put("page_no", 1);
                    keyMap.put("page_size", 1);
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (params.containsKey((Object)"ent_id")) {
                        this.onDeleteForEntID(session, paramsObject);
                    }
                    if (params.containsKey((Object)this.getKeyfieldName())) {
                        params.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(params.get((Object)this.getKeyfieldName())));
                    }
                    Set keySet = params.keySet();
                    Criteria criteria = null;
                    for (String keyName : keySet) {
                        if (keyMap.containsKey(keyName)) continue;
                        if (criteria == null) {
                            criteria = Criteria.where((String)keyName).is(params.get((Object)keyName));
                            continue;
                        }
                        criteria.and(keyName).is(params.get((Object)keyName));
                    }
                    if (criteria == null) continue;
                    this.onBeforeDelete(criteria);
                    Query query = new Query(criteria);
                    this.doDelete(template, query);
                }
            }
        } else {
            HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
            keyMap.put("fields", 1);
            keyMap.put("order_field", 1);
            keyMap.put("order_direction", 1);
            keyMap.put("page_no", 1);
            keyMap.put("page_size", 1);
            if (paramsObject.containsKey((Object)"ent_id")) {
                this.onDeleteForEntID(session, paramsObject);
            }
            if (paramsObject.containsKey((Object)this.getKeyfieldName())) {
                paramsObject.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(paramsObject.get((Object)this.getKeyfieldName())));
            }
            Set keySet = paramsObject.keySet();
            Criteria criteria = null;
            for (String keyName : keySet) {
                if (keyMap.containsKey(keyName)) continue;
                if (criteria == null) {
                    criteria = Criteria.where((String)keyName).is(paramsObject.get((Object)keyName));
                    continue;
                }
                criteria.and(keyName).is(paramsObject.get((Object)keyName));
            }
            if (criteria != null) {
                this.onBeforeDelete(criteria);
                Query query = new Query(criteria);
                this.doDelete(template, query);
            }
        }
        JSONObject response = new JSONObject();
        return ServiceResponse.buildSuccess(response);
    }
}

