/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.easy.base.component.test.TestJdbcServiceImpl;
import com.easy.base.component.test.TestMongoServiceImpl;
import com.easy.base.storage.template.FMybatisTemplate;
import com.easy.base.util.MessageSourceHelper;
import com.easy.base.util.ServiceMethodReflect;
import com.easy.base.util.UniqueID;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.jdbc.DataSourceBuilder;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
@EnableAutoConfiguration
public class DataConfiger {
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    SqlSessionFactoryBean sqlSessionFactory;
    @Autowired
    private ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean(name={"UniqueID"})
    UniqueID onUniqueIDTemplate() throws Exception {
        UniqueID instance = new UniqueID();
        instance.setHostId("120");
        return instance;
    }

    @Bean(name={"primaryDataSource"})
    @Qualifier(value="primaryDataSource")
    @ConfigurationProperties(prefix="spring.datasource.primary")
    public DataSource onDataSource() {
        return DataSourceBuilder.create().build();
    }

    @Bean(name={"JdbcTemplate"})
    public JdbcTemplate onJdbcTemplate(@Qualifier(value="primaryDataSource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean(name={"secondaryDataSource"})
    @Qualifier(value="secondaryDataSource")
    @ConfigurationProperties(prefix="spring.datasource.secondary")
    @Primary
    public DruidDataSource onDruidDataSource() {
        DruidDataSource service = new DruidDataSource();
        service.setDriverClassName("oracle.jdbc.driver.OracleDriver");
        service.setUrl("jdbc:oracle:thin:@172.17.11.97:1521:omcomp");
        service.setUsername("ocminfo");
        service.setPassword("future");
        service.setMaxActive(10);
        service.setInitialSize(1);
        service.setMaxWait(600000L);
        service.setMaxIdle(20);
        service.setMinIdle(3);
        service.setRemoveAbandoned(true);
        service.setRemoveAbandonedTimeout(1800);
        service.setTestOnBorrow(true);
        service.setValidationQuery("select 1 from dual");
        return service;
    }

    @Autowired
    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier(value="secondaryDataSource") DataSource datasource) {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource);
        return service;
    }

    @Bean(name={"StorageOperation"})
    public FMybatisTemplate onFMybatisTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    @Bean(name={"ServiceMethodReflect"})
    public ServiceMethodReflect onServiceMethodReflect() {
        return new ServiceMethodReflect();
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource onResourceBundleMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"message"});
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean(name={"messageSourceHelper"})
    public MessageSourceHelper onMessageSourceHelper() {
        MessageSourceHelper messageSourceHelper = new MessageSourceHelper();
        messageSourceHelper.setMessageSource(this.onResourceBundleMessageSource());
        return messageSourceHelper;
    }

    @Bean(name={"testMongo"})
    public TestMongoServiceImpl onMongoServiceImpl() {
        String collectionName = "testTable";
        String keyfieldName = "testpkey";
        TestMongoServiceImpl service = new TestMongoServiceImpl(collectionName, keyfieldName);
        return service;
    }

    @Bean(name={"testJdbc"})
    public TestJdbcServiceImpl onJdbcServiceImpl() {
        String collectionName = "testTable";
        String keyfieldName = "testpkey";
        TestJdbcServiceImpl service = new TestJdbcServiceImpl(collectionName, keyfieldName);
        return service;
    }
}

