/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.storage.parser;

import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.druid.sql.ast.expr.SQLNumberExpr;
import com.alibaba.druid.sql.ast.statement.SQLTableSource;
import com.alibaba.druid.sql.ast.statement.SQLUpdateSetItem;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.druid.sql.dialect.mysql.ast.statement.MySqlUpdateStatement;
import com.alibaba.druid.sql.dialect.oracle.ast.stmt.OracleUpdateStatement;
import com.alibaba.druid.sql.dialect.postgresql.ast.stmt.PGUpdateStatement;
import com.alibaba.druid.sql.dialect.sqlserver.ast.stmt.SQLServerUpdateStatement;
import com.easy.base.storage.parser.ExprTranslator;
import com.easy.base.storage.parser.MongoExpr;
import com.easy.base.storage.parser.QueryExtractor;
import com.mongodb.DBObject;
import java.util.List;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.SerializationUtils;
import org.springframework.data.mongodb.core.query.Update;

public class QueryUpdateExtractor
extends QueryExtractor {
    private Query query;
    private Update update;
    private boolean upsert;
    private boolean multi;

    public QueryUpdateExtractor(String collectionName, Query query, Update update) {
        this(collectionName, query, update, false, true);
    }

    public QueryUpdateExtractor(String collectionName, Query query, Update update, boolean upsert, boolean multi) {
        this.collectionName = collectionName;
        this.query = query;
        this.update = update;
        this.upsert = upsert;
        this.multi = multi;
    }

    @Override
    public String getQueryForMongo() {
        StringBuilder sb = new StringBuilder();
        sb.append("db").append(".").append(this.collectionName).append(".update(").append(this.getMongoQueryString(this.query));
        if (this.update != null) {
            sb.append(", ");
            sb.append(SerializationUtils.serializeToJsonSafely((Object)this.update.getUpdateObject()));
        }
        if (this.upsert || this.multi) {
            sb.append(", {");
            String key = "upsert";
            if (this.multi) {
                key = "multi";
            }
            sb.append("\"").append(key).append("\" : true");
            sb.append("}");
        }
        sb.append(")");
        return sb.toString();
    }

    @Override
    public String getQueryForSQL() {
        if (this.upsert) {
            throw new IllegalArgumentException("Upsert not supported");
        }
        MySqlUpdateStatement stmt = null;
        switch (this.SQLDBType) {
            case MYSQL: {
                stmt = new MySqlUpdateStatement();
                break;
            }
            case ORACLE: {
                stmt = new OracleUpdateStatement();
                break;
            }
            case SQLSERVER: {
                stmt = new SQLServerUpdateStatement();
                break;
            }
            case POSTGRESQL: {
                stmt = new PGUpdateStatement();
                break;
            }
            default: {
                stmt = new SQLUpdateStatement();
            }
        }
        stmt.setTableSource((SQLTableSource)ExprTranslator.translateTableName(this.collectionName));
        if (this.query != null && this.query.getQueryObject() != null) {
            stmt.setWhere(ExprTranslator.translateWhere(this.query.getQueryObject(), this.SQLDBType));
        }
        this.parseSetItems(this.update, (SQLUpdateStatement)stmt);
        if (!this.multi && stmt instanceof MySqlUpdateStatement) {
            MySqlSelectQueryBlock.Limit limit = new MySqlSelectQueryBlock.Limit();
            limit.setRowCount((SQLExpr)new SQLNumberExpr((Number)1));
            stmt.setLimit(limit);
        }
        return this.getSQL((SQLStatement)stmt);
    }

    private void parseSetItems(Update update, SQLUpdateStatement stmt) {
        List updateItems = stmt.getItems();
        DBObject updateObj = update.getUpdateObject();
        block4: for (String op : updateObj.keySet()) {
            DBObject obj = (DBObject)updateObj.get(op);
            switch (MongoExpr.fromString(op)) {
                case 22: {
                    SQLUpdateSetItem item;
                    for (String key : obj.keySet()) {
                        item = new SQLUpdateSetItem();
                        item.setColumn(ExprTranslator.translateKey(key));
                        item.setValue(ExprTranslator.parseObject(obj.get(key), this.SQLDBType));
                        updateItems.add(item);
                    }
                    continue block4;
                }
                case 23: {
                    SQLUpdateSetItem item;
                    for (String key : obj.keySet()) {
                        item = new SQLUpdateSetItem();
                        SQLExpr keyExpr = ExprTranslator.translateKey(key);
                        item.setColumn(keyExpr);
                        SQLExpr incValueExpr = ExprTranslator.parseObject(obj.get(key), this.SQLDBType);
                        SQLBinaryOpExpr valExpr = new SQLBinaryOpExpr(keyExpr, SQLBinaryOperator.Add, incValueExpr);
                        item.setValue((SQLExpr)valExpr);
                        updateItems.add(item);
                    }
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported array operator: " + op);
                }
            }
        }
    }
}

