package com.efuture.ocp.common.cache.config;

import cn.hutool.extra.spring.SpringUtil;
import com.efuture.ocp.common.distributedLock.*;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.data.redis.connection.RedisConnectionFactory;

@Configuration
@ConditionalOnClass(RedisConnectionFactory.class)
@Import(SpringUtil.class)
public class FutureRedisLockAutoConfig
{

    @Bean
    @ConditionalOnMissingBean(DistributedLockHandle.class)
    public DistributedLockHandle lockHandle(RedisConnectionFactory redisConnectionFactory)
    {
        return new SpringRedisDistributedLockHandle(redisConnectionFactory);
    }

    @Bean
    @ConditionalOnMissingBean(DistributedLockKeyHandle.class)
    public DistributedLockKeyHandle keyHandle()
    {
        return new DistributedLockKeyBySpringEL();
    }

    @Bean
    @ConditionalOnMissingBean(LockTemplate.class)
    public LockTemplate lockTemplate(DistributedLockHandle lockHandle)
    {
        return new LockTemplate(lockHandle);
    }

    @Bean
    @ConditionalOnMissingBean(LockWatchdog.class)
    public LockWatchdog LockWatchdog(DistributedLockHandle lockHandle)
    {
        return new LockWatchdogImpl(lockHandle);
    }
}
