package com.efuture.ocp.common.cache.config;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(prefix = "efuture.cache")
public class RedisProperty
{
    // Redis服务器地址
    //@Value("${spring.redis.host}")
    @Value("${efuture.cache.redisHost}")
    private String host;
    // Redis服务器连接端口
    @Value("${efuture.cache.redisPort}")
    private Integer port;
    // Redis数据库索引（默认为0）
    //@Value("${spring.redis.database}")
    @Value("${efuture.cache.redisDatabase}")
    private Integer database;
    // Redis服务器连接密码（默认为空）
    //@Value("${spring.redis.password}")
    @Value("${efuture.cache.redisPassword}")
    private String password;
    // 连接超时时间（毫秒）
    //@Value("${spring.redis.timeout}")
    @Value("${efuture.cache.redisTimeout}")
    private Integer timeout;

    // 连接池最大连接数（使用负值表示没有限制）
    //@Value("${spring.redis.lettuce.pool.max-active}")
    @Value("${efuture.cache.redisMaxActive}")
    private Integer maxTotal;
    // 连接池最大阻塞等待时间（使用负值表示没有限制）
    //@Value("${spring.redis.lettuce.pool.max-wait}")
    @Value("${efuture.cache.redisMaxWait}")
    private Integer maxWait;
    // 连接池中的最大空闲连接 spring.redis.lettuce.pool.max-idle
    @Value("${efuture.cache.redisMaxIdle}")
    private Integer maxIdle;
    // 连接池中的最小空闲连接 spring.redis.lettuce.pool.min-idle
    @Value("${efuture.cache.redisMinIdle:1}")
    private Integer minIdle;
    // 关闭超时时间 spring.redis.lettuce.shutdown-timeout
    @Value("${efuture.cache.shutdownTimeout:5000}")
    private Integer shutdown;

    @Value("${efuture.cache.redis.message.topics:}")
    private String topics;

    public String getHost()
    {
        return host;
    }

    public void setHost(String host)
    {
        this.host = host;
    }

    public Integer getPort()
    {
        return port;
    }

    public void setPort(Integer port)
    {
        this.port = port;
    }

    public Integer getDatabase()
    {
        return database;
    }

    public void setDatabase(Integer database)
    {
        this.database = database;
    }

    public String getPassword()
    {
        return password;
    }

    public void setPassword(String password)
    {
        this.password = password;
    }

    public Integer getTimeout()
    {
        return timeout;
    }

    public void setTimeout(Integer timeout)
    {
        this.timeout = timeout;
    }

    public Integer getMaxTotal()
    {
        return maxTotal;
    }

    public void setMaxTotal(Integer maxTotal)
    {
        this.maxTotal = maxTotal;
    }

    public Integer getMaxWait()
    {
        return maxWait;
    }

    public void setMaxWait(Integer maxWait)
    {
        this.maxWait = maxWait;
    }

    public Integer getMaxIdle()
    {
        return maxIdle;
    }

    public void setMaxIdle(Integer maxIdle)
    {
        this.maxIdle = maxIdle;
    }

    public Integer getMinIdle()
    {
        return minIdle;
    }

    public void setMinIdle(Integer minIdle)
    {
        this.minIdle = minIdle;
    }

    public Integer getShutdown()
    {
        return shutdown;
    }

    public void setShutdown(Integer shutdown)
    {
        this.shutdown = shutdown;
    }

    public String getTopics()
    {
        return topics;
    }

    public void setTopics(String topics)
    {
        this.topics = topics;
    }

    public interface default_topic
    {
        String cacheDataChanged = "cache_data_changed";
        String configDataChanged = "config_data_changed";
    }
}
