package com.efuture.ocp.common.cache.template;

import com.jarvis.cache.ICacheManager;
import com.jarvis.cache.MSetParam;
import com.jarvis.cache.exception.CacheCenterConnectionException;
import com.jarvis.cache.to.AutoLoadConfig;
import com.jarvis.cache.to.CacheConfigTO;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;

import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class CacheTemplate
{

    private ICacheManager cacheManager;
    private AutoLoadConfig config;

    private CacheConfigTO emptyConfig = new CacheConfigTO();


    public CacheTemplate(ICacheManager cacheManager, AutoLoadConfig config)
    {
        this.cacheManager = cacheManager;
        this.config = config;
    }

    public CacheKeyTO getCacheKeyTO(String key)
    {
        return new CacheKeyTO(config.getNamespace(), key, null);
    }

    public CacheKeyTO getCacheKeyTO(String namespace, String key, String hfield)
    {
        return new CacheKeyTO(namespace, key, hfield);
    }

    public CacheWrapper<Object> getCacheWrapper(int expire, Object data)
    {
        return new CacheWrapper<>(data, expire);
    }

    public CacheConfigTO getCacheConfig(int localType, int localExpire)
    {
        CacheConfigTO config = null;

        if (localType == LOCAL_TYPE.ONLY_LOCAL) {
            config = new CacheConfigTO();
            config.setLocalCacheConfig(localExpire, true);
        }
        else if (localType == LOCAL_TYPE.ALL) {
            config = new CacheConfigTO();
            config.setLocalCacheConfig(localExpire, false);
        }
        else {
            config = this.emptyConfig;
        }

        return config;
    }

    public void set(String key, int expire, Object data) throws CacheCenterConnectionException
    {
        set(getCacheKeyTO(key), getCacheWrapper(expire, data), this.emptyConfig);
    }

    public void set(String key, int expire, Object data, int localType, int localExpire) throws CacheCenterConnectionException
    {
        set(getCacheKeyTO(key), getCacheWrapper(expire, data), getCacheConfig(localType, localExpire));
    }

    public void set(String namespace, String key, String hfield, int expire, Object data) throws CacheCenterConnectionException
    {
        set(getCacheKeyTO(namespace, key, hfield), getCacheWrapper(expire, data), this.emptyConfig);
    }

    public void set(String namespace, String key, String hfield, int expire, Object data, int localType, int localExpire) throws CacheCenterConnectionException
    {
        set(getCacheKeyTO(namespace, key, hfield), getCacheWrapper(expire, data), getCacheConfig(localType, localExpire));
    }

    public void set(CacheKeyTO cacheKey, CacheWrapper<Object> data, CacheConfigTO config) throws CacheCenterConnectionException
    {
        cacheManager.setCache(cacheKey, data, config);
    }

    public void mSet(CacheConfigTO config, Collection<MSetParam> params) throws CacheCenterConnectionException
    {
        cacheManager.mset(config, params);
    }

    public CacheWrapper<Object> getCacheWrapperData(String namespace, String key, String hfield) throws CacheCenterConnectionException
    {
        return cacheManager.get(getCacheKeyTO(namespace, key, hfield), this.emptyConfig);
    }

    public Map<String, Object> mGet(Set<String> keys) throws CacheCenterConnectionException
    {
        //cacheManager.mget()
        //TODO：批量从缓存中获取
        return null;
    }

    public Object get(String key) throws CacheCenterConnectionException
    {
        CacheWrapper<Object> data = getCacheWrapperData(config.getNamespace(), key, null);

        if (data == null) {
            return null;
        }

        return data.getCacheObject();
    }

    public void del(String key) throws CacheCenterConnectionException
    {
        del(config.getNamespace(), key, null);
    }

    public void del(String namespace, String key, String hfield) throws CacheCenterConnectionException
    {
        Set<CacheKeyTO> keys = new HashSet<>();
        CacheKeyTO cacheKey = getCacheKeyTO(namespace, key, hfield);
        keys.add(cacheKey);
        cacheManager.delete(keys);
    }


    public interface LOCAL_TYPE
    {
        int ONLY_REMOTE = 0;
        int ONLY_LOCAL = 1;
        int ALL = 2;
    }


}
