package com.efuture.ocp.common.callnumber;

import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.cache.config.CacheConfig;
import com.efuture.ocp.common.distributedLock.DLockInfo;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;

public class DistributedCallNumberHandle implements CallNumberHandle
{

    private DistributedLockHandle dLock;

    public DistributedCallNumberHandle(DistributedLockHandle dLock)
    {
        this.dLock = dLock;
    }


    /**
     * 初始化
     */
    @Override
    public void init()
    {
    }

    /**
     * 得到下一个号码
     *
     * @return 返回 -1 表示目前无号可以用
     */
    @Override
    public int next(NumberInfo num, int waitSecond)
    {
        //num.startExecute();
        boolean suc = false;
        int next = num.getCur();

        if (num.getCur() < 0) {
            next = 0;
        }

        int max = num.getMax();
        int cur = num.getCur();
        int start = num.getStart();
        String lockKey = num.getLockKey();
        long startTime = System.currentTimeMillis();
        long wait = waitSecond * 1000;

        do {
            if (next >= max) {
                next = 0;
            }

            ServiceLogs.info("NumberInfo", "叫号器[{0}]开始叫号[{1}]", 0, lockKey, next);
            String key = lockKey + ":" + next;
            DLockInfo lock = dLock.tryLock(key, CacheConfig.CacheTimeOut.HalfHour, 0);

            if (lock != null) {
                suc = true;
            }

            if (suc) {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]叫号[{1}]成功", startTime, lockKey, next);
                num.setCur(next);
                num.startExecute();
                return next;
            }
            else {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]叫号[{1}]失败,准备叫下一个", startTime, lockKey, next);
            }

            if (System.currentTimeMillis() - startTime > wait) {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]呼叫超时,直接退出", startTime, lockKey);
                break;
            }

            next = next + 1;

            //如果next 等于当前自己的号，说明已经循环了一轮了，先退出即可
            if (next == start) {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]已经循环一轮,直接退出", 0, lockKey);
                break;
            }
            else {
                ServiceLogs.info("NumberInfo", "叫号器[{0}]开始叫号[{1}]", 0, lockKey, next);
            }
        } while (!suc);

        ServiceLogs.info("NumberInfo", "叫号器[{0}]未获取到号", startTime, lockKey);
        return -1;
    }

    /**
     * 处理完毕
     */
    @Override
    public void complete(NumberInfo num)
    {
        String lockKey = num.getLockKey() + ":" + num.getCur();

        try {
            if (num.isRunning()) {
                dLock.unlock(lockKey);
            }
        }
        finally {
            num.completeExecute();
        }
    }
}
