package com.efuture.ocp.common.cache.config;


import com.efuture.ocp.common.callnumber.CallNumberExecutor;
import com.efuture.ocp.common.callnumber.CallNumberHandle;
import com.efuture.ocp.common.callnumber.DistributedCallNumberHandle;
import com.efuture.ocp.common.distributedLock.DistributedLockHandle;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class CallNumberConfig
{


    @Bean
    @ConditionalOnMissingBean(CallNumberHandle.class)
    public CallNumberHandle callNumberHandle(DistributedLockHandle lockHandle)
    {
        return new DistributedCallNumberHandle(lockHandle);
    }

    @Bean(destroyMethod = "destroy")
    public CallNumberExecutor callNumberExecutor(CallNumberHandle handle)
    {
        return new CallNumberExecutor(handle);
    }
}
