package com.efuture.ocp.common.cache.message;

import com.alibaba.fastjson.JSONObject;
import com.efuture.common.utils.ServiceLogs;
import com.efuture.ocp.common.cache.config.RedisProperty;
import org.springframework.data.redis.core.StringRedisTemplate;

public class RedisMessageUtils
{


    private StringRedisTemplate stringRedisTemplate;

    public RedisMessageUtils(StringRedisTemplate stringRedisTemplate)
    {
        this.stringRedisTemplate = stringRedisTemplate;
    }

    public void publish(String channel, String data)
    {
        stringRedisTemplate.convertAndSend(channel, data);
        ServiceLogs.debug("RedisMessage:send", "发送到redis,channel[{0}] data[{1}]", 0, channel, data);
    }

    public void publishCacheDataChangeEvent(String cacheKey)
    {
        CacheDataChangeEvent event = new CacheDataChangeEvent(cacheKey);
        publish(RedisProperty.default_topic.cacheDataChanged, JSONObject.toJSONString(event));
    }

    public void publishConfigDataChangeEvent(String configKey, String configVal)
    {
        ConfigDataChangeEvent event = new ConfigDataChangeEvent(configKey, configVal);
        publish(RedisProperty.default_topic.configDataChanged, JSONObject.toJSONString(event));
    }

}
